/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PDate;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.graphics.GraphicsState;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.commands.AlphaDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.GraphicsStateCmd;
import org.icepdf.core.pobjects.graphics.commands.PostScriptEncoder;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextMarkupAnnotation
extends MarkupAnnotation {
    private static final Logger logger;
    public static final Name SUBTYPE_HIGHLIGHT;
    public static final Name SUBTYPE_UNDERLINE;
    public static final Name SUBTYPE_SQUIGGLY;
    public static final Name SUBTYPE_STRIKE_OUT;
    private static Color highlightColor;
    private static Color strikeOutColor;
    private static Color underlineColor;
    public static final Name KEY_QUAD_POINTS;
    public static final Name EXTGSTATE_NAME;
    public static final float HIGHLIGHT_ALPHA = 0.3f;
    private Shape[] quadrilaterals;
    private Color textMarkupColor;
    private GeneralPath markupPath;
    private ArrayList<Shape> markupBounds;

    public TextMarkupAnnotation(Library l, HashMap h) {
        super(l, h);
        List quadPoints = this.library.getArray(this.entries, KEY_QUAD_POINTS);
        if (quadPoints != null) {
            int size = quadPoints.size() / 8;
            this.quadrilaterals = new Shape[size];
            int i = 0;
            int count = 0;
            while (i < size) {
                GeneralPath shape = new GeneralPath(0, 4);
                shape.moveTo(((Float)quadPoints.get(count + 6)).floatValue(), ((Float)quadPoints.get(count + 7)).floatValue());
                shape.lineTo(((Float)quadPoints.get(count + 4)).floatValue(), ((Float)quadPoints.get(count + 5)).floatValue());
                shape.lineTo(((Float)quadPoints.get(count)).floatValue(), ((Float)quadPoints.get(count + 1)).floatValue());
                shape.lineTo(((Float)quadPoints.get(count + 2)).floatValue(), ((Float)quadPoints.get(count + 3)).floatValue());
                shape.closePath();
                this.quadrilaterals[i] = shape;
                ++i;
                count += 8;
            }
        }
        if (SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
            this.textMarkupColor = highlightColor;
        } else if (SUBTYPE_STRIKE_OUT.equals(this.subtype)) {
            this.textMarkupColor = strikeOutColor;
        } else if (SUBTYPE_UNDERLINE.equals(this.subtype)) {
            this.textMarkupColor = underlineColor;
        } else if (SUBTYPE_SQUIGGLY.equals(this.subtype)) {
            // empty if block
        }
        if (this.shapes != null) {
            this.markupBounds = new ArrayList();
            this.markupPath = new GeneralPath();
            for (DrawCmd cmd : this.shapes.getShapes()) {
                if (!(cmd instanceof ShapeDrawCmd)) continue;
                ShapeDrawCmd shapeDrawCmd = (ShapeDrawCmd)cmd;
                this.markupBounds.add(shapeDrawCmd.getShape());
                this.markupPath.append(shapeDrawCmd.getShape(), false);
            }
        }
    }

    public static TextMarkupAnnotation getInstance(Library library, Rectangle rect, Name subType) {
        StateManager stateManager = library.getStateManager();
        HashMap<Name, Object> entries = new HashMap<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, subType);
        entries.put(Annotation.FLAG_KEY, 4);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        TextMarkupAnnotation textMarkupAnnotation = new TextMarkupAnnotation(library, entries);
        entries.put(NM_KEY, new LiteralStringObject(String.valueOf(textMarkupAnnotation.hashCode())));
        textMarkupAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
        textMarkupAnnotation.setNew(true);
        textMarkupAnnotation.setModifiedDate(PDate.formatDateTime(new Date()));
        return textMarkupAnnotation;
    }

    public static boolean isTextMarkupAnnotation(Name subType) {
        return SUBTYPE_HIGHLIGHT.equals(subType) || SUBTYPE_UNDERLINE.equals(subType) || SUBTYPE_SQUIGGLY.equals(subType) || SUBTYPE_STRIKE_OUT.equals(subType);
    }

    @Override
    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        Form form;
        Rectangle2D bound;
        this.matrix = new AffineTransform();
        this.shapes = new Shapes();
        AffineTransform af = new AffineTransform();
        if (this.userSpaceRectangle == null) {
            this.userSpaceRectangle = this.getUserSpaceRectangle();
        }
        af.translate(-this.userSpaceRectangle.getMinX(), -this.userSpaceRectangle.getMinY());
        BasicStroke stroke = new BasicStroke(1.0f);
        this.shapes.add(new TransformDrawCmd(af));
        this.shapes.add(new StrokeDrawCmd(stroke));
        if (SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
            this.shapes.add(new GraphicsStateCmd(EXTGSTATE_NAME));
            this.shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 0.3f)));
            this.shapes.add(new ShapeDrawCmd(this.markupPath));
            this.shapes.add(new ColorDrawCmd(this.textMarkupColor));
            this.shapes.add(new FillDrawCmd());
            this.shapes.add(new AlphaDrawCmd(AlphaComposite.getInstance(3, 1.0f)));
        } else if (SUBTYPE_STRIKE_OUT.equals(this.subtype)) {
            for (Shape shape : this.markupBounds) {
                GeneralPath strikeOutPath = new GeneralPath();
                bound = shape.getBounds2D();
                float y = (float)(bound.getMinY() + bound.getHeight() / 2.0);
                strikeOutPath.moveTo((float)bound.getMinX(), y);
                strikeOutPath.lineTo((float)bound.getMaxX(), y);
                strikeOutPath.closePath();
                this.shapes.add(new ShapeDrawCmd(strikeOutPath));
                this.shapes.add(new ColorDrawCmd(this.textMarkupColor));
                this.shapes.add(new DrawDrawCmd());
            }
        } else if (SUBTYPE_UNDERLINE.equals(this.subtype)) {
            for (Shape shape : this.markupBounds) {
                GeneralPath underlinePath = new GeneralPath();
                bound = shape.getBounds2D();
                underlinePath.moveTo((float)bound.getMinX(), (float)bound.getMinY());
                underlinePath.lineTo((float)bound.getMaxX(), (float)bound.getMinY());
                underlinePath.closePath();
                this.shapes.add(new ShapeDrawCmd(underlinePath));
                this.shapes.add(new ColorDrawCmd(this.textMarkupColor));
                this.shapes.add(new DrawDrawCmd());
            }
        } else if (SUBTYPE_SQUIGGLY.equals(this.subtype)) {
            // empty if block
        }
        ArrayList<Float> quadPoints = new ArrayList<Float>();
        if (this.markupBounds != null) {
            for (Shape shape : this.markupBounds) {
                Rectangle2D bounds = shape.getBounds2D();
                quadPoints.add(Float.valueOf((float)bounds.getX()));
                quadPoints.add(Float.valueOf((float)(bounds.getY() + bounds.getHeight())));
                quadPoints.add(Float.valueOf((float)(bounds.getX() + bounds.getWidth())));
                quadPoints.add(Float.valueOf((float)(bounds.getY() + bounds.getHeight())));
                quadPoints.add(Float.valueOf((float)bounds.getX()));
                quadPoints.add(Float.valueOf((float)bounds.getY()));
                quadPoints.add(Float.valueOf((float)(bounds.getX() + bounds.getWidth())));
                quadPoints.add(Float.valueOf((float)bounds.getY()));
            }
        }
        this.entries.put(KEY_QUAD_POINTS, quadPoints);
        this.setModifiedDate(PDate.formatDateTime(new Date()));
        StateManager stateManager = this.library.getStateManager();
        if (this.hasAppearanceStream()) {
            form = (Form)this.getAppearanceStream();
        } else {
            HashMap<Name, Name> formEntries = new HashMap<Name, Name>();
            formEntries.put(Form.TYPE_KEY, Form.TYPE_VALUE);
            formEntries.put(Form.SUBTYPE_KEY, Form.SUB_TYPE_VALUE);
            form = new Form(this.library, (HashMap)formEntries, null);
            form.setPObjectReference(stateManager.getNewReferencNumber());
            this.library.addObject(form, form.getPObjectReference());
        }
        if (form != null) {
            Rectangle2D.Float formBbox = new Rectangle2D.Float(0.0f, 0.0f, (float)this.bbox.getWidth(), (float)this.bbox.getHeight());
            form.setAppearance(this.shapes, this.matrix, formBbox);
            stateManager.addChange(new PObject(form, form.getPObjectReference()));
            if (SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
                Resources resources = form.getResources();
                HashMap<Name, Float> graphicsProperties = new HashMap<Name, Float>(2);
                HashMap<Name, HashMap<Name, Float>> graphicsState = new HashMap<Name, HashMap<Name, Float>>(1);
                graphicsProperties.put(GraphicsState.CA_STROKING_KEY, Float.valueOf(0.3f));
                graphicsProperties.put(GraphicsState.CA_NON_STROKING_KEY, Float.valueOf(0.3f));
                graphicsState.put(EXTGSTATE_NAME, graphicsProperties);
                resources.getEntries().put(Resources.EXTGSTATE_KEY, graphicsState);
                form.setResources(resources);
            }
            form.setRawBytes(PostScriptEncoder.generatePostScript(this.shapes.getShapes()));
            HashMap<Name, Reference> appearanceRefs = new HashMap<Name, Reference>();
            appearanceRefs.put(APPEARANCE_STREAM_NORMAL_KEY, form.getPObjectReference());
            this.entries.put(APPEARANCE_STREAM_KEY, appearanceRefs);
            if (compressAppearanceStream) {
                form.getEntries().put(Stream.FILTER_KEY, new Name("FlateDecode"));
            } else {
                form.getEntries().remove(Stream.FILTER_KEY);
            }
        }
    }

    @Override
    protected void renderAppearanceStream(Graphics2D g) {
        if (this.shapes != null) {
            super.renderAppearanceStream(g);
        } else if (this.quadrilaterals != null) {
            if (this.subtype != null && SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
                g.setComposite(AlphaComposite.getInstance(3, 0.3f));
                if (this.shapes != null) {
                    this.shapes.setPaintAlpha(false);
                }
            }
            Object tmp = this.getObject(RECTANGLE_KEY);
            Rectangle2D.Float rectangle = null;
            if (tmp instanceof List) {
                rectangle = this.library.getRectangle(this.entries, RECTANGLE_KEY);
            }
            Rectangle2D.Float origRect = this.getUserSpaceRectangle();
            AffineTransform af = g.getTransform();
            double x = rectangle.getX() - origRect.getX();
            double y = rectangle.getY() - origRect.getY();
            af.translate(-origRect.getX(), -origRect.getY());
            g.setTransform(af);
            g.setColor(highlightColor);
            AffineTransform af2 = new AffineTransform();
            af2.translate(-x, -y);
            for (Shape shape : this.quadrilaterals) {
                g.fill(af2.createTransformedShape(shape));
            }
            if (this.subtype != null && SUBTYPE_HIGHLIGHT.equals(this.subtype)) {
                g.setComposite(AlphaComposite.getInstance(3, 1.0f));
                if (this.shapes != null) {
                    this.shapes.setPaintAlpha(true);
                }
            }
        }
    }

    public void setMarkupPath(GeneralPath markupPath) {
        this.markupPath = markupPath;
    }

    public void setMarkupBounds(ArrayList<Shape> markupBounds) {
        this.markupBounds = markupBounds;
    }

    public Color getTextMarkupColor() {
        return this.textMarkupColor;
    }

    public void setTextMarkupColor(Color textMarkupColor) {
        this.textMarkupColor = textMarkupColor;
    }

    static {
        block8: {
            int colorValue;
            String color;
            block7: {
                block6: {
                    logger = Logger.getLogger(TextMarkupAnnotation.class.toString());
                    SUBTYPE_HIGHLIGHT = new Name("Highlight");
                    SUBTYPE_UNDERLINE = new Name("Underline");
                    SUBTYPE_SQUIGGLY = new Name("Squiggly");
                    SUBTYPE_STRIKE_OUT = new Name("StrikeOut");
                    try {
                        color = Defs.sysProperty("org.icepdf.core.views.page.annotation.textmarkup.highlight.color", "#ffff00");
                        colorValue = ColorUtil.convertColor(color);
                        highlightColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ffff00", 16));
                    }
                    catch (NumberFormatException e) {
                        if (!logger.isLoggable(Level.WARNING)) break block6;
                        logger.warning("Error reading Text Markup Annotation highlight colour");
                    }
                }
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.annotation.textmarkup.strikeOut.color", "#ff0000");
                    colorValue = ColorUtil.convertColor(color);
                    strikeOutColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ff0000", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.warning("Error reading Text Markup Annotation strike out colour");
                }
            }
            try {
                color = Defs.sysProperty("org.icepdf.core.views.page.annotation.textmarkup.underline.color", "#00ff00");
                colorValue = ColorUtil.convertColor(color);
                underlineColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("00ff00", 16));
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block8;
                logger.warning("Error reading Text Markup Annotation underline colour");
            }
        }
        KEY_QUAD_POINTS = new Name("QuadPoints");
        EXTGSTATE_NAME = new Name("ip1");
    }
}

