/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.functions.Function;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;

public class DeviceN
extends PColorSpace {
    public static final Name DEVICEN_KEY = new Name("DeviceN");
    public static final Name COLORANTS_KEY = new Name("Colorants");
    List<Name> names;
    PColorSpace alternate;
    Function tintTransform;
    HashMap<Object, Object> colorants = new HashMap();
    PColorSpace[] colorspaces;
    boolean foundCMYK;

    DeviceN(Library l, HashMap h, Object o1, Object o2, Object o3, Object o4) {
        super(l, h);
        HashMap h1;
        HashMap h2;
        this.names = (List)o1;
        this.alternate = DeviceN.getColorSpace(l, o2);
        this.tintTransform = Function.getFunction(l, l.getObject(o3));
        if (o4 != null && (h2 = (HashMap)this.library.getObject(h1 = (HashMap)this.library.getObject(o4), COLORANTS_KEY)) != null) {
            Set e = h2.keySet();
            for (Object o : e) {
                Object oo = h2.get(o);
                this.colorants.put(o, DeviceN.getColorSpace(this.library, this.library.getObject(oo)));
            }
        }
        this.colorspaces = new PColorSpace[this.names.size()];
        for (int i = 0; i < this.colorspaces.length; ++i) {
            this.colorspaces[i] = (PColorSpace)this.colorants.get(this.names.get(i).toString());
        }
        if (this.names.size() == 4) {
            int cmykCount = 0;
            for (Name name : this.names) {
                if (name.getName().toLowerCase().startsWith("c")) {
                    ++cmykCount;
                } else if (name.getName().toLowerCase().startsWith("m")) {
                    ++cmykCount;
                } else if (name.getName().toLowerCase().startsWith("y")) {
                    ++cmykCount;
                } else if (name.getName().toLowerCase().startsWith("b")) {
                    ++cmykCount;
                }
                if (cmykCount != 4) continue;
                this.foundCMYK = true;
            }
        }
    }

    public int getNumComponents() {
        return this.names.size();
    }

    public Color getColor(float[] f) {
        if (this.foundCMYK) {
            return new DeviceCMYK(null, null).getColor(f);
        }
        float[] y = this.tintTransform.calculate(f);
        return this.alternate.getColor(DeviceN.reverse(y));
    }
}

