/*
 * Copyright 2006-2013 ICEsoft Technologies Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the
 * License. You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS
 * IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package org.icepdf.core.util;

/**
 *
 */
public final class PdfOps {

    // Path Tokens
    public static final String m_TOKEN = "m";
    public static final String l_TOKEN = "l";
    public static final String c_TOKEN = "c";
    public static final String v_TOKEN = "v";
    public static final String y_TOKEN = "y";
    public static final String h_TOKEN = "h";
    public static final String re_TOKEN = "re";

    // Path Painting
    public static final String S_TOKEN = "S";
    public static final String s_TOKEN = "s";
    public static final String f_TOKEN = "f";
    public static final String F_TOKEN = "F";
    public static final String f_STAR_TOKEN = "f*";
    public static final String B_TOKEN = "B";
    public static final String b_TOKEN = "b";
    public static final String B_STAR_TOKEN = "B*";
    public static final String b_STAR_TOKEN = "b*";

    // external object
    public static final String Do_TOKEN = "Do";

    // clipping
    public static final String n_TOKEN = "n";
    public static final String W_TOKEN = "W";
    public static final String W_STAR_TOKEN = "W*";

    // compatibility
    public static final String BX_TOKEN = "BX";
    public static final String EX_TOKEN = "EX";

    // Marked Content
    public static final String BDC_TOKEN = "BDC";
    public static final String BMC_TOKEN = "BMC";
    public static final String EMC_TOKEN = "EMC";

    // marked content
    public static final String DP_TOKEN = "DP";
    public static final String MP_TOKEN = "MP";

    // General Path Stats
    public static final String ri_TOKEN = "ri";
    public static final String sh_TOKEN = "sh";
    public static final String d0_TOKEN = "d0";
    public static final String d1_TOKEN = "d1";

    // text tokens
    public static final String BT_TOKEN = "BT";
    public static final String ET_TOKEN = "ET";
    public static final String Tm_TOKEN = "Tm";
    public static final String Td_TOKEN = "Td";
    public static final String TD_TOKEN = "TD";
    public static final String T_STAR_TOKEN = "T*";
    public static final String Tj_TOKEN = "Tj";
    public static final String Tc_TOKEN = "Tc";
    public static final String Tz_TOKEN = "Tz";
    public static final String Tw_TOKEN = "Tw";
    public static final String Tr_TOKEN = "Tr";
    public static final String TL_TOKEN = "TL";
    public static final String Ts_TOKEN = "Ts";
    public static final String TJ_TOKEN = "TJ";
    public static final String Tf_TOKEN = "Tf";
    public static final String SINGLE_QUOTE_TOKEN = "'";
    public static final String DOUBLE_QUOTE__TOKEN = "\"";

    // Color State
    public static final String G_TOKEN = "G";
    public static final String g_TOKEN = "g";
    public static final String RG_TOKEN = "RG";
    public static final String rg_TOKEN = "rg";
    public static final String K_TOKEN = "K";
    public static final String k_TOKEN = "k";
    public static final String CS_TOKEN = "CS";
    public static final String cs_TOKEN = "cs";
    public static final String SC_TOKEN = "SC";
    public static final String SCN_TOKEN = "SCN";
    public static final String sc_TOKEN = "sc";
    public static final String scn_TOKEN = "scn";

    // Graphics STate
    public static final String q_TOKEN = "q";
    public static final String Q_TOKEN = "Q";
    public static final String cm_TOKEN = "cm";
    public static final String i_TOKEN = "i";
    public static final String J_TOKEN = "J";
    public static final String j_TOKEN = "j";
    public static final String d_TOKEN = "d";
    public static final String w_TOKEN = "w";
    public static final String LW_TOKEN = "LW";
    public static final String M_TOKEN = "M";
    public static final String gs_TOKEN = "gs";

    // Inline Images
    public static final String BI_TOKEN = "BI";
    public static final String ID_TOKEN = "ID";
    public static final String BPC_TOKEN = "BPC";
    public static final String BPC_NAME = "BitsPerComponent";
    public static final String CS_NAME = "ColorSpace";
    public static final String D_TOKEN = "D";
    public static final String D_NAME = "Decode";
    public static final String DP_NAME = "DecodeParms";
    public static final String F_NAME = "Filter";
    public static final String H_TOKEN = "H";
    public static final String H_NAME = "Height";
    public static final String IM_TOKEN = "IM";
    public static final String IM_NAME = "ImageMask";
    public static final String I_TOKEN = "I";
    public static final String I_NAME = "Indexed";
    public static final String W_NAME = "Width";
}
