/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Stack;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.acroform.FieldDictionary;
import org.icepdf.core.pobjects.graphics.DeviceCMYK;
import org.icepdf.core.pobjects.graphics.PColorSpace;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.Parser;
import org.icepdf.core.util.Utils;

public class VariableTextFieldDictionary
extends FieldDictionary {
    private static final Logger logger = Logger.getLogger(VariableTextFieldDictionary.class.toString());
    public static final Name DA_KEY = new Name("DA");
    public static final Name Q_KEY = new Name("Q");
    public static final Name DS_KEY = new Name("DS");
    private String defaultAppearance;
    private String defaultStyle;
    private String defaultRichText;
    public static final Name RV_KEY = new Name("RV");
    protected Quadding quadding = Quadding.LEFT_JUSTIFIED;
    protected int size = 12;
    protected String fontName = "Helvetic";
    protected Color color = Color.BLACK;

    public VariableTextFieldDictionary(Library library, HashMap entries) {
        super(library, entries);
        Integer value = library.getInt(entries, Q_KEY);
        int quad = value;
        switch (quad) {
            case 0: {
                this.quadding = Quadding.LEFT_JUSTIFIED;
                break;
            }
            case 1: {
                this.quadding = Quadding.CENTERED;
                break;
            }
            case 2: {
                this.quadding = Quadding.RIGHT_JUSTIFIED;
                break;
            }
            default: {
                this.quadding = Quadding.LEFT_JUSTIFIED;
            }
        }
        Object tmp = library.getObject(entries, DS_KEY);
        if (tmp != null) {
            this.defaultStyle = Utils.convertStringObject(library, (StringObject)tmp);
        }
        if ((tmp = library.getObject(entries, RV_KEY)) != null) {
            if (tmp instanceof StringObject) {
                this.defaultStyle = Utils.convertStringObject(library, (StringObject)tmp);
            } else if (tmp instanceof Stream) {
                this.defaultStyle = new String(((Stream)tmp).getDecodedStreamBytes());
            }
        }
        if ((tmp = library.getObject(entries, DA_KEY)) instanceof StringObject) {
            this.defaultAppearance = Utils.convertStringObject(library, (StringObject)tmp);
            Parser parser = new Parser(new ByteArrayInputStream(this.defaultAppearance.getBytes()));
            try {
                Object token = parser.getToken();
                while (token != null) {
                    if (token instanceof Name) {
                        this.fontName = ((Name)token).getName();
                    } else if (token instanceof Number) {
                        this.size = ((Number)token).intValue();
                        if (this.size == 0) {
                            this.size = 12;
                        }
                    } else if (token instanceof String) {
                        token = parser.getToken();
                        Stack<Object> stack = new Stack<Object>();
                        while (token instanceof Number) {
                            stack.push(token);
                            token = parser.getToken();
                        }
                        if (stack.size() == 1) {
                            float gray = ((Number)stack.pop()).floatValue();
                            gray = gray > 1.0f ? gray / 255.0f : gray;
                            this.color = new Color(gray, gray, gray);
                        } else if (stack.size() == 3) {
                            float b = ((Number)stack.pop()).floatValue();
                            float gg = ((Number)stack.pop()).floatValue();
                            float r = ((Number)stack.pop()).floatValue();
                            b = Math.max(0.0f, Math.min(1.0f, b));
                            gg = Math.max(0.0f, Math.min(1.0f, gg));
                            r = Math.max(0.0f, Math.min(1.0f, r));
                            this.color = new Color(r, gg, b);
                        } else if (stack.size() == 4) {
                            float k = ((Number)stack.pop()).floatValue();
                            float y = ((Number)stack.pop()).floatValue();
                            float m = ((Number)stack.pop()).floatValue();
                            float c = ((Number)stack.pop()).floatValue();
                            PColorSpace pColorSpace = PColorSpace.getColorSpace(library, DeviceCMYK.DEVICECMYK_KEY);
                            this.color = pColorSpace.getColor(PColorSpace.reverse(new float[]{c, m, y, k}), true);
                        }
                    }
                    token = parser.getToken();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public int getSize() {
        return this.size;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public Color getColor() {
        return this.color;
    }

    public Quadding getQuadding() {
        return this.quadding;
    }

    public String getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public String getDefaultStyle() {
        return this.defaultStyle;
    }

    public String getDefaultRichText() {
        return this.defaultRichText;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quadding {
        LEFT_JUSTIFIED,
        CENTERED,
        RIGHT_JUSTIFIED;

    }
}

