/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.Resources;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.acroform.InteractiveForm;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.util.Library;
import org.icepdf.core.util.content.ContentParser;
import org.icepdf.core.util.content.ContentParserFactory;

public class AppearanceState
extends Dictionary {
    private static final Logger logger = Logger.getLogger(AppearanceState.class.toString());
    protected Shapes shapes;
    protected AffineTransform matrix;
    protected Rectangle2D bbox;
    protected String originalContentStream;
    protected Resources resources;

    public AppearanceState(Library library, HashMap entries, Object streamOrDictionary) {
        super(library, entries);
        if (streamOrDictionary instanceof Reference) {
            streamOrDictionary = library.getObject((Reference)streamOrDictionary);
        }
        if (streamOrDictionary instanceof Form) {
            Form form = (Form)streamOrDictionary;
            form.init();
            this.originalContentStream = new String(((Form)streamOrDictionary).getDecodedStreamBytes());
            this.resources = form.getResources();
            this.shapes = form.getShapes();
            this.matrix = form.getMatrix();
            this.bbox = form.getBBox();
        } else if (streamOrDictionary instanceof Stream) {
            Stream stream = (Stream)streamOrDictionary;
            this.resources = library.getResources(stream.getEntries(), Annotation.RESOURCES_VALUE);
            this.bbox = library.getRectangle(stream.getEntries(), Annotation.BBOX_VALUE);
            this.matrix = new AffineTransform();
            this.originalContentStream = new String(stream.getDecodedStreamBytes());
            try {
                ContentParser cp = ContentParserFactory.getInstance().getContentParser(library, this.resources);
                this.shapes = cp.parse(new byte[][]{stream.getDecodedStreamBytes()}, null).getShapes();
            }
            catch (Exception e) {
                this.shapes = new Shapes();
                logger.log(Level.FINE, "Error initializing Page.", e);
            }
        }
    }

    public AppearanceState(Library library, HashMap entries) {
        super(library, entries);
        this.matrix = new AffineTransform();
        this.bbox = (Rectangle2D)library.getObject(entries, Annotation.BBOX_VALUE);
        InteractiveForm form = library.getCatalog().getInteractiveForm();
        if (form != null) {
            this.resources = form.getResources();
        }
    }

    public Shapes getShapes() {
        return this.shapes;
    }

    public void setShapes(Shapes shapes) {
        this.shapes = shapes;
    }

    public AffineTransform getMatrix() {
        return this.matrix;
    }

    public void setMatrix(AffineTransform matrix) {
        this.matrix = matrix;
    }

    public Rectangle2D getBbox() {
        return this.bbox;
    }

    public void setBbox(Rectangle2D bbox) {
        this.bbox = bbox;
    }

    public Resources getResources() {
        return this.resources;
    }

    public String getOriginalContentStream() {
        return this.originalContentStream;
    }

    public void setContentStream(byte[] contentBytes) {
        try {
            ContentParser cp = ContentParserFactory.getInstance().getContentParser(this.library, this.resources);
            this.shapes = cp.parse(new byte[][]{contentBytes}, null).getShapes();
        }
        catch (Exception e) {
            this.shapes = new Shapes();
            logger.log(Level.FINE, "Error initializing Page.", e);
        }
    }
}

