/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DefaultStyledDocument;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Form;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.PObject;
import org.icepdf.core.pobjects.PRectangle;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StateManager;
import org.icepdf.core.pobjects.Stream;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.Appearance;
import org.icepdf.core.pobjects.annotations.AppearanceState;
import org.icepdf.core.pobjects.annotations.MarkupAnnotation;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.pobjects.fonts.FontManager;
import org.icepdf.core.pobjects.fonts.ofont.Font;
import org.icepdf.core.pobjects.graphics.Shapes;
import org.icepdf.core.pobjects.graphics.TextSprite;
import org.icepdf.core.pobjects.graphics.commands.ColorDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawCmd;
import org.icepdf.core.pobjects.graphics.commands.DrawDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.FillDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.PostScriptEncoder;
import org.icepdf.core.pobjects.graphics.commands.ShapeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.StrokeDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TextSpriteDrawCmd;
import org.icepdf.core.pobjects.graphics.commands.TransformDrawCmd;
import org.icepdf.core.util.ColorUtil;
import org.icepdf.core.util.Defs;
import org.icepdf.core.util.Library;

public class FreeTextAnnotation
extends MarkupAnnotation {
    private static final Logger logger;
    public static final Name DA_KEY;
    public static final Name Q_KEY;
    public static final Name DS_KEY;
    public static final Name CL_KEY;
    public static final Name BE_KEY;
    public static final Name RD_KEY;
    public static final Name BS_KEY;
    public static final Name LE_KEY;
    public static final int QUADDING_LEFT_JUSTIFIED = 0;
    public static final int QUADDING_CENTER_JUSTIFIED = 1;
    public static final int QUADDING_RIGHT_JUSTIFIED = 2;
    public static final Name EMBEDDED_FONT_NAME;
    protected static Color defaultFontColor;
    protected static Color defaultFillColor;
    protected static int defaultFontSize;
    protected String defaultAppearance;
    protected int quadding = 0;
    protected String defaultStylingString;
    protected boolean hideRenderedOutput;
    protected String richText;
    private String fontName = "Helvetica";
    private int fontStyle = 0;
    private int fontSize = defaultFontSize;
    private Color fontColor = defaultFontColor;
    private boolean fillType = false;
    private Color fillColor = defaultFillColor;
    private boolean strokeType = false;
    protected DefaultStyledDocument document;
    protected FontFile fontFile;
    protected boolean fontPropertyChanged;
    public static final String BODY_START = "<?xml version=\"1.0\"?><body xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:xfa=\"http://www.xfa.org/schema/xfa-data/1.0/\" xfa:APIVersion=\"Acrobat:11.0.0\" xfa:spec=\"2.0.2\"  style=\"{0}\">";
    public static final String BODY_END = "</body>";

    public FreeTextAnnotation(Library l, HashMap h) {
        super(l, h);
    }

    public void init() {
        Object tmp;
        super.init();
        Appearance appearance = (Appearance)this.appearances.get(APPEARANCE_STREAM_NORMAL_KEY);
        Shapes shapes = null;
        if (appearance != null) {
            AppearanceState appearanceState = appearance.getSelectedAppearanceState();
            shapes = appearanceState.getShapes();
        }
        if (this.library.getObject(this.entries, COLOR_KEY) != null && this.getObject(APPEARANCE_STREAM_KEY) != null) {
            if (shapes != null) {
                Color currentColor = Color.BLACK;
                for (DrawCmd drawCmd : shapes.getShapes()) {
                    if (drawCmd instanceof ColorDrawCmd) {
                        currentColor = ((ColorDrawCmd)drawCmd).getColor();
                        continue;
                    }
                    if (drawCmd instanceof FillDrawCmd) {
                        this.fillType = true;
                        this.fillColor = new Color(currentColor.getRGB());
                        continue;
                    }
                    if (!(drawCmd instanceof DrawDrawCmd)) continue;
                    this.strokeType = true;
                    this.color = new Color(currentColor.getRGB());
                }
            }
        } else {
            this.color = Color.BLACK;
        }
        this.defaultAppearance = this.library.getString(this.entries, DA_KEY);
        if (this.library.getObject(this.entries, Q_KEY) != null) {
            this.quadding = this.library.getInt(this.entries, Q_KEY);
        }
        if ((tmp = this.library.getObject(this.entries, RC_KEY)) != null && tmp instanceof StringObject) {
            StringObject tmpRichText = (StringObject)tmp;
            this.richText = tmpRichText.getLiteralString();
        }
        if (this.library.getObject(this.entries, DS_KEY) != null) {
            this.defaultStylingString = this.library.getString(this.entries, DS_KEY);
        }
        if (this.library.getObject(this.entries, Q_KEY) == null) {
            this.entries.put(Q_KEY, 0);
        }
        if (this.library.getObject(this.entries, IT_KEY) == null) {
            this.entries.put(IT_KEY, new Name("FreeText"));
        }
        if (this.defaultStylingString != null) {
            StringTokenizer toker = new StringTokenizer(this.defaultStylingString, ";");
            while (toker.hasMoreElements()) {
                String cssProperty = (String)toker.nextElement();
                if (cssProperty != null && cssProperty.contains("font-family")) {
                    this.fontName = cssProperty.substring(cssProperty.indexOf(":") + 1).trim();
                    continue;
                }
                if (cssProperty != null && cssProperty.contains("color")) {
                    String colorString = cssProperty.substring(cssProperty.indexOf(":") + 1).trim();
                    this.fontColor = new Color(ColorUtil.convertColor(colorString));
                    continue;
                }
                if (cssProperty != null && cssProperty.contains("font-weight")) {
                    String fontStyle = cssProperty.substring(cssProperty.indexOf(":") + 1).trim();
                    if (fontStyle.equals("normal")) {
                        this.fontStyle = 0;
                        continue;
                    }
                    if (fontStyle.equals("italic")) {
                        this.fontStyle = 2;
                        continue;
                    }
                    if (!fontStyle.equals("bold")) continue;
                    this.fontStyle = 1;
                    continue;
                }
                if (cssProperty == null || !cssProperty.contains("font-size")) continue;
                String fontSize = cssProperty.substring(cssProperty.indexOf(":") + 1).trim();
                fontSize = fontSize.substring(0, fontSize.indexOf(112));
                try {
                    this.fontSize = (int)Float.parseFloat(fontSize);
                }
                catch (NumberFormatException e) {
                    logger.finer("Error parsing font size: " + fontSize);
                }
            }
        }
        this.resetNullAppearanceStream();
    }

    public static FreeTextAnnotation getInstance(Library library, Rectangle rect) {
        StateManager stateManager = library.getStateManager();
        HashMap<Name, Object> entries = new HashMap<Name, Object>();
        entries.put(Dictionary.TYPE_KEY, Annotation.TYPE_VALUE);
        entries.put(Dictionary.SUBTYPE_KEY, Annotation.SUBTYPE_FREE_TEXT);
        if (rect != null) {
            entries.put(Annotation.RECTANGLE_KEY, PRectangle.getPRectangleVector(rect));
        } else {
            entries.put(Annotation.RECTANGLE_KEY, new Rectangle(10, 10, 50, 100));
        }
        FreeTextAnnotation freeTextAnnotation = new FreeTextAnnotation(library, entries);
        freeTextAnnotation.init();
        freeTextAnnotation.setPObjectReference(stateManager.getNewReferencNumber());
        freeTextAnnotation.setNew(true);
        freeTextAnnotation.setFlag(64, false);
        freeTextAnnotation.setFlag(16, false);
        freeTextAnnotation.setFlag(8, false);
        freeTextAnnotation.setFlag(4, true);
        return freeTextAnnotation;
    }

    public void render(Graphics2D origG, int renderHintType, float totalRotation, float userZoom, boolean tabSelected) {
        if (!this.hideRenderedOutput) {
            super.render(origG, renderHintType, totalRotation, userZoom, tabSelected);
        }
    }

    public void resetAppearanceStream(double dx, double dy, AffineTransform pageTransform) {
        String[] lines;
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        Rectangle2D bbox = appearanceState.getBbox();
        AffineTransform matrix = appearanceState.getMatrix();
        Shapes shapes = appearanceState.getShapes();
        if (shapes == null) {
            shapes = new Shapes();
            appearanceState.setShapes(shapes);
        } else {
            appearanceState.getShapes().getShapes().clear();
        }
        shapes.getShapes().clear();
        AffineTransform af = new AffineTransform();
        af.scale(1.0, -1.0);
        af.translate(-bbox.getMinX(), -bbox.getMaxY());
        double insets = 5.0 * pageTransform.getScaleX();
        af.translate(insets, -insets);
        shapes.add(new TransformDrawCmd(af));
        if (this.fontFile == null || this.fontPropertyChanged) {
            this.fontFile = FontManager.getInstance().initialize().getInstance(this.fontName, 0);
            this.fontPropertyChanged = false;
        }
        this.fontFile = this.fontFile.deriveFont(this.fontSize);
        this.fontFile.echarAdvance(' ');
        TextSprite textSprites = new TextSprite(this.fontFile, this.content.length(), new AffineTransform(), null);
        textSprites.setRMode(0);
        textSprites.setStrokeColor(this.fontColor);
        textSprites.setFontName(EMBEDDED_FONT_NAME.toString());
        textSprites.setFontSize(this.fontSize);
        StringBuilder contents = new StringBuilder(this.content);
        float lineHeight = (float)(this.fontFile.getAscent() + this.fontFile.getDescent());
        float advanceX = (float)bbox.getMinX();
        float advanceY = (float)bbox.getMinY();
        float currentY = advanceY + lineHeight;
        float lastx = 0.0f;
        int max = contents.length();
        for (int i = 0; i < max; ++i) {
            char currentChar = contents.charAt(i);
            float newAdvanceX = (float)this.fontFile.echarAdvance(currentChar).getX();
            float currentX = advanceX + lastx;
            lastx += newAdvanceX;
            if (currentChar != '\n' && currentChar != '\r') {
                textSprites.addText(String.valueOf(currentChar), String.valueOf(currentChar), currentX, currentY, newAdvanceX);
                continue;
            }
            currentY += lineHeight;
            advanceX = (float)bbox.getMinX();
            lastx = 0.0f;
        }
        BasicStroke stroke = this.strokeType && this.borderStyle.isStyleDashed() ? new BasicStroke(this.borderStyle.getStrokeWidth(), 0, 0, this.borderStyle.getStrokeWidth() * 2.0f, this.borderStyle.getDashArray(), 0.0f) : new BasicStroke(this.borderStyle.getStrokeWidth());
        shapes.add(new ShapeDrawCmd(new Rectangle2D.Double(bbox.getX(), bbox.getY() + 10.0, bbox.getWidth() - 10.0, bbox.getHeight() - 10.0)));
        if (this.fillType) {
            shapes.add(new ColorDrawCmd(this.fillColor));
            shapes.add(new FillDrawCmd());
        }
        if (this.strokeType) {
            shapes.add(new StrokeDrawCmd(stroke));
            shapes.add(new ColorDrawCmd(this.color));
            shapes.add(new DrawDrawCmd());
        }
        shapes.add(new ColorDrawCmd(this.fontColor));
        shapes.add(new TextSpriteDrawCmd(textSprites));
        StateManager stateManager = this.library.getStateManager();
        Form form = this.getOrGenerateAppearanceForm();
        if (form != null) {
            org.icepdf.core.pobjects.fonts.Font newFont;
            Rectangle2D.Float formBbox = new Rectangle2D.Float(0.0f, 0.0f, (float)bbox.getWidth(), (float)bbox.getHeight());
            form.setAppearance(shapes, matrix, formBbox);
            stateManager.addChange(new PObject(form, form.getPObjectReference()));
            form.setRawBytes(PostScriptEncoder.generatePostScript(shapes.getShapes()));
            HashMap<Name, Reference> appearanceRefs = new HashMap<Name, Reference>();
            appearanceRefs.put(APPEARANCE_STREAM_NORMAL_KEY, form.getPObjectReference());
            this.entries.put(APPEARANCE_STREAM_KEY, appearanceRefs);
            if (compressAppearanceStream) {
                form.getEntries().put(Stream.FILTER_KEY, new Name("FlateDecode"));
            } else {
                form.getEntries().remove(Stream.FILTER_KEY);
            }
            HashMap<Name, Object> fontDictionary = new HashMap<Name, Object>();
            fontDictionary.put(org.icepdf.core.pobjects.fonts.Font.TYPE_KEY, org.icepdf.core.pobjects.fonts.Font.SUBTYPE_KEY);
            fontDictionary.put(org.icepdf.core.pobjects.fonts.Font.SUBTYPE_KEY, new Name("Type1"));
            fontDictionary.put(org.icepdf.core.pobjects.fonts.Font.NAME_KEY, EMBEDDED_FONT_NAME);
            fontDictionary.put(org.icepdf.core.pobjects.fonts.Font.BASEFONT_KEY, new Name(this.fontName));
            fontDictionary.put(org.icepdf.core.pobjects.fonts.Font.ENCODING_KEY, new Name("WinAnsiEncoding"));
            fontDictionary.put(new Name("FirstChar"), 32);
            fontDictionary.put(new Name("LastChar"), 255);
            if (form.getResources() == null || form.getResources().getFont(EMBEDDED_FONT_NAME) == null) {
                newFont = new Font(this.library, fontDictionary);
                newFont.setPObjectReference(stateManager.getNewReferencNumber());
                HashMap<Name, Reference> fontResources = new HashMap<Name, Reference>();
                fontResources.put(EMBEDDED_FONT_NAME, newFont.getPObjectReference());
                HashMap<Name, HashMap<Name, Reference>> resources = new HashMap<Name, HashMap<Name, Reference>>();
                resources.put(new Name("Font"), fontResources);
                form.getEntries().put(new Name("Resources"), resources);
                form.setRawBytes("".getBytes());
                form.init();
            } else {
                form.init();
                newFont = form.getResources().getFont(EMBEDDED_FONT_NAME);
                Reference reference = newFont.getPObjectReference();
                newFont = new Font(this.library, fontDictionary);
                newFont.setPObjectReference(reference);
            }
            stateManager.addChange(new PObject(newFont, newFont.getPObjectReference()));
            this.library.addObject(newFont, newFont.getPObjectReference());
        }
        StringBuilder dsString = new StringBuilder("font-size:").append(this.fontSize).append("pt;").append("font-family:").append(this.fontName).append(";").append("color:").append(ColorUtil.convertColorToRGB(this.fontColor)).append(";");
        if (this.fontStyle == 1) {
            dsString.append("font-weight:bold;");
        }
        if (this.fontStyle == 2) {
            dsString.append("font-style:italic;");
        }
        if (this.fontStyle == 0) {
            dsString.append("font-style:normal;");
        }
        this.entries.put(DS_KEY, new LiteralStringObject(dsString.toString()));
        if (this.fillType) {
            Color color = this.color;
            if (this.entries.get(APPEARANCE_STREAM_KEY) == null) {
                color = this.fillColor;
            }
            float[] compArray = new float[3];
            color.getColorComponents(compArray);
            ArrayList<Float> colorValues = new ArrayList<Float>(compArray.length);
            for (float comp : compArray) {
                colorValues.add(Float.valueOf(comp));
            }
            this.entries.put(COLOR_KEY, colorValues);
        } else {
            this.entries.remove(COLOR_KEY);
        }
        this.entries.put(CONTENTS_KEY, new LiteralStringObject(this.content));
        Object[] colorArgument = new Object[]{dsString};
        MessageFormat formatter = new MessageFormat(BODY_START);
        StringBuilder rcString = new StringBuilder(formatter.format(colorArgument));
        for (String line : lines = this.content.split("[\\r\\n]+")) {
            rcString.append("<p>").append(line).append("</p>");
        }
        rcString.append(BODY_END);
        this.entries.put(RC_KEY, new LiteralStringObject(rcString.toString()));
    }

    public String getDefaultStylingString() {
        return this.defaultStylingString;
    }

    public void clearShapes() {
        Appearance appearance = (Appearance)this.appearances.get(this.currentAppearance);
        AppearanceState appearanceState = appearance.getSelectedAppearanceState();
        appearanceState.setShapes(null);
    }

    public void setDocument(DefaultStyledDocument document) {
        this.document = document;
    }

    public boolean isHideRenderedOutput() {
        return this.hideRenderedOutput;
    }

    public void setHideRenderedOutput(boolean hideRenderedOutput) {
        this.hideRenderedOutput = hideRenderedOutput;
    }

    public String getDefaultAppearance() {
        return this.defaultAppearance;
    }

    public void setDefaultAppearance(String defaultAppearance) {
        this.defaultAppearance = defaultAppearance;
    }

    public int getQuadding() {
        return this.quadding;
    }

    public void setQuadding(int quadding) {
        this.quadding = quadding;
    }

    public String getRichText() {
        return this.richText;
    }

    public void setRichText(String richText) {
        this.richText = richText;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = new Color(fontColor.getRGB());
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = new Color(fillColor.getRGB());
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
        this.fontPropertyChanged = true;
    }

    public int getFontStyle() {
        return this.fontStyle;
    }

    public void setFontStyle(int fontStyle) {
        this.fontStyle = fontStyle;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.fontPropertyChanged = true;
    }

    public boolean isFillType() {
        return this.fillType;
    }

    public boolean isFontPropertyChanged() {
        return this.fontPropertyChanged;
    }

    public void setFillType(boolean fillType) {
        this.fillType = fillType;
    }

    public boolean isStrokeType() {
        return this.strokeType;
    }

    public void setStrokeType(boolean strokeType) {
        this.strokeType = strokeType;
    }

    static {
        block8: {
            block7: {
                int colorValue;
                String color;
                block6: {
                    logger = Logger.getLogger(FreeTextAnnotation.class.toString());
                    DA_KEY = new Name("DA");
                    Q_KEY = new Name("Q");
                    DS_KEY = new Name("DS");
                    CL_KEY = new Name("CL");
                    BE_KEY = new Name("BE");
                    RD_KEY = new Name("RD");
                    BS_KEY = new Name("BS");
                    LE_KEY = new Name("LE");
                    EMBEDDED_FONT_NAME = new Name("ice1");
                    try {
                        color = Defs.sysProperty("org.icepdf.core.views.page.annotation.freeText.font.color", "#000000");
                        colorValue = ColorUtil.convertColor(color);
                        defaultFontColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("000000", 16));
                    }
                    catch (NumberFormatException e) {
                        if (!logger.isLoggable(Level.WARNING)) break block6;
                        logger.warning("Error reading free text annotation font colour");
                    }
                }
                try {
                    color = Defs.sysProperty("org.icepdf.core.views.page.annotation.freeText.fill.color", "#ffffff");
                    colorValue = ColorUtil.convertColor(color);
                    defaultFillColor = new Color(colorValue >= 0 ? colorValue : Integer.parseInt("ffffff", 16));
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block7;
                    logger.warning("Error reading free text annotation fill colour");
                }
            }
            try {
                defaultFontSize = Defs.sysPropertyInt("org.icepdf.core.views.page.annotation.freeText.font.size", 24);
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block8;
                logger.warning("Error reading free text annotation fill colour");
            }
        }
    }
}

