/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jpa.impl;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.persistence.Embeddable;
import org.infinispan.persistence.jpa.JpaStoreException;

@Embeddable
public class MetadataEntityKey
implements Serializable {
    private static final long serialVersionUID = 73757405630621L;
    private static final String DIGEST_ALG = "SHA-256";
    private String keySha;

    public MetadataEntityKey() {
    }

    public MetadataEntityKey(byte[] keyBytes) {
        this.keySha = MetadataEntityKey.getKeyBytesSha(keyBytes);
    }

    public String getKeySha() {
        return this.keySha;
    }

    public void setKeySha(String keySha) {
        this.keySha = keySha;
    }

    public boolean equals(Object o) {
        if (!(o instanceof MetadataEntityKey)) {
            return false;
        }
        return this.keySha.equals(((MetadataEntityKey)o).getKeySha());
    }

    public int hashCode() {
        return this.keySha.hashCode();
    }

    public static String getKeyBytesSha(byte[] keyBytes) {
        String keyBytesSha;
        try {
            MessageDigest digest = MessageDigest.getInstance(DIGEST_ALG);
            byte[] sha = digest.digest(keyBytes);
            keyBytesSha = Base64.getEncoder().encodeToString(sha);
        }
        catch (NoSuchAlgorithmException e) {
            throw new JpaStoreException("Failed to create SHA hash of metadata key", e);
        }
        return keyBytesSha;
    }

    public String toString() {
        return "MetadataEntityKey{keySha='" + this.keySha + "'}";
    }
}

