/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.CacheCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="index", description="Performs operations on indexes", activator=ConnectionActivator.class, groupCommands={Reindex.class, Clear.class, Stats.class, Metamodel.class, UpdateIndex.class, ClearStats.class})
public class Index
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        commandInvocation.println(commandInvocation.getHelpInfo());
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="clear-stats", description="Clears cache indexing and search statistics.", activator=ConnectionActivator.class)
    public static class ClearStats
    extends RestCliCommand {
        @Argument(description="Specifies which cache statistics to clear.", completer=CacheCompleter.class, required=true)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).clearSearchStats();
        }
    }

    @CommandDefinition(name="stats", description="Displays indexing and search statistics for a cache.", activator=ConnectionActivator.class)
    public static class Stats
    extends RestCliCommand {
        @Argument(description="Specifies which cache statistics to display.", completer=CacheCompleter.class, required=true)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).searchStats();
        }
    }

    @CommandDefinition(name="metamodel", description="Displays the index metamodel for a cache.", activator=ConnectionActivator.class)
    public static class Metamodel
    extends RestCliCommand {
        @Argument(description="Specifies which cache statistics to display.", completer=CacheCompleter.class, required=true)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).indexMetamodel();
        }
    }

    @CommandDefinition(name="update-schema", description="Update index schema for a given cache.", activator=ConnectionActivator.class)
    public static class UpdateIndex
    extends RestCliCommand {
        @Argument(description="Specifies which cache to update its index schema.", completer=CacheCompleter.class, required=true)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).updateIndexSchema();
        }
    }

    @CommandDefinition(name="clear", description="Clears a cache index.", activator=ConnectionActivator.class)
    public static class Clear
    extends RestCliCommand {
        @Argument(description="Specifies which cache index to clear.", completer=CacheCompleter.class, required=true)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).clearIndex();
        }
    }

    @CommandDefinition(name="reindex", description="Reindexes a cache.", activator=ConnectionActivator.class)
    public static class Reindex
    extends RestCliCommand {
        @Argument(description="Specifies which cache to reindex.", completer=CacheCompleter.class, required=true)
        String cache;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        public boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.cache(this.cache).reindex();
        }
    }
}

