/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.commands.rest;

import java.util.List;
import java.util.concurrent.CompletionStage;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandResult;
import org.aesh.command.GroupCommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.command.option.Option;
import org.aesh.command.option.OptionList;
import org.infinispan.cli.activators.ConnectionActivator;
import org.infinispan.cli.commands.CliCommand;
import org.infinispan.cli.commands.rest.RestCliCommand;
import org.infinispan.cli.completers.AuthorizationPermissionCompleter;
import org.infinispan.cli.completers.RolesCompleter;
import org.infinispan.cli.impl.ContextAwareCommandInvocation;
import org.infinispan.cli.resources.Resource;
import org.infinispan.client.rest.RestClient;
import org.infinispan.client.rest.RestResponse;

@GroupCommandDefinition(name="roles", description="Manages user roles for security authorization", activator=ConnectionActivator.class, groupCommands={Ls.class, Grant.class, Deny.class, Create.class, Remove.class})
public class Roles
extends CliCommand {
    @Option(shortName=104, hasValue=false, overrideRequired=true)
    protected boolean help;

    @Override
    public boolean isHelp() {
        return this.help;
    }

    @Override
    public CommandResult exec(ContextAwareCommandInvocation commandInvocation) {
        commandInvocation.println(commandInvocation.getHelpInfo());
        return CommandResult.SUCCESS;
    }

    @CommandDefinition(name="remove", aliases={"rm"}, description="Deletes an existing role.")
    public static class Remove
    extends RestCliCommand {
        @Argument(description="Specifies the role to delete.", required=true, completer=RolesCompleter.class)
        String name;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        protected boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.security().removeRole(this.name);
        }
    }

    @CommandDefinition(name="create", description="Creates a new role")
    public static class Create
    extends RestCliCommand {
        @Argument(description="Provides a name for the new role", required=true)
        String name;
        @OptionList(shortName=112, required=true, completer=AuthorizationPermissionCompleter.class)
        List<String> permissions;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        protected boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.security().createRole(this.name, this.permissions);
        }
    }

    @CommandDefinition(name="deny", description="Denies roles to principals")
    public static class Deny
    extends RestCliCommand {
        @Argument(description="The principal to which the roles should be denied", required=true)
        String principal;
        @OptionList(shortName=114, required=true, completer=RolesCompleter.class)
        List<String> roles;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        protected boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.security().deny(this.principal, this.roles);
        }
    }

    @CommandDefinition(name="grant", description="Grants roles to principals")
    public static class Grant
    extends RestCliCommand {
        @Argument(description="The principal to which the roles should be granted", required=true)
        String principal;
        @OptionList(shortName=114, required=true, completer=RolesCompleter.class)
        List<String> roles;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        protected boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.security().grant(this.principal, this.roles);
        }
    }

    @CommandDefinition(name="ls", description="Lists roles assigned to principals")
    public static class Ls
    extends RestCliCommand {
        @Argument(description="The principal for which the roles should be listed. If unspecified all available roles are listed.")
        String principal;
        @Option(shortName=104, hasValue=false, overrideRequired=true)
        protected boolean help;

        @Override
        protected boolean isHelp() {
            return this.help;
        }

        @Override
        protected CompletionStage<RestResponse> exec(ContextAwareCommandInvocation invocation, RestClient client, Resource resource) {
            return client.security().listRoles(this.principal);
        }
    }
}

