/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cli.shell;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.cli.Context;
import org.infinispan.cli.commands.Argument;
import org.infinispan.cli.commands.Command;
import org.infinispan.cli.commands.ProcessedCommand;
import org.jboss.aesh.complete.CompleteOperation;
import org.jboss.aesh.complete.Completion;

public class Completer
implements Completion {
    private final Context context;

    public Completer(Context context) {
        this.context = context;
    }

    public void complete(CompleteOperation op) {
        String buffer = op.getBuffer();
        if (buffer.isEmpty()) {
            for (String name : this.context.getCommandRegistry().getCommandNames()) {
                Command command = this.context.getCommandRegistry().getCommand(name);
                if (!command.isAvailable(this.context)) continue;
                op.addCompletionCandidate(name);
            }
        } else {
            ProcessedCommand procCmd = new ProcessedCommand(buffer, op.getCursor());
            if (!procCmd.isCommandComplete()) {
                for (String name : this.context.getCommandRegistry().getCommandNames()) {
                    Command command = this.context.getCommandRegistry().getCommand(name);
                    if (!command.isAvailable(this.context) || !name.startsWith(procCmd.getCommand())) continue;
                    op.addCompletionCandidate(name);
                }
            } else {
                Command command = this.context.getCommandRegistry().getCommand(procCmd.getCommand());
                if (command.isAvailable(this.context)) {
                    op.setOffset(op.getCursor());
                    for (Argument arg : procCmd.getArguments()) {
                        if (arg.getOffset() >= op.getCursor()) break;
                        op.setOffset(arg.getOffset());
                    }
                    ArrayList<String> candidates = new ArrayList<String>();
                    Completer.addPrefixMatches(procCmd.getCurrentArgument(), command.getOptions(), candidates);
                    command.complete(this.context, procCmd, candidates);
                    op.addCompletionCandidates(candidates);
                }
            }
        }
    }

    public static void addPrefixMatches(Argument argument, Collection<String> all, List<String> candidates) {
        if (argument == null) {
            candidates.addAll(all);
        } else {
            String prefix = argument.getValue();
            for (String s : all) {
                if (!s.startsWith(prefix)) continue;
                candidates.add(s);
            }
        }
    }
}

