/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.logging;

import io.netty.channel.Channel;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.transaction.xa.Xid;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.client.hotrod.event.IncorrectClientListenerException;
import org.infinispan.client.hotrod.exceptions.CacheNotTransactionalException;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.client.hotrod.exceptions.InvalidResponseException;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheListenerException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    public static final String LOG_ROOT = "org.infinispan.";
    public static final Log HOTROD = (Log)Logger.getMessageLogger(Log.class, (String)"org.infinispan.HOTROD");

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Could not find '%s' file in classpath, using defaults.", id=4001)
    public void couldNotFindPropertiesFile(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Cannot perform operations on a cache associated with an unstarted RemoteCacheManager. Use RemoteCacheManager.start before using the remote cache.", id=4002)
    public void unstartedRemoteCacheManager();

    @Message(value="Invalid magic number. Expected %#x and received %#x", id=4003)
    public InvalidResponseException invalidMagicNumber(short var1, short var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error received from the server: %s", id=4005)
    public void errorFromServer(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server sent new topology view (id=%d, age=%d) containing %d addresses: %s", id=4006)
    public void newTopology(int var1, int var2, int var3, Collection<? extends SocketAddress> var4);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception encountered. Retry %d out of %d", id=4007)
    public void exceptionAndNoRetriesLeft(int var1, int var2, @Cause Throwable var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No hash function configured for version: %d", id=4011)
    public void noHasHFunctionConfigured(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="New server added(%s), adding to the pool.", id=4014)
    public void newServerAdded(SocketAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed adding new server %s", id=4015)
    public void failedAddingNewServer(SocketAddress var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Server not in cluster anymore(%s), removing from the pool.", id=4016)
    public void removingServer(SocketAddress var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Infinispan version: %s", id=4021)
    public void version(String var1);

    @Message(value="SSL Enabled but no TrustStore specified", id=4024)
    public CacheConfigurationException noSSLTrustManagerConfiguration();

    @Message(value="A password is required to open the KeyStore '%s'", id=4025)
    public CacheConfigurationException missingKeyStorePassword(String var1);

    @Message(value="A password is required to open the TrustStore '%s'", id=4026)
    public CacheConfigurationException missingTrustStorePassword(String var1);

    @Message(value="Cannot configure custom KeyStore and/or TrustStore when specifying a SSLContext", id=4027)
    public CacheConfigurationException xorSSLContext();

    @Message(value="Unable to parse server IP address %s", id=4028)
    public CacheConfigurationException parseErrorServerAddress(String var1);

    @Message(value="Invalid max_retries (value=%s). Value should be greater or equal than zero.", id=4029)
    public CacheConfigurationException invalidMaxRetries(int var1);

    @Message(value="Cannot enable authentication without specifying either a username, a token, a client Subject or a CallbackHandler", id=4030)
    public CacheConfigurationException invalidAuthenticationConfiguration();

    @Message(value="The selected authentication mechanism '%s' is not among the supported server mechanisms: %s", id=4031)
    public SecurityException unsupportedMech(String var1, List<String> var2);

    @Message(value="Unable to unmarshall bytes %s", id=4034)
    public HotRodClientException unableToUnmarshallBytes(String var1, @Cause Exception var2);

    @Message(value="Caught exception [%s] while invoking method [%s] on listener instance: %s", id=4035)
    public CacheListenerException exceptionInvokingListener(String var1, Method var2, Object var3, @Cause Throwable var4);

    @Message(value="Methods annotated with %s must accept exactly one parameter, of assignable from type %s", id=4036)
    public IncorrectClientListenerException incorrectClientListener(String var1, Collection<?> var2);

    @Message(value="Methods annotated with %s should have a return type of void.", id=4037)
    public IncorrectClientListenerException incorrectClientListener(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unexpected error consuming event %s", id=4038)
    public void unexpectedErrorConsumingEvent(Object var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unable to complete reading event from server %s", id=4039)
    public void unableToReadEventFromServer(@Cause Throwable var1, SocketAddress var2);

    @Message(value="Cache listener class %s must be annotated with org.infinispan.client.hotrod.annotation.ClientListener", id=4040)
    public IncorrectClientListenerException missingClientListenerAnnotation(String var1);

    @Message(value="Unknown event type %s received", id=4041)
    public HotRodClientException unknownEvent(short var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Unable to set method %s accessible", id=4042)
    public void unableToSetAccesible(Method var1, @Cause Exception var2);

    @Message(value="When enabling near caching, number of max entries must be configured", id=4045)
    public CacheConfigurationException nearCacheMaxEntriesUndefined();

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Successfully closed remote iterator '%s'", id=4046)
    public void iterationClosed(String var1);

    @Message(value="Invalid iteration id '%s'", id=4047)
    public IllegalStateException errorClosingIteration(String var1);

    @Message(value="Invalid iteration id '%s'", id=4048)
    public NoSuchElementException errorRetrievingNext(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Switched to cluster '%s'", id=4050)
    public void switchedToCluster(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Switched back to main cluster", id=4051)
    public void switchedBackToMainCluster();

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Manually switched to cluster '%s'", id=4052)
    public void manuallySwitchedToCluster(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Manually switched back to main cluster", id=4053)
    public void manuallySwitchedBackToMainCluster();

    @Message(value="Name of the failover cluster needs to be specified", id=4054)
    public CacheConfigurationException missingClusterNameDefinition();

    @Message(value="Host needs to be specified in server definition of failover cluster", id=4055)
    public CacheConfigurationException missingHostDefinition();

    @Message(value="At least one server address needs to be specified for failover cluster %s", id=4056)
    public CacheConfigurationException missingClusterServersDefinition(String var1);

    @Message(value="Duplicate failover cluster %s has been specified", id=4057)
    public CacheConfigurationException duplicateClusterDefinition(String var1);

    @Message(value="The client listener must use raw data when it uses a query as a filter: %s", id=4058)
    public IncorrectClientListenerException clientListenerMustUseRawData(String var1);

    @Message(value="The client listener must use the '%s' filter/converter factory", id=4059)
    public IncorrectClientListenerException clientListenerMustUseDesignatedFilterConverterFactory(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Ignoring error when closing iteration '%s'", id=4061)
    public void ignoringErrorDuringIterationClose(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Started iteration '%s'", id=4062)
    public void startedIteration(String var1);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(value="Channel to %s obtained for iteration '%s'", id=4063)
    public void iterationTransportObtained(SocketAddress var1, String var2);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="Tracking key %s belonging to segment %d, already tracked? = %b", id=4064)
    public void trackingSegmentKey(String var1, int var2, boolean var3);

    @Message(value="Cannot specify both a callback handler and a username/token for authentication", id=4067)
    public CacheConfigurationException callbackHandlerAndUsernameMutuallyExclusive();

    @Message(value="Connection to %s is not active.", id=4069)
    public TransportException channelInactive(@Param SocketAddress var1, SocketAddress var2);

    @Message(value="Failed to add client listener %s, server responded with status %d", id=4070)
    public HotRodClientException failedToAddListener(Object var1, short var2);

    @Message(value="Connection to %s was closed while waiting for response.", id=4071)
    public TransportException connectionClosed(@Param SocketAddress var1, SocketAddress var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Cannot create another async thread. Please increase 'infinispan.client.hotrod.default_executor_factory.pool_size' (current value is %d).", id=4072)
    public void cannotCreateAsyncThread(int var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Native Epoll transport not available, using NIO instead: %s", id=4074)
    public void epollNotAvailable(String var1);

    @Message(value="TrustStoreFileName and TrustStorePath are mutually exclusive", id=4075)
    public CacheConfigurationException trustStoreFileAndPathExclusive();

    @Message(value="Unknown message id %d; cannot find matching request", id=4076)
    public IllegalStateException unknownMessageId(long var1);

    @Message(value="Closing channel %s due to error in unknown operation.", id=4077)
    public TransportException errorFromUnknownOperation(Channel var1, @Cause Throwable var2, @Param SocketAddress var3);

    @Message(value="This channel is about to be closed and does not accept any further operations.", id=4078)
    public HotRodClientException noMoreOperationsAllowed();

    @Message(value="Unexpected listenerId %s", id=4079)
    public IllegalStateException unexpectedListenerId(String var1);

    @Message(value="Event should use messageId of previous Add Client Listener operation but id is %d and operation is %s", id=4080)
    public IllegalStateException operationIsNotAddClientListener(long var1, String var3);

    @Message(value="TransactionMode must be non-null.", id=4082)
    public CacheConfigurationException invalidTransactionMode();

    @Message(value="TransactionManagerLookup must be non-null", id=4083)
    public CacheConfigurationException invalidTransactionManagerLookup();

    @Message(value="Cache %s doesn't support transactions. Please check the documentation how to configure it properly.", id=4084)
    public CacheNotTransactionalException cacheDoesNotSupportTransactions(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error checking server configuration for transactional cache %s", id=4085)
    public void invalidTxServerConfig(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Exception caught while preparing transaction %s", id=4086)
    public void exceptionDuringPrepare(Xid var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Use of maxIdle expiration with a near cache is unsupported.", id=4087)
    public void nearCacheMaxIdleUnsupported();

    @Message(value="Transactions timeout must be positive", id=4088)
    public HotRodClientException invalidTransactionTimeout();

    @Message(value="TransactionTable is not started!", id=4089)
    public HotRodClientException transactionTableNotStarted();

    @Message(value="[%s] Invalid response operation. Expected %#x and received %#x", id=4090)
    public InvalidResponseException invalidResponse(String var1, short var2, double var3);

    @Message(value="MBean registration failed", id=4091)
    public HotRodClientException jmxRegistrationFailure(@Cause Throwable var1);

    @Message(value="MBean unregistration failed", id=4092)
    public HotRodClientException jmxUnregistrationFailure(@Cause Throwable var1);

    @Message(value="OAUTHBEARER mechanism selected without providing a token", id=4093)
    public CacheConfigurationException oauthBearerWithoutToken();

    @Message(value="Cannot specify both template name and configuration for '%s'", id=4094)
    public CacheConfigurationException remoteCacheTemplateNameXorConfiguration(String var1);

    @Message(value="Not a Hot Rod URI: %s", id=4095)
    public IllegalArgumentException notaHotRodURI(String var1);

    @Message(value="Invalid property format in URI: %s", id=4096)
    public IllegalArgumentException invalidPropertyFormat(String var1);

    @Message(value="Illegal attempt to redefine an already existing cache configuration: %s", id=4097)
    public IllegalArgumentException duplicateCacheConfiguration(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Closing connection %s due to transport error", id=4098)
    public void closingChannelAfterError(Channel var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Remote iteration over the entire result set of query '%s' without using pagination options is inefficient for large result sets. Please consider using 'startOffset' and 'maxResults' options.", id=4099)
    public void warnPerfRemoteIterationWithoutPagination(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Error reaching the server during iteration", id=4100)
    public void throwableDuringPublisher(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Configuration property '%s' has been deprecated", id=4101)
    public void deprecatedConfigurationProperty(String var1);

    @Message(value="Near cache number of max entries must be a positive number when using bloom filter optimization, it was %d", id=4102)
    public CacheConfigurationException nearCacheMaxEntriesPositiveWithBloom(int var1);

    @Message(value="Near cache with bloom filter requires pool max active to be 1, was %s, and exhausted action to be WAIT, was %s", id=4103)
    public CacheConfigurationException bloomFilterRequiresMaxActiveOneAndWait(int var1, ExhaustedAction var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Failed to load and create an optional ProtoStream serialization context initializer: %s", id=4104)
    public void failedToCreatePredefinedSerializationContextInitializer(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Reverting to the initial server list for caches %s", id=4105)
    public void revertCacheToInitialServerList(Collection<String> var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invalid active count after closing channel %s", id=4106)
    public void invalidActiveCountAfterClose(Channel var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Invalid created count after closing channel %s", id=4107)
    public void invalidCreatedCountAfterClose(Channel var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(value="Native IOUring transport not available, using NIO instead: %s", id=4108)
    public void ioUringNotAvailable(String var1);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="OpenTelemetry API is not present in the classpath. Client context tracing will not be propagated.", id=4109)
    public void noOpenTelemetryAPI();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="OpenTelemetry API is present in the classpath and the tracing propagation is enabled. Client context tracing will be propagated.", id=4110)
    public void openTelemetryPropagationEnabled();

    @LogMessage(level=Logger.Level.TRACE)
    @Message(value="OpenTelemetry API is present in the classpath, but the tracing propagation is not enabled. Client context tracing will not be propagated.", id=4111)
    public void openTelemetryPropagationDisabled();

    @Message(value="The SNI hostname is required when hostname validation is enabled", id=4112)
    public CacheConfigurationException missingSniHostName();

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Unexpected error while creating the tracing propagation context. Client context tracing will not be propagated.", id=4115)
    public void errorCreatingPropagationContext(@Cause Throwable var1);
}

