/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.Collection;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;

@ThreadSafe
public class RoundRobinBalancingStrategy
implements RequestBalancingStrategy {
    private static final Log log = LogFactory.getLog(RoundRobinBalancingStrategy.class);
    private int index = 0;
    private volatile SocketAddress[] servers;

    @Override
    public void setServers(Collection<SocketAddress> servers) {
        this.servers = servers.toArray(new InetSocketAddress[servers.size()]);
        if (this.index >= this.servers.length) {
            this.index = 0;
        }
        if (log.isTraceEnabled()) {
            log.tracef("New server list is: " + Arrays.toString(this.servers), new Object[0]);
        }
    }

    @Override
    public SocketAddress nextServer() {
        SocketAddress server = this.getServerByIndex(this.index++);
        if (this.index >= this.servers.length) {
            this.index = 0;
        }
        return server;
    }

    public SocketAddress dryRunNextServer() {
        return this.getServerByIndex(this.index);
    }

    private SocketAddress getServerByIndex(int pos) {
        SocketAddress[] copy = this.servers;
        if (pos >= copy.length) {
            pos = 0;
        }
        SocketAddress server = copy[pos];
        if (log.isTraceEnabled()) {
            log.tracef("Returning server: %s", server);
        }
        return server;
    }

    public SocketAddress[] getServers() {
        return this.servers;
    }

    public int getNextPosition() {
        return this.index;
    }
}

