/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import org.infinispan.client.rest.RestCacheManagerClient;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.impl.okhttp.FileRestEntityOkHttp;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;
import org.infinispan.client.rest.impl.okhttp.StringRestEntityOkHttp;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;

public class RestCacheManagerClientOkHttp
implements RestCacheManagerClient {
    private final RestClientOkHttp client;
    private final String name;
    private final String baseCacheManagerUrl;

    RestCacheManagerClientOkHttp(RestClientOkHttp client, String name) {
        this.client = client;
        this.name = name;
        this.baseCacheManagerUrl = String.format("%s%s/v2/cache-managers/%s", client.getBaseURL(), client.getConfiguration().contextPath(), RestClientOkHttp.sanitize(name)).replaceAll("//", "/");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public CompletionStage<RestResponse> globalConfiguration(String mediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseCacheManagerUrl + "/config").header("Accept", mediaType);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> cacheConfigurations() {
        return this.client.execute(this.baseCacheManagerUrl, "cache-configs");
    }

    @Override
    public CompletionStage<RestResponse> cacheConfigurations(String mediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseCacheManagerUrl + "/cache-configs").header("Accept", mediaType);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> templates(String mediaType) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseCacheManagerUrl + "/cache-configs/templates").header("Accept", mediaType);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> info() {
        return this.client.execute(this.baseCacheManagerUrl, new String[0]);
    }

    @Override
    public CompletionStage<RestResponse> stats() {
        return this.client.execute(this.baseCacheManagerUrl, "stats");
    }

    @Override
    public CompletionStage<RestResponse> backupStatuses() {
        return this.client.execute(this.baseCacheManagerUrl, "x-site", "backups");
    }

    @Override
    public CompletionStage<RestResponse> backupStatus(String site) {
        return this.client.execute(this.baseCacheManagerUrl, "x-site", "backups", site);
    }

    @Override
    public CompletionStage<RestResponse> bringBackupOnline(String backup) {
        return this.executeXSiteOperation(backup, "bring-online");
    }

    @Override
    public CompletionStage<RestResponse> takeOffline(String backup) {
        return this.executeXSiteOperation(backup, "take-offline");
    }

    @Override
    public CompletionStage<RestResponse> pushSiteState(String backup) {
        return this.executeXSiteOperation(backup, "start-push-state");
    }

    @Override
    public CompletionStage<RestResponse> cancelPushState(String backup) {
        return this.executeXSiteOperation(backup, "cancel-push-state");
    }

    private CompletionStage<RestResponse> executeXSiteOperation(String backup, String operation) {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(String.format("%s/x-site/backups/%s?action=%s", this.baseCacheManagerUrl, backup, operation));
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> health() {
        return this.health(false);
    }

    @Override
    public CompletionStage<RestResponse> health(boolean skipBody) {
        Request.Builder builder = new Request.Builder().url(this.baseCacheManagerUrl);
        if (skipBody) {
            builder.head();
        }
        builder.url(this.baseCacheManagerUrl + "/health");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> healthStatus() {
        return this.client.execute(this.baseCacheManagerUrl, "health", "status");
    }

    @Override
    public CompletionStage<RestResponse> caches() {
        return this.client.execute(this.baseCacheManagerUrl, "caches");
    }

    @Override
    public CompletionStage<RestResponse> createBackup(String name, String workingDir, Map<String, List<String>> resources) {
        Json json = Json.object();
        if (workingDir != null) {
            json.set("directory", (Object)workingDir);
        }
        if (resources != null) {
            json.set("resources", Json.factory().make(resources));
        }
        RequestBody body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, json.toString()).toRequestBody();
        Request.Builder builder = this.backup(name).post(body);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getBackup(String name, boolean skipBody) {
        Request.Builder builder = this.backup(name);
        if (skipBody) {
            builder.head();
        }
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getBackupNames() {
        Request.Builder builder = new Request.Builder().url(this.baseCacheManagerUrl + "/backups");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> deleteBackup(String name) {
        return this.client.execute(this.backup(name).delete());
    }

    @Override
    public CompletionStage<RestResponse> restore(String name, File backup, Map<String, List<String>> resources) {
        Json json = resources != null ? Json.factory().make(resources) : Json.object();
        RequestBody zipBody = new FileRestEntityOkHttp(MediaType.APPLICATION_ZIP, backup).toRequestBody();
        MultipartBody multipartBody = new MultipartBody.Builder().addFormDataPart("resources", json.toString()).addFormDataPart("backup", backup.getName(), zipBody).setType(MultipartBody.FORM).build();
        Request.Builder builder = this.restore(name).post((RequestBody)multipartBody);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> restore(String name, String backupLocation, Map<String, List<String>> resources) {
        Json json = Json.object();
        json.set("location", (Object)backupLocation);
        if (resources != null) {
            json.set("resources", Json.factory().make(resources));
        }
        RequestBody body = new StringRestEntityOkHttp(MediaType.APPLICATION_JSON, json.toString()).toRequestBody();
        Request.Builder builder = this.restore(name).post(body);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> getRestore(String name) {
        return this.client.execute(this.restore(name).head());
    }

    @Override
    public CompletionStage<RestResponse> getRestoreNames() {
        return this.client.execute(new Request.Builder().url(this.baseCacheManagerUrl + "/restores"));
    }

    @Override
    public CompletionStage<RestResponse> deleteRestore(String name) {
        return this.client.execute(this.restore(name).delete());
    }

    @Override
    public CompletionStage<RestResponse> enableRebalancing() {
        return this.setRebalancing(true);
    }

    @Override
    public CompletionStage<RestResponse> disableRebalancing() {
        return this.setRebalancing(false);
    }

    private CompletionStage<RestResponse> setRebalancing(boolean enable) {
        String action = enable ? "enable-rebalancing" : "disable-rebalancing";
        return this.client.execute(new Request.Builder().post(Util.EMPTY_REQUEST).url(this.baseCacheManagerUrl + "?action=" + action));
    }

    private Request.Builder backup(String name) {
        return new Request.Builder().url(this.baseCacheManagerUrl + "/backups/" + name);
    }

    private Request.Builder restore(String name) {
        return new Request.Builder().url(this.baseCacheManagerUrl + "/restores/" + name);
    }
}

