/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.rest.impl.okhttp;

import java.util.List;
import java.util.concurrent.CompletionStage;
import okhttp3.Request;
import okhttp3.internal.Util;
import org.infinispan.client.rest.RestResponse;
import org.infinispan.client.rest.RestSecurityClient;
import org.infinispan.client.rest.impl.okhttp.RestClientOkHttp;

public class RestSecurityClientOkHttp
implements RestSecurityClient {
    private final RestClientOkHttp client;
    private final String baseSecurityURL;

    public RestSecurityClientOkHttp(RestClientOkHttp restClient) {
        this.client = restClient;
        this.baseSecurityURL = String.format("%s%s/v2/security", restClient.getBaseURL(), restClient.getConfiguration().contextPath());
    }

    @Override
    public CompletionStage<RestResponse> listRoles(String principal) {
        return this.client.execute(this.baseSecurityURL, "roles", principal);
    }

    @Override
    public CompletionStage<RestResponse> grant(String principal, List<String> roles) {
        return this.modifyAcl(principal, roles, "grant");
    }

    @Override
    public CompletionStage<RestResponse> deny(String principal, List<String> roles) {
        return this.modifyAcl(principal, roles, "deny");
    }

    private CompletionStage<RestResponse> modifyAcl(String principal, List<String> roles, String action) {
        Request.Builder builder = new Request.Builder();
        StringBuilder sb = new StringBuilder(this.baseSecurityURL);
        sb.append("/roles/").append(principal).append("?action=").append(action);
        for (String role : roles) {
            sb.append("&role=").append(role);
        }
        builder.url(sb.toString()).put(Util.EMPTY_REQUEST);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> flushCache() {
        Request.Builder builder = new Request.Builder();
        builder.post(RestClientOkHttp.EMPTY_BODY).url(this.baseSecurityURL + "/cache?action=flush");
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> createRole(String name, List<String> permissions) {
        Request.Builder builder = new Request.Builder();
        StringBuilder sb = new StringBuilder(this.baseSecurityURL);
        sb.append("/permissions/").append(name).append('?');
        for (int i = 0; i < permissions.size(); ++i) {
            if (i > 0) {
                sb.append('&');
            }
            sb.append("permission=").append(permissions.get(i));
        }
        builder.url(sb.toString()).put(Util.EMPTY_REQUEST);
        return this.client.execute(builder);
    }

    @Override
    public CompletionStage<RestResponse> removeRole(String name) {
        Request.Builder builder = new Request.Builder();
        builder.url(this.baseSecurityURL + "/permissions/" + name);
        return this.client.execute(builder.delete());
    }
}

