/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.cloudevents.configuration;

import org.infinispan.cloudevents.configuration.CloudEventsGlobalConfiguration;
import org.infinispan.cloudevents.impl.Log;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.Experimental;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;

@Experimental
public class CloudEventsGlobalConfigurationBuilder
implements Builder<CloudEventsGlobalConfiguration> {
    private final AttributeSet attributes = CloudEventsGlobalConfiguration.attributeSet();

    public CloudEventsGlobalConfigurationBuilder(GlobalConfigurationBuilder builder) {
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public CloudEventsGlobalConfigurationBuilder bootstrapServers(String bootstrapServers) {
        this.attributes.attribute(CloudEventsGlobalConfiguration.BOOTSTRAP_SERVERS).set((Object)bootstrapServers);
        return this;
    }

    public CloudEventsGlobalConfigurationBuilder acks(String acks) {
        this.attributes.attribute(CloudEventsGlobalConfiguration.ACKS).set((Object)acks);
        return this;
    }

    public CloudEventsGlobalConfigurationBuilder auditTopic(String topic) {
        this.attributes.attribute(CloudEventsGlobalConfiguration.AUDIT_TOPIC).set((Object)topic);
        return this;
    }

    public CloudEventsGlobalConfigurationBuilder cacheEntriesTopic(String topic) {
        this.attributes.attribute(CloudEventsGlobalConfiguration.CACHE_ENTRIES_TOPIC).set((Object)topic);
        return this;
    }

    public void validate() {
        String bootstrapServers = (String)this.attributes.attribute(CloudEventsGlobalConfiguration.BOOTSTRAP_SERVERS).get();
        String cacheEntriesTopic = (String)this.attributes.attribute(CloudEventsGlobalConfiguration.CACHE_ENTRIES_TOPIC).get();
        String auditTopic = (String)this.attributes.attribute(CloudEventsGlobalConfiguration.AUDIT_TOPIC).get();
        if (!(cacheEntriesTopic.isEmpty() && auditTopic.isEmpty() || !bootstrapServers.isEmpty())) {
            throw Log.CONFIG.bootstrapServersRequired();
        }
    }

    public CloudEventsGlobalConfiguration create() {
        return new CloudEventsGlobalConfiguration(this.attributes.protect());
    }

    public Builder<?> read(CloudEventsGlobalConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return "CloudEventsGlobalConfigurationBuilder [attributes=" + this.attributes + "]";
    }
}

