/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.nio.charset.StandardCharsets;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.logging.Log;

public class UTF8Encoder
implements Encoder {
    public static final UTF8Encoder INSTANCE = new UTF8Encoder();

    @Override
    public Object toStorage(Object content) {
        if (content instanceof String) {
            return ((String)String.class.cast(content)).getBytes(StandardCharsets.UTF_8);
        }
        throw Log.CONTAINER.unsupportedContent(content);
    }

    @Override
    public Object fromStorage(Object stored) {
        return new String((byte[])stored, StandardCharsets.UTF_8);
    }

    @Override
    public boolean isStorageFormatFilterable() {
        return false;
    }

    @Override
    public MediaType getStorageFormat() {
        return MediaType.TEXT_PLAIN;
    }

    @Override
    public short id() {
        return 3;
    }
}

