/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.EnumSet;

public class EnumUtil {
    public static final long EMPTY_BIT_SET = 0L;

    private EnumUtil() {
    }

    public static <E extends Enum<E>> long bitSetOf(Collection<E> enums) {
        if (enums == null || enums.isEmpty()) {
            return 0L;
        }
        long flagBitSet = 0L;
        for (Enum f : enums) {
            flagBitSet |= (long)(1 << f.ordinal());
        }
        return flagBitSet;
    }

    public static long bitSetOf(Enum<?> first) {
        return 1 << first.ordinal();
    }

    public static long bitSetOf(Enum<?> first, Enum<?> second) {
        return 1 << first.ordinal() | 1 << second.ordinal();
    }

    public static long bitSetOf(Enum<?> first, Enum<?> second, Enum<?> ... remaining) {
        long bitSet = 1 << first.ordinal() | 1 << second.ordinal();
        for (Enum<?> f : remaining) {
            bitSet |= (long)(1 << f.ordinal());
        }
        return bitSet;
    }

    public static long bitSetOf(Enum<?>[] flags) {
        long bitSet = 0L;
        for (Enum<?> flag : flags) {
            bitSet |= (long)(1 << flag.ordinal());
        }
        return bitSet;
    }

    public static <E extends Enum<E>> EnumSet<E> enumSetOf(long bitSet, Class<E> eClass) {
        if (bitSet == 0L) {
            return EnumSet.noneOf(eClass);
        }
        EnumSet<Enum> flagSet = EnumSet.noneOf(eClass);
        for (Enum f : (Enum[])eClass.getEnumConstants()) {
            if (!EnumUtil.hasEnum(bitSet, f)) continue;
            flagSet.add(f);
        }
        return flagSet;
    }

    public static boolean hasEnum(long bitSet, Enum<?> anEnum) {
        return (bitSet & (long)(1 << anEnum.ordinal())) != 0L;
    }

    public static long setEnum(long bitSet, Enum<?> anEn) {
        return bitSet | (long)(1 << anEn.ordinal());
    }

    public static <E extends Enum<E>> long setEnums(long bitSet, Collection<E> enums) {
        if (enums == null || enums.isEmpty()) {
            return bitSet;
        }
        for (Enum f : enums) {
            bitSet |= (long)(1 << f.ordinal());
        }
        return bitSet;
    }

    public static long unsetEnum(long bitSet, Enum<?> anEnum) {
        return bitSet & (long)(~(1 << anEnum.ordinal()));
    }

    public static <E extends Enum<E>> String prettyPrintBitSet(long bitSet, Class<E> eClass) {
        return EnumUtil.enumSetOf(bitSet, eClass).toString();
    }

    public static long mergeBitSets(long bitSet1, long bitSet2) {
        return bitSet1 | bitSet2;
    }

    public static long diffBitSets(long bitSet1, long bitSet2) {
        return bitSet1 & (bitSet2 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean containsAll(long bitSet, long testBitSet) {
        return (bitSet & testBitSet) == testBitSet;
    }

    public static boolean containsAny(long bitSet, long testBitSet) {
        return (bitSet & testBitSet) != 0L;
    }

    public static int bitSetSize(long bitSet) {
        return Long.bitCount(bitSet);
    }

    public static <E extends Enum<E>> E[] enumArrayOf(long bitSet, Class<E> eClass) {
        if (bitSet == 0L) {
            return null;
        }
        Enum[] array = (Enum[])Array.newInstance(eClass, EnumUtil.bitSetSize(bitSet));
        int i = 0;
        for (Enum f : (Enum[])eClass.getEnumConstants()) {
            if (!EnumUtil.hasEnum(bitSet, f)) continue;
            array[i++] = f;
        }
        return array;
    }
}

