/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;

public final class DefaultTranscoder
implements Transcoder {
    private static final Log log = LogFactory.getLog(DefaultTranscoder.class);
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();
    public static final DefaultTranscoder INSTANCE = new DefaultTranscoder();

    private DefaultTranscoder() {
    }

    @Override
    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        try {
            if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                return this.convertToOctetStream(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
                return this.convertToObject(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.TEXT_PLAIN)) {
                return this.convertToTextPlain(content, contentType, destinationType);
            }
            if (destinationType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
                return this.convertToUrlEncoded(content, contentType);
            }
            throw log.unsupportedContent(content);
        }
        catch (IOException | InterruptedException | EncodingException e) {
            throw log.unsupportedContent(content);
        }
    }

    private Object convertToUrlEncoded(Object content, MediaType contentType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return StandardConversions.convertOctetStreamToUrlEncoded(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertUrlEncodedToObject(content);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToUrlEncoded(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return content;
        }
        throw log.unsupportedContent(content);
    }

    private Object convertToTextPlain(Object content, MediaType contentType, MediaType destinationType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            byte[] decoded = StandardConversions.decodeOctetStream(content, destinationType);
            return StandardConversions.convertOctetStreamToText(decoded, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertJavaToText(content, contentType, destinationType);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToText(content, contentType, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return StandardConversions.convertUrlEncodedToText(content, destinationType);
        }
        throw log.unsupportedContent(content);
    }

    private Object convertToObject(Object content, MediaType contentType, MediaType destinationType) {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            byte[] decoded = StandardConversions.decodeOctetStream(content, destinationType);
            return StandardConversions.convertOctetStreamToJava(decoded, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return content;
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToObject(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return StandardConversions.convertUrlEncodedToObject(content);
        }
        throw log.unsupportedContent(content);
    }

    public Object convertToOctetStream(Object content, MediaType contentType, MediaType destinationType) throws IOException, InterruptedException {
        if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return StandardConversions.decodeOctetStream(content, contentType);
        }
        if (contentType.match(MediaType.APPLICATION_OBJECT)) {
            return StandardConversions.convertJavaToOctetStream(content, contentType);
        }
        if (contentType.match(MediaType.TEXT_PLAIN)) {
            return StandardConversions.convertTextToOctetStream(content, destinationType);
        }
        if (contentType.match(MediaType.APPLICATION_WWW_FORM_URLENCODED)) {
            return StandardConversions.convertUrlEncodedToOctetStream(content);
        }
        throw log.unsupportedContent(content);
    }

    @Override
    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }

    private boolean in(MediaType mediaType, Set<MediaType> set) {
        return set.stream().anyMatch(s -> s.match(mediaType));
    }

    @Override
    public boolean supportsConversion(MediaType mediaType, MediaType other) {
        return this.in(mediaType, supportedTypes) && this.in(other, supportedTypes);
    }

    static {
        supportedTypes.add(MediaType.APPLICATION_OBJECT);
        supportedTypes.add(MediaType.APPLICATION_OCTET_STREAM);
        supportedTypes.add(MediaType.APPLICATION_WWW_FORM_URLENCODED);
        supportedTypes.add(MediaType.TEXT_PLAIN);
    }
}

