/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractIndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexMergeConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class IndexMergeConfigurationBuilder
extends AbstractIndexingConfigurationChildBuilder
implements Builder<IndexMergeConfiguration>,
ConfigurationBuilderInfo {
    private static final String KEY_PREFIX = "hibernate.search.backend.io.merge";
    private static final String MAX_DOCS_KEY = "hibernate.search.backend.io.merge.max_docs";
    private static final String FACTOR_KEY = "hibernate.search.backend.io.merge.factor";
    private static final String MIN_SIZE_KEY = "hibernate.search.backend.io.merge.min_size";
    private static final String MAX_SIZE_KEY = "hibernate.search.backend.io.merge.max_size";
    private static final String MAX_FORCED_SIZE_KEY = "hibernate.search.backend.io.merge.max_forced_size";
    private static final String CALIBRATE_BY_DELETES_KEY = "hibernate.search.backend.io.merge.calibrate_by_deletes";
    private final AttributeSet attributes = IndexMergeConfiguration.attributeDefinitionSet();
    private final Attribute<Integer> maxDocs = this.attributes.attribute(IndexMergeConfiguration.MAX_DOCS);
    private final Attribute<Integer> factor = this.attributes.attribute(IndexMergeConfiguration.FACTOR);
    private final Attribute<Integer> minSize = this.attributes.attribute(IndexMergeConfiguration.MIN_SIZE);
    private final Attribute<Integer> maxSize = this.attributes.attribute(IndexMergeConfiguration.MAX_SIZE);
    private final Attribute<Integer> maxForceSize = this.attributes.attribute(IndexMergeConfiguration.MAX_FORCED_SIZE);
    private final Attribute<Boolean> calibrateByDeletes = this.attributes.attribute(IndexMergeConfiguration.CALIBRATE_BY_DELETES);

    IndexMergeConfigurationBuilder(IndexingConfigurationBuilder builder) {
        super(builder);
    }

    Map<String, Object> asInternalProperties() {
        HashMap<String, Object> props = new HashMap<String, Object>();
        if (!this.maxDocs.isNull()) {
            props.put(MAX_DOCS_KEY, this.maxDocs());
        }
        if (!this.minSize.isNull()) {
            props.put(MIN_SIZE_KEY, this.minSize());
        }
        if (!this.maxSize.isNull()) {
            props.put(MAX_SIZE_KEY, this.maxSize());
        }
        if (!this.factor.isNull()) {
            props.put(FACTOR_KEY, this.factor());
        }
        if (!this.maxForceSize.isNull()) {
            props.put(MAX_FORCED_SIZE_KEY, this.maxForcedSize());
        }
        if (!this.calibrateByDeletes.isNull()) {
            props.put(CALIBRATE_BY_DELETES_KEY, this.isCalibrateByDeletes());
        }
        return props;
    }

    public ElementDefinition<IndexMergeConfiguration> getElementDefinition() {
        return IndexMergeConfiguration.ELEMENT_DEFINITION;
    }

    public IndexMergeConfigurationBuilder maxDocs(int value) {
        this.maxDocs.set((Object)value);
        return this;
    }

    public Integer maxDocs() {
        return (Integer)this.maxDocs.get();
    }

    public IndexMergeConfigurationBuilder factor(int value) {
        this.factor.set((Object)value);
        return this;
    }

    public Integer factor() {
        return (Integer)this.factor.get();
    }

    public IndexMergeConfigurationBuilder minSize(int value) {
        this.minSize.set((Object)value);
        return this;
    }

    public Integer minSize() {
        return (Integer)this.minSize.get();
    }

    public IndexMergeConfigurationBuilder maxSize(int value) {
        this.maxSize.set((Object)value);
        return this;
    }

    public Integer maxSize() {
        return (Integer)this.maxSize.get();
    }

    public IndexMergeConfigurationBuilder maxForcedSize(int value) {
        this.maxForceSize.set((Object)value);
        return this;
    }

    public Integer maxForcedSize() {
        return (Integer)this.maxForceSize.get();
    }

    public IndexMergeConfigurationBuilder calibrateByDeletes(boolean value) {
        this.calibrateByDeletes.set((Object)value);
        return this;
    }

    public Boolean isCalibrateByDeletes() {
        return (Boolean)this.calibrateByDeletes.get();
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexMergeConfiguration create() {
        return new IndexMergeConfiguration(this.attributes.protect());
    }

    public IndexMergeConfigurationBuilder read(IndexMergeConfiguration template) {
        this.attributes.read(template.attributes());
        return this;
    }

    public String toString() {
        return "IndexMergeConfiguration{attributes=" + this.attributes + '}';
    }

    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }
}

