/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletionStage;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.IracPutKeyValueCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistCacheWriterInterceptor
extends CacheWriterInterceptor {
    private static final Log log = LogFactory.getLog(DistCacheWriterInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    DistributionManager dm;
    private boolean isUsingLockDelegation;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected void start() {
        super.start();
        this.isUsingLockDelegation = !this.cacheConfiguration.transaction().transactionMode().isTransactional();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, putKeyValueCommand, rv) -> {
            Object key = putKeyValueCommand.getKey();
            if (!(putKeyValueCommand.hasAnyFlag(FlagBitSets.ROLLING_UPGRADE) || this.isStoreEnabled((FlagAffectedCommand)putKeyValueCommand) && !rCtx.isInTxScope() && putKeyValueCommand.isSuccessful())) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, (FlagAffectedCommand)putKeyValueCommand, putKeyValueCommand.getKey())) {
                return rv;
            }
            return DistCacheWriterInterceptor.delayedValue(this.storeEntry(rCtx, key, (FlagAffectedCommand)putKeyValueCommand), rv);
        });
    }

    @Override
    public Object visitIracPutKeyValueCommand(InvocationContext ctx, IracPutKeyValueCommand command) {
        return this.invokeNextThenApply(ctx, command, (rCtx, cmd, rv) -> {
            Object key = cmd.getKey();
            if (!this.isStoreEnabled((FlagAffectedCommand)cmd) || !cmd.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, (FlagAffectedCommand)cmd, cmd.getKey())) {
                return rv;
            }
            return DistCacheWriterInterceptor.delayedValue(this.storeEntry(rCtx, key, (FlagAffectedCommand)cmd), rv);
        });
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        if (!this.isStoreEnabled(command) || ctx.isInTxScope()) {
            return this.invokeNext(ctx, command);
        }
        return this.invokeNextThenApply(ctx, command, this.handlePutMapCommandReturn);
    }

    @Override
    protected Object handlePutMapCommandReturn(InvocationContext rCtx, PutMapCommand putMapCommand, Object rv) {
        CompletionStage<Long> putMapStage = this.persistenceManager.writeMapCommand(putMapCommand, rCtx, (writeCommand, key) -> !this.skipNonPrimary(rCtx, key, (PutMapCommand)writeCommand) && this.isProperWriter(rCtx, (FlagAffectedCommand)writeCommand, key));
        if (this.getStatisticsEnabled()) {
            putMapStage.thenAccept(this.cacheStores::getAndAdd);
        }
        return DistCacheWriterInterceptor.delayedValue(putMapStage, rv);
    }

    private boolean skipNonPrimary(InvocationContext rCtx, Object key, PutMapCommand command) {
        return this.isUsingLockDelegation && command.isForwarded() && !this.dm.getCacheTopology().getDistribution(key).primary().equals(rCtx.getOrigin());
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, removeCommand, rv) -> {
            Object key = removeCommand.getKey();
            if (!this.isStoreEnabled((FlagAffectedCommand)removeCommand) || rCtx.isInTxScope() || !removeCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, (FlagAffectedCommand)removeCommand, key)) {
                return rv;
            }
            CompletionStage<Object> stage = this.persistenceManager.deleteFromAllStores(key, removeCommand.getSegment(), this.skipSharedStores(rCtx, key, (FlagAffectedCommand)removeCommand) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
            if (trace) {
                stage = stage.thenAccept(removed -> this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, removed));
            }
            return DistCacheWriterInterceptor.delayedValue(stage, rv);
        });
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, replaceCommand, rv) -> {
            Object key = replaceCommand.getKey();
            if (!this.isStoreEnabled((FlagAffectedCommand)replaceCommand) || rCtx.isInTxScope() || !replaceCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, (FlagAffectedCommand)replaceCommand, replaceCommand.getKey())) {
                return rv;
            }
            return DistCacheWriterInterceptor.delayedValue(this.storeEntry(rCtx, key, (FlagAffectedCommand)replaceCommand), rv);
        });
    }

    @Override
    public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, computeCommand, rv) -> {
            CompletionStage<Object> stage;
            Object key = computeCommand.getKey();
            if (!this.isStoreEnabled((FlagAffectedCommand)computeCommand) || rCtx.isInTxScope() || !computeCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, (FlagAffectedCommand)computeCommand, computeCommand.getKey())) {
                return rv;
            }
            if (computeCommand.isSuccessful() && rv == null) {
                stage = this.persistenceManager.deleteFromAllStores(key, computeCommand.getSegment(), this.skipSharedStores(rCtx, key, (FlagAffectedCommand)computeCommand) ? PersistenceManager.AccessMode.PRIVATE : PersistenceManager.AccessMode.BOTH);
                if (trace) {
                    stage = stage.thenAccept(removed -> this.getLog().tracef("Removed entry under key %s and got response %s from CacheStore", key, removed));
                }
            } else {
                stage = computeCommand.isSuccessful() ? this.storeEntry(rCtx, key, (FlagAffectedCommand)computeCommand) : CompletableFutures.completedNull();
            }
            return DistCacheWriterInterceptor.delayedValue(stage, rv);
        });
    }

    @Override
    public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
        return this.invokeNextThenApply(ctx, command, (rCtx, computeIfAbsentCommand, rv) -> {
            Object key = computeIfAbsentCommand.getKey();
            if (!this.isStoreEnabled((FlagAffectedCommand)computeIfAbsentCommand) || rCtx.isInTxScope() || !computeIfAbsentCommand.isSuccessful()) {
                return rv;
            }
            if (!this.isProperWriter(rCtx, (FlagAffectedCommand)computeIfAbsentCommand, computeIfAbsentCommand.getKey())) {
                return rv;
            }
            return DistCacheWriterInterceptor.delayedValue(this.storeEntry(rCtx, key, (FlagAffectedCommand)computeIfAbsentCommand), rv);
        });
    }

    @Override
    protected boolean skipSharedStores(InvocationContext ctx, Object key, FlagAffectedCommand command) {
        return !this.dm.getCacheTopology().getDistribution(key).isPrimary() || command.hasAnyFlag(FlagBitSets.SKIP_SHARED_CACHE_STORE);
    }

    @Override
    protected boolean isProperWriter(InvocationContext ctx, FlagAffectedCommand command, Object key) {
        boolean nonTx;
        if (command.hasAnyFlag(FlagBitSets.SKIP_OWNERSHIP_CHECK)) {
            return true;
        }
        int segment = SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
        DistributionInfo distributionInfo = this.dm.getCacheTopology().getSegmentDistribution(segment);
        boolean bl = nonTx = this.isUsingLockDelegation || command.hasAnyFlag(FlagBitSets.IRAC_UPDATE);
        if (nonTx && ctx.isOriginLocal() && !command.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
            return distributionInfo.isPrimary();
        }
        return distributionInfo.isWriteOwner();
    }
}

