/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ClassAttributeSerializer;
import org.infinispan.commons.configuration.attributes.Matchable;
import org.infinispan.commons.configuration.attributes.SimpleInstanceAttributeCopier;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.HashFunctionPartitioner;

public class HashConfiguration
implements Matchable<HashConfiguration>,
ConfigurationInfo {
    public static final AttributeDefinition<ConsistentHashFactory> CONSISTENT_HASH_FACTORY = AttributeDefinition.builder((String)"consistentHashFactory", null, ConsistentHashFactory.class).serializer(ClassAttributeSerializer.INSTANCE).immutable().build();
    public static final AttributeDefinition<Integer> NUM_OWNERS = AttributeDefinition.builder((String)"numOwners", (Object)2).xmlName("owners").immutable().build();
    public static final AttributeDefinition<Integer> NUM_SEGMENTS = AttributeDefinition.builder((String)"numSegments", (Object)256).xmlName("segments").immutable().build();
    public static final AttributeDefinition<Float> CAPACITY_FACTOR = AttributeDefinition.builder((String)"capacityFactor", (Object)Float.valueOf(1.0f)).immutable().global(false).xmlName("capacity").build();
    public static final AttributeDefinition<KeyPartitioner> KEY_PARTITIONER = AttributeDefinition.builder((String)"keyPartitioner", (Object)new HashFunctionPartitioner(), KeyPartitioner.class).copier(SimpleInstanceAttributeCopier.INSTANCE).serializer(ClassAttributeSerializer.INSTANCE).immutable().build();
    public static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition(Element.HASH.getLocalName(), false);
    private final List<ConfigurationInfo> elements;
    private final Attribute<ConsistentHashFactory> consistentHashFactory;
    private final Attribute<Integer> numOwners;
    private final Attribute<Integer> numSegments;
    private final Attribute<Float> capacityFactor;
    private final Attribute<KeyPartitioner> keyPartitioner;
    private final GroupsConfiguration groupsConfiguration;
    private final AttributeSet attributes;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HashConfiguration.class, new AttributeDefinition[]{CONSISTENT_HASH_FACTORY, NUM_OWNERS, NUM_SEGMENTS, CAPACITY_FACTOR, KEY_PARTITIONER});
    }

    HashConfiguration(AttributeSet attributes, GroupsConfiguration groupsConfiguration) {
        this.attributes = attributes.checkProtection();
        this.groupsConfiguration = groupsConfiguration;
        this.consistentHashFactory = attributes.attribute(CONSISTENT_HASH_FACTORY);
        this.numOwners = attributes.attribute(NUM_OWNERS);
        this.numSegments = attributes.attribute(NUM_SEGMENTS);
        this.capacityFactor = attributes.attribute(CAPACITY_FACTOR);
        this.keyPartitioner = attributes.attribute(KEY_PARTITIONER);
        this.elements = Collections.singletonList(groupsConfiguration);
    }

    @Deprecated
    public ConsistentHashFactory<?> consistentHashFactory() {
        return (ConsistentHashFactory)this.consistentHashFactory.get();
    }

    public int numOwners() {
        return (Integer)this.numOwners.get();
    }

    public int numSegments() {
        return (Integer)this.numSegments.get();
    }

    public float capacityFactor() {
        return ((Float)this.capacityFactor.get()).floatValue();
    }

    public KeyPartitioner keyPartitioner() {
        return (KeyPartitioner)this.keyPartitioner.get();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public List<ConfigurationInfo> subElements() {
        return this.elements;
    }

    public String toString() {
        return "HashConfiguration [attributes=" + this.attributes + "]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashConfiguration other = (HashConfiguration)obj;
        if (this.attributes == null) {
            return other.attributes == null;
        }
        return this.attributes.equals((Object)other.attributes);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributes == null ? 0 : this.attributes.hashCode());
        return result;
    }

    public boolean matches(HashConfiguration other) {
        return this.attributes.matches(other.attributes);
    }
}

