/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.health.impl;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.health.CacheHealth;
import org.infinispan.health.ClusterHealth;
import org.infinispan.health.HealthStatus;
import org.infinispan.health.impl.CacheHealthImpl;
import org.infinispan.health.impl.InvalidCacheHealth;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;

class ClusterHealthImpl
implements ClusterHealth {
    private final EmbeddedCacheManager cacheManager;
    private final InternalCacheRegistry internalCacheRegistry;

    ClusterHealthImpl(EmbeddedCacheManager cacheManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        this.internalCacheRegistry = internalCacheRegistry;
    }

    @Override
    public HealthStatus getHealthStatus() {
        return Stream.concat(this.cacheManager.getCacheNames().stream(), this.internalCacheRegistry.getInternalCacheNames().stream()).map(this::getCacheHealth).filter(Objects::nonNull).map(CacheHealth::getStatus).filter(h -> !h.equals((Object)HealthStatus.HEALTHY)).findFirst().orElse(HealthStatus.HEALTHY);
    }

    private CacheHealth getCacheHealth(String cacheName) {
        try {
            Cache cache = this.cacheManager.getCache(cacheName, false);
            return cache != null ? new CacheHealthImpl(cache) : null;
        }
        catch (CacheException cacheException) {
            return new InvalidCacheHealth(cacheName);
        }
    }

    @Override
    public String getClusterName() {
        return this.cacheManager.getClusterName();
    }

    @Override
    public int getNumberOfNodes() {
        return Optional.ofNullable(this.cacheManager.getMembers()).orElse(Collections.emptyList()).size();
    }

    @Override
    public List<String> getNodeNames() {
        return Optional.ofNullable(this.cacheManager.getMembers()).orElse(Collections.emptyList()).stream().map(Object::toString).collect(Collectors.toList());
    }
}

