/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

public enum ValueMatcher {
    MATCH_ALWAYS{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue) {
            return true;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_ALWAYS;
        }
    }
    ,
    MATCH_EXPECTED{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue) {
            return existingValue == null ? expectedValue == null : existingValue.equals(expectedValue);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NEW;
        }
    }
    ,
    MATCH_EXPECTED_OR_NEW{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue) {
            if (existingValue == null) {
                return expectedValue == null || newValue == null;
            }
            return existingValue.equals(expectedValue) || existingValue.equals(newValue);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NEW;
        }
    }
    ,
    MATCH_EXPECTED_OR_NULL{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue) {
            return existingValue == null || existingValue.equals(expectedValue);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NULL;
        }
    }
    ,
    MATCH_NON_NULL{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue) {
            return existingValue != null;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return false;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_ALWAYS;
        }
    }
    ,
    MATCH_NEVER{

        @Override
        public boolean matches(Object existingValue, Object expectedValue, Object newValue) {
            return false;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return false;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_NEVER;
        }
    };

    private static final ValueMatcher[] CACHED_VALUES;

    public abstract boolean matches(Object var1, Object var2, Object var3);

    @Deprecated
    public abstract boolean nonExistentEntryCanMatch();

    public abstract ValueMatcher matcherForRetry();

    public static ValueMatcher valueOf(int ordinal) {
        return CACHED_VALUES[ordinal];
    }

    static {
        CACHED_VALUES = ValueMatcher.values();
    }
}

