/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.ConfigurationBuilderInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.configuration.cache.AbstractIndexingConfigurationChildBuilder;
import org.infinispan.configuration.cache.IndexMergeConfigurationBuilder;
import org.infinispan.configuration.cache.IndexWriterConfiguration;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;

public class IndexWriterConfigurationBuilder
extends AbstractIndexingConfigurationChildBuilder
implements Builder<IndexWriterConfiguration>,
ConfigurationBuilderInfo {
    private final AttributeSet attributes = IndexWriterConfiguration.attributeDefinitionSet();
    private final IndexMergeConfigurationBuilder indexMergeConfigurationBuilder;
    private final Attribute<Integer> commitInterval;
    private final Attribute<Integer> threadPoolSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_THREAD_POOL_SIZE);
    private final Attribute<Integer> queueCount = this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_COUNT);
    private final Attribute<Integer> queueSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_QUEUE_SIZE);
    private final Attribute<Integer> ramBufferSize;
    private final Attribute<Integer> maxBufferedEntries;
    private final Attribute<Boolean> lowLevelTrace;
    private final List<ConfigurationBuilderInfo> subElements;

    IndexWriterConfigurationBuilder(IndexingConfigurationBuilder builder) {
        super(builder);
        this.commitInterval = this.attributes.attribute(IndexWriterConfiguration.INDEX_COMMIT_INTERVAL);
        this.ramBufferSize = this.attributes.attribute(IndexWriterConfiguration.INDEX_RAM_BUFFER_SIZE);
        this.maxBufferedEntries = this.attributes.attribute(IndexWriterConfiguration.INDEX_MAX_BUFFERED_ENTRIES);
        this.lowLevelTrace = this.attributes.attribute(IndexWriterConfiguration.INDEX_LOW_LEVEL_TRACE);
        this.indexMergeConfigurationBuilder = new IndexMergeConfigurationBuilder(builder);
        this.subElements = Collections.singletonList(this.indexMergeConfigurationBuilder);
    }

    public Collection<ConfigurationBuilderInfo> getChildrenInfo() {
        return this.subElements;
    }

    public IndexMergeConfigurationBuilder merge() {
        return this.indexMergeConfigurationBuilder;
    }

    public IndexWriterConfigurationBuilder threadPoolSize(int value) {
        this.threadPoolSize.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder queueCount(int value) {
        this.queueCount.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder queueSize(int value) {
        this.queueSize.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder commitInterval(int value) {
        this.commitInterval.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder ramBufferSize(int value) {
        this.ramBufferSize.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder maxBufferedEntries(int value) {
        this.maxBufferedEntries.set((Object)value);
        return this;
    }

    public IndexWriterConfigurationBuilder setLowLevelTrace(boolean value) {
        this.lowLevelTrace.set((Object)value);
        return this;
    }

    public ElementDefinition<IndexWriterConfiguration> getElementDefinition() {
        return IndexWriterConfiguration.ELEMENT_DEFINITION;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public IndexWriterConfiguration create() {
        return new IndexWriterConfiguration(this.attributes.protect(), this.indexMergeConfigurationBuilder.create());
    }

    public IndexWriterConfigurationBuilder read(IndexWriterConfiguration template) {
        this.attributes.read(template.attributes());
        this.indexMergeConfigurationBuilder.read(template.merge());
        return this;
    }

    public String toString() {
        return "IndexWriterConfigurationBuilder{attributes=" + this.attributes + ", indexMergeConfigurationBuilder=" + this.indexMergeConfigurationBuilder + '}';
    }

    public void validate() {
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }
}

