/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.local;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.infinispan.BaseCacheStream;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.CacheAware;
import org.infinispan.stream.impl.intops.object.DistinctOperation;
import org.infinispan.stream.impl.intops.object.FilterOperation;
import org.infinispan.stream.impl.intops.object.FlatMapOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToIntOperation;
import org.infinispan.stream.impl.intops.object.FlatMapToLongOperation;
import org.infinispan.stream.impl.intops.object.LimitOperation;
import org.infinispan.stream.impl.intops.object.MapOperation;
import org.infinispan.stream.impl.intops.object.MapToDoubleOperation;
import org.infinispan.stream.impl.intops.object.MapToIntOperation;
import org.infinispan.stream.impl.intops.object.MapToLongOperation;
import org.infinispan.stream.impl.intops.object.PeekOperation;
import org.infinispan.stream.impl.intops.object.SkipOperation;
import org.infinispan.stream.impl.intops.object.SortedComparatorOperation;
import org.infinispan.stream.impl.intops.object.SortedOperation;
import org.infinispan.stream.impl.local.AbstractLocalCacheStream;
import org.infinispan.stream.impl.local.LocalDoubleCacheStream;
import org.infinispan.stream.impl.local.LocalIntCacheStream;
import org.infinispan.stream.impl.local.LocalLongCacheStream;
import org.infinispan.util.function.SerializableSupplier;

public class LocalCacheStream<R>
extends AbstractLocalCacheStream<R, Stream<R>, CacheStream<R>>
implements CacheStream<R> {
    public LocalCacheStream(AbstractLocalCacheStream.StreamSupplier<R, Stream<R>> streamSupplier, boolean parallel, ComponentRegistry registry) {
        super(streamSupplier, parallel, registry);
    }

    public LocalCacheStream(AbstractLocalCacheStream<?, ?, ?> other) {
        super(other);
    }

    @Override
    public LocalCacheStream<R> sequentialDistribution() {
        return this;
    }

    @Override
    public LocalCacheStream<R> parallelDistribution() {
        return this;
    }

    @Override
    public LocalCacheStream<R> filterKeySegments(Set<Integer> segments) {
        return this.filterKeySegments(IntSets.from(segments));
    }

    @Override
    public LocalCacheStream<R> filterKeySegments(IntSet segments) {
        this.segmentsToFilter = segments;
        return this;
    }

    @Override
    public LocalCacheStream<R> filterKeys(Set<?> keys) {
        this.keysToFilter = keys;
        return this;
    }

    @Override
    public LocalCacheStream<R> distributedBatchSize(int batchSize) {
        return this;
    }

    @Override
    public LocalCacheStream<R> segmentCompletionListener(BaseCacheStream.SegmentCompletionListener listener) {
        return this;
    }

    @Override
    public LocalCacheStream<R> disableRehashAware() {
        return this;
    }

    @Override
    public LocalCacheStream<R> filter(Predicate<? super R> predicate) {
        this.registry.wireDependencies(predicate);
        this.intermediateOperations.add(new FilterOperation<R>(predicate));
        return this;
    }

    @Override
    public <R1> LocalCacheStream<R1> map(Function<? super R, ? extends R1> mapper) {
        this.registry.wireDependencies(mapper);
        this.intermediateOperations.add(new MapOperation<R, R1>(mapper));
        return this;
    }

    @Override
    public LocalIntCacheStream mapToInt(ToIntFunction<? super R> mapper) {
        this.intermediateOperations.add(new MapToIntOperation<R>(mapper));
        return new LocalIntCacheStream(this);
    }

    @Override
    public LocalLongCacheStream mapToLong(ToLongFunction<? super R> mapper) {
        this.intermediateOperations.add(new MapToLongOperation<R>(mapper));
        return new LocalLongCacheStream(this);
    }

    @Override
    public LocalDoubleCacheStream mapToDouble(ToDoubleFunction<? super R> mapper) {
        this.intermediateOperations.add(new MapToDoubleOperation<R>(mapper));
        return new LocalDoubleCacheStream(this);
    }

    @Override
    public <R1> LocalCacheStream<R1> flatMap(Function<? super R, ? extends Stream<? extends R1>> mapper) {
        this.intermediateOperations.add(new FlatMapOperation(mapper));
        return this;
    }

    @Override
    public LocalIntCacheStream flatMapToInt(Function<? super R, ? extends IntStream> mapper) {
        this.intermediateOperations.add(new FlatMapToIntOperation<R>(mapper));
        return new LocalIntCacheStream(this);
    }

    @Override
    public LocalLongCacheStream flatMapToLong(Function<? super R, ? extends LongStream> mapper) {
        this.intermediateOperations.add(new FlatMapToLongOperation<R>(mapper));
        return new LocalLongCacheStream(this);
    }

    @Override
    public LocalDoubleCacheStream flatMapToDouble(Function<? super R, ? extends DoubleStream> mapper) {
        this.intermediateOperations.add(new FlatMapToDoubleOperation<R>(mapper));
        return new LocalDoubleCacheStream(this);
    }

    @Override
    public LocalCacheStream<R> distinct() {
        this.intermediateOperations.add(DistinctOperation.getInstance());
        return this;
    }

    @Override
    public LocalCacheStream<R> sorted() {
        this.intermediateOperations.add(SortedOperation.getInstance());
        return this;
    }

    @Override
    public LocalCacheStream<R> sorted(Comparator<? super R> comparator) {
        this.intermediateOperations.add(new SortedComparatorOperation<R>(comparator));
        return this;
    }

    @Override
    public LocalCacheStream<R> peek(Consumer<? super R> action) {
        this.intermediateOperations.add(new PeekOperation<R>(action));
        return this;
    }

    @Override
    public LocalCacheStream<R> limit(long maxSize) {
        this.intermediateOperations.add(new LimitOperation(maxSize));
        return this;
    }

    @Override
    public LocalCacheStream<R> skip(long n) {
        this.intermediateOperations.add(new SkipOperation(n));
        return this;
    }

    @Override
    public void forEach(Consumer<? super R> action) {
        this.injectCache(action);
        try (Stream stream = (Stream)this.createStream();){
            stream.forEach(action);
        }
    }

    @Override
    public <K, V> void forEach(BiConsumer<Cache<K, V>, ? super R> action) {
        Cache cache = this.registry.getComponent(Cache.class);
        this.registry.wireDependencies(action);
        try (Stream stream = (Stream)this.createStream();){
            stream.forEach((? super T e) -> action.accept(cache, (Object)e));
        }
    }

    @Override
    public void forEachOrdered(Consumer<? super R> action) {
        this.injectCache(action);
        try (Stream stream = (Stream)this.createStream();){
            stream.forEachOrdered(action);
        }
    }

    private void injectCache(Consumer<? super R> cacheAware) {
        if (cacheAware instanceof CacheAware) {
            ((CacheAware)((Object)cacheAware)).injectCache(this.registry.getComponent(Cache.class));
        }
    }

    @Override
    public Object[] toArray() {
        try (Stream stream = (Stream)this.createStream();){
            Object[] objectArray = stream.toArray();
            return objectArray;
        }
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        try (Stream stream = (Stream)this.createStream();){
            A[] AArray = stream.toArray(generator);
            return AArray;
        }
    }

    @Override
    public R reduce(R identity, BinaryOperator<R> accumulator) {
        try (Stream stream = (Stream)this.createStream();){
            R r = stream.reduce(identity, accumulator);
            return r;
        }
    }

    @Override
    public Optional<R> reduce(BinaryOperator<R> accumulator) {
        try (Stream stream = (Stream)this.createStream();){
            Optional<R> optional = stream.reduce(accumulator);
            return optional;
        }
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super R, U> accumulator, BinaryOperator<U> combiner) {
        try (Stream stream = (Stream)this.createStream();){
            U u = stream.reduce(identity, accumulator, combiner);
            return u;
        }
    }

    @Override
    public <R1> R1 collect(Supplier<R1> supplier, BiConsumer<R1, ? super R> accumulator, BiConsumer<R1, R1> combiner) {
        try (Stream stream = (Stream)this.createStream();){
            R1 R1 = stream.collect(supplier, accumulator, combiner);
            return R1;
        }
    }

    @Override
    public <R1, A> R1 collect(Collector<? super R, A, R1> collector) {
        try (Stream stream = (Stream)this.createStream();){
            R1 R1 = stream.collect(collector);
            return R1;
        }
    }

    @Override
    public <R1> R1 collect(SerializableSupplier<Collector<? super R, ?, R1>> supplier) {
        try (Stream stream = (Stream)this.createStream();){
            Object r = stream.collect((Collector)supplier.get());
            return (R1)r;
        }
    }

    @Override
    public <R1> R1 collect(Supplier<Collector<? super R, ?, R1>> supplier) {
        try (Stream stream = (Stream)this.createStream();){
            R1 R1 = stream.collect(supplier.get());
            return R1;
        }
    }

    @Override
    public Optional<R> min(Comparator<? super R> comparator) {
        try (Stream stream = (Stream)this.createStream();){
            Optional<? super R> optional = stream.min(comparator);
            return optional;
        }
    }

    @Override
    public Optional<R> max(Comparator<? super R> comparator) {
        try (Stream stream = (Stream)this.createStream();){
            Optional<? super R> optional = stream.max(comparator);
            return optional;
        }
    }

    @Override
    public long count() {
        try (Stream stream = (Stream)this.createStream();){
            long l = stream.count();
            return l;
        }
    }

    @Override
    public boolean anyMatch(Predicate<? super R> predicate) {
        try (Stream stream = (Stream)this.createStream();){
            boolean bl = stream.anyMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean allMatch(Predicate<? super R> predicate) {
        try (Stream stream = (Stream)this.createStream();){
            boolean bl = stream.allMatch(predicate);
            return bl;
        }
    }

    @Override
    public boolean noneMatch(Predicate<? super R> predicate) {
        try (Stream stream = (Stream)this.createStream();){
            boolean bl = stream.noneMatch(predicate);
            return bl;
        }
    }

    @Override
    public Optional<R> findFirst() {
        try (Stream stream = (Stream)this.createStream();){
            Optional optional = stream.findFirst();
            return optional;
        }
    }

    @Override
    public Optional<R> findAny() {
        try (Stream stream = (Stream)this.createStream();){
            Optional optional = stream.findAny();
            return optional;
        }
    }

    @Override
    public Iterator<R> iterator() {
        Stream stream = (Stream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.iterator();
    }

    @Override
    public Spliterator<R> spliterator() {
        Stream stream = (Stream)this.createStream();
        this.onCloseRunnables.add(stream::close);
        return stream.spliterator();
    }

    @Override
    public LocalCacheStream<R> timeout(long timeout, TimeUnit unit) {
        return this;
    }
}

