/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.commons.util.Util;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.metadata.impl.IracMetadata;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracManagerKeyInfo;
import org.infinispan.xsite.irac.IracManagerKeyInfoImpl;

public class IracStateResponseCommand
implements CacheRpcCommand {
    public static final byte COMMAND_ID = 120;
    private ByteString cacheName;
    private Collection<State> stateCollection;

    public IracStateResponseCommand() {
    }

    public IracStateResponseCommand(ByteString cacheName) {
        this.cacheName = cacheName;
    }

    public IracStateResponseCommand(ByteString cacheName, int capacity) {
        this(cacheName);
        this.stateCollection = new ArrayList<State>(capacity);
    }

    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry registry) {
        IracManager manager = registry.getIracManager().running();
        for (State state : this.stateCollection) {
            state.apply(manager);
        }
        return CompletableFutures.completedNull();
    }

    @Override
    public byte getCommandId() {
        return 120;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void writeTo(ObjectOutput output) throws IOException {
        MarshallUtil.marshallCollection(this.stateCollection, (ObjectOutput)output, IracStateResponseCommand::writeStateTo);
    }

    @Override
    public void readFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        this.stateCollection = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new, IracStateResponseCommand::readStateFrom);
    }

    @Override
    public ByteString getCacheName() {
        return this.cacheName;
    }

    @Override
    public Address getOrigin() {
        return null;
    }

    @Override
    public void setOrigin(Address origin) {
    }

    public void add(IracManagerKeyInfo keyInfo, IracMetadata tombstone) {
        this.stateCollection.add(new State(keyInfo, tombstone));
    }

    public String toString() {
        return "IracStateResponseCommand{cacheName=" + this.cacheName + ", state=" + Util.toStr(this.stateCollection) + '}';
    }

    private static void writeStateTo(ObjectOutput output, State state) throws IOException {
        IracManagerKeyInfoImpl.writeTo(state.keyInfo, output);
        IracMetadata.writeTo(output, state.tombstone);
    }

    private static State readStateFrom(ObjectInput input) throws IOException, ClassNotFoundException {
        return new State(IracManagerKeyInfoImpl.readFrom(input), IracMetadata.readFrom(input));
    }

    private static class State {
        final IracManagerKeyInfo keyInfo;
        final IracMetadata tombstone;

        State(IracManagerKeyInfo keyInfo, IracMetadata tombstone) {
            this.keyInfo = Objects.requireNonNull(keyInfo);
            this.tombstone = tombstone;
        }

        void apply(IracManager manager) {
            manager.receiveState(this.keyInfo.getSegment(), this.keyInfo.getKey(), this.keyInfo.getOwner(), this.tombstone);
        }

        public String toString() {
            return "State{keyInfo=" + this.keyInfo + ", tombstone=" + this.tombstone + '}';
        }
    }
}

