/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.infinispan.commons.marshall.InstanceReusingAdvancedExternalizer;
import org.infinispan.marshall.core.Ids;
import org.infinispan.topology.CacheStatusResponse;

public class ManagerStatusResponse
implements Serializable {
    private final Map<String, CacheStatusResponse> caches;
    private final boolean rebalancingEnabled;

    public ManagerStatusResponse(Map<String, CacheStatusResponse> caches, boolean rebalancingEnabled) {
        this.rebalancingEnabled = rebalancingEnabled;
        this.caches = caches;
    }

    public Map<String, CacheStatusResponse> getCaches() {
        return this.caches;
    }

    public boolean isRebalancingEnabled() {
        return this.rebalancingEnabled;
    }

    public String toString() {
        return "ManagerStatusResponse{caches=" + this.caches + ", rebalancingEnabled=" + this.rebalancingEnabled + '}';
    }

    public static class Externalizer
    extends InstanceReusingAdvancedExternalizer<ManagerStatusResponse> {
        public void doWriteObject(ObjectOutput output, ManagerStatusResponse cacheStatusResponse) throws IOException {
            output.writeObject(cacheStatusResponse.caches);
            output.writeBoolean(cacheStatusResponse.rebalancingEnabled);
        }

        public ManagerStatusResponse doReadObject(ObjectInput unmarshaller) throws IOException, ClassNotFoundException {
            Map caches = (Map)unmarshaller.readObject();
            boolean rebalancingEnabled = unmarshaller.readBoolean();
            return new ManagerStatusResponse(caches, rebalancingEnabled);
        }

        public Integer getId() {
            return Ids.MANAGER_STATUS_RESPONSE;
        }

        public Set<Class<? extends ManagerStatusResponse>> getTypeClasses() {
            return Collections.singleton(ManagerStatusResponse.class);
        }
    }
}

