/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport.jgroups;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.IllegalLifecycleStateException;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.commons.util.logging.TraceException;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.CacheManagerJmxRegistration;
import org.infinispan.metrics.impl.MetricsCollector;
import org.infinispan.notifications.cachemanagerlistener.CacheManagerNotifier;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.InboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.responses.ExceptionResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.AbstractRequest;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.impl.EmptyRaftManager;
import org.infinispan.remoting.transport.impl.FilterMapResponseCollector;
import org.infinispan.remoting.transport.impl.MapResponseCollector;
import org.infinispan.remoting.transport.impl.MultiTargetRequest;
import org.infinispan.remoting.transport.impl.RequestRepository;
import org.infinispan.remoting.transport.impl.SingleResponseCollector;
import org.infinispan.remoting.transport.impl.SingleTargetRequest;
import org.infinispan.remoting.transport.impl.SingletonMapResponseCollector;
import org.infinispan.remoting.transport.impl.SiteUnreachableXSiteResponse;
import org.infinispan.remoting.transport.impl.XSiteResponseImpl;
import org.infinispan.remoting.transport.jgroups.ClusterView;
import org.infinispan.remoting.transport.jgroups.JGroupsAddress;
import org.infinispan.remoting.transport.jgroups.JGroupsAddressCache;
import org.infinispan.remoting.transport.jgroups.JGroupsBackupResponse;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelConfigurator;
import org.infinispan.remoting.transport.jgroups.JGroupsChannelLookup;
import org.infinispan.remoting.transport.jgroups.JGroupsMetricsMetadata;
import org.infinispan.remoting.transport.jgroups.JGroupsRaftManager;
import org.infinispan.remoting.transport.jgroups.JGroupsTopologyAwareAddress;
import org.infinispan.remoting.transport.jgroups.NamedSocketFactory;
import org.infinispan.remoting.transport.jgroups.RaftUtil;
import org.infinispan.remoting.transport.jgroups.SingleSiteRequest;
import org.infinispan.remoting.transport.jgroups.StaggeredRequest;
import org.infinispan.remoting.transport.jgroups.ThreadPoolProbeHandler;
import org.infinispan.remoting.transport.raft.RaftManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.GlobalXSiteAdminOperations;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteNamedCache;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.commands.XSiteViewNotificationCommand;
import org.jgroups.BytesMessage;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.JChannel;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.UpHandler;
import org.jgroups.View;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.jmx.JmxConfigurator;
import org.jgroups.protocols.FORK;
import org.jgroups.protocols.relay.RELAY2;
import org.jgroups.protocols.relay.RouteStatusListener;
import org.jgroups.protocols.relay.SiteAddress;
import org.jgroups.protocols.relay.SiteMaster;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.ExtendedUUID;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@Scope(value=Scopes.GLOBAL)
public class JGroupsTransport
implements Transport,
ChannelListener {
    public static final String CONFIGURATION_STRING = "configurationString";
    public static final String CONFIGURATION_XML = "configurationXml";
    public static final String CONFIGURATION_FILE = "configurationFile";
    public static final String CHANNEL_LOOKUP = "channelLookup";
    public static final String CHANNEL_CONFIGURATOR = "channelConfigurator";
    public static final String SOCKET_FACTORY = "socketFactory";
    private static final String METRICS_PREFIX = "jgroups_";
    public static final short REQUEST_FLAGS_UNORDERED = (short)(Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
    public static final short REQUEST_FLAGS_PER_SENDER = Message.Flag.NO_TOTAL_ORDER.value();
    public static final short REPLY_FLAGS = (short)(Message.Flag.NO_FC.value() | Message.Flag.OOB.value() | Message.Flag.NO_TOTAL_ORDER.value());
    protected static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "default-configs/default-jgroups-udp.xml";
    public static final Log log = LogFactory.getLog(JGroupsTransport.class);
    private static final CompletableFuture<Map<Address, Response>> EMPTY_RESPONSES_FUTURE = CompletableFuture.completedFuture(Collections.emptyMap());
    private static final short CORRELATOR_ID = 0;
    private static final short HEADER_ID = ClassConfigurator.getProtocolId(RequestCorrelator.class);
    private static final byte REQUEST = 0;
    private static final byte RESPONSE = 1;
    private static final byte SINGLE_MESSAGE = 2;
    @Inject
    protected GlobalConfiguration configuration;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    protected StreamingMarshaller marshaller;
    @Inject
    protected CacheManagerNotifier notifier;
    @Inject
    protected TimeService timeService;
    @Inject
    protected InboundInvocationHandler invocationHandler;
    @Inject
    @ComponentName(value="org.infinispan.executors.timeout")
    protected ScheduledExecutorService timeoutExecutor;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    protected ExecutorService nonBlockingExecutor;
    @Inject
    protected CacheManagerJmxRegistration jmxRegistration;
    @Inject
    protected GlobalXSiteAdminOperations globalXSiteAdminOperations;
    @Inject
    protected ComponentRef<MetricsCollector> metricsCollector;
    private final Lock viewUpdateLock = new ReentrantLock();
    private final Condition viewUpdateCondition = this.viewUpdateLock.newCondition();
    private final ThreadPoolProbeHandler probeHandler;
    private final ChannelCallbacks channelCallbacks = new ChannelCallbacks();
    private final Map<JChannel, Set<Object>> clusters = new ConcurrentHashMap<JChannel, Set<Object>>();
    protected boolean connectChannel = true;
    protected boolean disconnectChannel = true;
    protected boolean closeChannel = true;
    protected TypedProperties props;
    protected JChannel channel;
    protected Address address;
    protected Address physicalAddress;
    protected volatile ClusterView clusterView = new ClusterView(-1, Collections.emptyList(), null);
    private CompletableFuture<Void> nextViewFuture = new CompletableFuture();
    private RequestRepository requests;
    private final Map<String, SiteUnreachableReason> unreachableSites;
    private String localSite;
    private volatile RaftManager raftManager = EmptyRaftManager.INSTANCE;
    private boolean running;

    public static FORK findFork(JChannel channel) {
        return (FORK)channel.getProtocolStack().findProtocol(FORK.class);
    }

    public JGroupsTransport(JChannel channel) {
        this();
        this.channel = channel;
        if (channel == null) {
            throw new IllegalArgumentException("Cannot deal with a null channel!");
        }
        if (channel.isConnected()) {
            throw new IllegalArgumentException("Channel passed in cannot already be connected!");
        }
    }

    public JGroupsTransport() {
        this.probeHandler = new ThreadPoolProbeHandler();
        this.unreachableSites = new ConcurrentHashMap<String, SiteUnreachableReason>();
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand command, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) {
        boolean broadcast;
        if (recipients != null && recipients.isEmpty()) {
            log.tracef("Destination list is empty: no need to send command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        ClusterView view = this.clusterView;
        List<Address> localMembers = view.getMembers();
        int membersSize = localMembers.size();
        boolean ignoreLeavers = mode == ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS || mode == ResponseMode.WAIT_FOR_VALID_RESPONSE;
        boolean sendStaggeredRequest = mode == ResponseMode.WAIT_FOR_VALID_RESPONSE && deliverOrder == DeliverOrder.NONE && recipients != null && recipients.size() > 1 && timeout > 0L;
        boolean bl = broadcast = recipients == null;
        if (recipients == null && membersSize == 1) {
            log.tracef("The cluster has a single node: no need to broadcast command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        Address singleTarget = this.computeSingleTarget(recipients, localMembers, membersSize, broadcast);
        if (this.address.equals(singleTarget)) {
            log.tracef("Skipping request to self for command %s", command);
            return EMPTY_RESPONSES_FUTURE;
        }
        if (mode.isAsynchronous()) {
            return this.performAsyncRemoteInvocation(recipients, command, deliverOrder, broadcast, singleTarget);
        }
        Collection<Address> actualTargets = broadcast ? localMembers : recipients;
        return this.performSyncRemoteInvocation(actualTargets, command, mode, timeout, responseFilter, deliverOrder, ignoreLeavers, sendStaggeredRequest, broadcast, singleTarget);
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand command, DeliverOrder deliverOrder) {
        if (destination.equals(this.address)) {
            if (log.isTraceEnabled()) {
                log.tracef("%s not sending command to self: %s", this.address, command);
            }
            return;
        }
        this.logCommand(command, destination);
        this.sendCommand(destination, command, 0L, deliverOrder, true, true);
    }

    @Override
    public void sendToMany(Collection<Address> targets, ReplicableCommand command, DeliverOrder deliverOrder) {
        if (targets == null) {
            this.logCommand(command, "all");
            this.sendCommandToAll(command, 0L, deliverOrder);
        } else {
            this.logCommand(command, targets);
            this.sendCommand(targets, command, 0L, deliverOrder, true);
        }
    }

    @Override
    @Deprecated
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> commands, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        if (commands == null || commands.isEmpty()) {
            log.trace("Destination list is empty: no need to send message");
            return Collections.emptyMap();
        }
        if (mode.isSynchronous()) {
            MapResponseCollector collector = MapResponseCollector.validOnly(commands.size());
            CompletionStage<Map<Address, Response>> request = this.invokeCommands(commands.keySet(), commands::get, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
            try {
                return (Map)CompletableFutures.await(request.toCompletableFuture());
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                cause.addSuppressed((Throwable)new TraceException());
                throw org.infinispan.commons.util.Util.rewrapAsCacheException((Throwable)cause);
            }
        }
        commands.forEach((a, command) -> {
            this.logCommand((ReplicableCommand)command, a);
            this.sendCommand((Address)a, (ReplicableCommand)command, 0L, deliverOrder, true, true);
        });
        return Collections.emptyMap();
    }

    @Override
    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand command) {
        if (log.isTraceEnabled()) {
            log.tracef("About to send to backups %s, command %s", backups, command);
        }
        HashMap<XSiteBackup, CompletableFuture<ValidResponse>> backupCalls = new HashMap<XSiteBackup, CompletableFuture<ValidResponse>>(backups.size());
        for (XSiteBackup xsb : backups) {
            assert (!this.localSite.equals(xsb.getSiteName())) : "sending to local site";
            Address recipient = JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)new SiteMaster(xsb.getSiteName()));
            long requestId = this.requests.newRequestId();
            this.logRequest(requestId, command, recipient, "backup");
            SingleSiteRequest<ValidResponse> request = new SingleSiteRequest<ValidResponse>(SingleResponseCollector.validOnly(), requestId, this.requests, xsb.getSiteName());
            this.addRequest(request);
            backupCalls.put(xsb, request);
            DeliverOrder order = xsb.isSync() ? DeliverOrder.NONE : DeliverOrder.PER_SENDER;
            long timeout = xsb.getTimeout();
            try {
                this.sendCommand(recipient, command, request.getRequestId(), order, false, false);
                if (timeout <= 0L) continue;
                request.setTimeout(this.timeoutExecutor, timeout, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                request.cancel(true);
                throw t;
            }
        }
        return new JGroupsBackupResponse(backupCalls, this.timeService);
    }

    @Override
    public <O> XSiteResponse<O> backupRemotely(XSiteBackup backup, XSiteReplicateCommand<O> rpcCommand) {
        assert (!this.localSite.equals(backup.getSiteName())) : "sending to local site";
        if (this.unreachableSites.containsKey(backup.getSiteName())) {
            return new SiteUnreachableXSiteResponse(backup, this.timeService);
        }
        Address recipient = JGroupsAddressCache.fromJGroupsAddress((org.jgroups.Address)new SiteMaster(backup.getSiteName()));
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, rpcCommand, recipient, "backup");
        SingleSiteRequest<ValidResponse> request = new SingleSiteRequest<ValidResponse>(SingleResponseCollector.validOnly(), requestId, this.requests, backup.getSiteName());
        this.addRequest(request);
        DeliverOrder order = backup.isSync() ? DeliverOrder.NONE : DeliverOrder.PER_SENDER;
        long timeout = backup.getTimeout();
        XSiteResponseImpl xSiteResponse = new XSiteResponseImpl(this.timeService, backup);
        try {
            this.sendCommand(recipient, rpcCommand, request.getRequestId(), order, false, false);
            if (timeout > 0L) {
                request.setTimeout(this.timeoutExecutor, timeout, TimeUnit.MILLISECONDS);
            }
            request.whenComplete((BiConsumer)xSiteResponse);
        }
        catch (Throwable t) {
            request.cancel(true);
            xSiteResponse.completeExceptionally(t);
        }
        return xSiteResponse;
    }

    @Override
    public boolean isCoordinator() {
        return this.clusterView.isCoordinator();
    }

    @Override
    public Address getCoordinator() {
        return this.clusterView.getCoordinator();
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        if (this.physicalAddress == null && this.channel != null) {
            org.jgroups.Address addr = (org.jgroups.Address)this.channel.down(new Event(87, (Object)this.channel.getAddress()));
            if (addr == null) {
                return Collections.emptyList();
            }
            this.physicalAddress = new JGroupsAddress(addr);
        }
        return Collections.singletonList(this.physicalAddress);
    }

    @Override
    public List<Address> getMembers() {
        return this.clusterView.getMembers();
    }

    @Override
    public List<Address> getMembersPhysicalAddresses() {
        if (this.channel != null) {
            View v = this.channel.getView();
            org.jgroups.Address[] rawMembers = v.getMembersRaw();
            ArrayList<Address> addresses = new ArrayList<Address>(rawMembers.length);
            for (org.jgroups.Address rawMember : rawMembers) {
                PhysicalAddress physical_addr = (PhysicalAddress)this.channel.down(new Event(87, (Object)rawMember));
                addresses.add(new JGroupsAddress((org.jgroups.Address)physical_addr));
            }
            return addresses;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.channel.getProtocolStack().getTransport().supportsMulticasting();
    }

    @Override
    public void checkCrossSiteAvailable() throws CacheConfigurationException {
        if (this.localSite == null) {
            throw Log.CLUSTER.crossSiteUnavailable();
        }
    }

    @Override
    public String localSiteName() {
        return this.localSite;
    }

    @Override
    public String localNodeName() {
        if (this.channel == null) {
            return Transport.super.localNodeName();
        }
        return this.channel.getName();
    }

    @Override
    @Start
    public void start() {
        if (this.running) {
            throw new IllegalStateException("Two or more cache managers are using the same JGroupsTransport instance");
        }
        this.probeHandler.updateThreadPool(this.nonBlockingExecutor);
        this.props = TypedProperties.toTypedProperties((Map)this.configuration.transport().properties());
        this.requests = new RequestRepository();
        String stack = this.configuration.transport().stack();
        if (stack != null) {
            Log.CLUSTER.startingJGroupsChannel(this.configuration.transport().clusterName(), this.configuration.transport().stack());
        } else {
            Log.CLUSTER.startingJGroupsChannel(this.configuration.transport().clusterName());
        }
        this.initChannel();
        this.channel.setUpHandler((UpHandler)this.channelCallbacks);
        this.setXSiteViewListener(this.channelCallbacks);
        this.startJGroupsChannelIfNeeded();
        this.waitForInitialNodes();
        this.channel.getProtocolStack().getTransport().registerProbeHandler((DiagnosticsHandler.ProbeHandler)this.probeHandler);
        RELAY2 relay2 = this.findRelay2();
        if (relay2 != null) {
            this.localSite = XSiteNamedCache.cachedString(relay2.site());
        }
        this.running = true;
    }

    protected void initChannel() {
        TransportConfiguration transportCfg = this.configuration.transport();
        if (this.channel == null) {
            String transportNodeName;
            this.buildChannel();
            if (this.connectChannel && (transportNodeName = transportCfg.nodeName()) != null && !transportNodeName.isEmpty()) {
                this.channel.setName(transportNodeName);
            }
        }
        this.channel.setDiscardOwnMessages(false);
        if (transportCfg.hasTopologyInfo()) {
            if (this.connectChannel) {
                this.channel.addAddressGenerator(() -> JGroupsTopologyAwareAddress.randomUUID(this.channel.getName(), transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId()));
            } else {
                org.jgroups.Address jgroupsAddress = this.channel.getAddress();
                if (jgroupsAddress instanceof ExtendedUUID) {
                    JGroupsTopologyAwareAddress address = new JGroupsTopologyAwareAddress((ExtendedUUID)jgroupsAddress);
                    if (!address.matches(transportCfg.siteId(), transportCfg.rackId(), transportCfg.machineId())) {
                        throw new CacheException("Topology information does not match the one set by the provided JGroups channel");
                    }
                } else {
                    throw new CacheException("JGroups address does not contain topology coordinates");
                }
            }
        }
        this.initRaftManager();
    }

    private void initRaftManager() {
        TransportConfiguration transportCfg = this.configuration.transport();
        if (RaftUtil.isRaftAvailable()) {
            if (transportCfg.nodeName() == null || transportCfg.nodeName().isEmpty()) {
                log.raftProtocolUnavailable("transport.node-name is not set.");
                return;
            }
            if (transportCfg.raftMembers().isEmpty()) {
                log.raftProtocolUnavailable("transport.raft-members is not set.");
                return;
            }
            byte[] key = Util.stringToBytes((String)"raft-id");
            byte[] value = Util.stringToBytes((String)transportCfg.nodeName());
            if (this.connectChannel) {
                this.channel.addAddressGenerator(() -> ExtendedUUID.randomUUID((String)this.channel.getName()).put(key, value));
            } else {
                org.jgroups.Address addr = this.channel.getAddress();
                if (addr instanceof ExtendedUUID && !Arrays.equals(((ExtendedUUID)addr).get(key), value)) {
                    log.raftProtocolUnavailable("non-managed JGroups channel does not have 'raft-id' set.");
                    return;
                }
            }
            this.insertForkIfMissing();
            this.raftManager = new JGroupsRaftManager(this.configuration, this.channel);
            this.raftManager.start();
            log.raftProtocolAvailable();
        }
    }

    private void insertForkIfMissing() {
        if (JGroupsTransport.findFork(this.channel) != null) {
            return;
        }
        ProtocolStack protocolStack = this.channel.getProtocolStack();
        RELAY2 relay2 = this.findRelay2();
        if (relay2 != null) {
            protocolStack.insertProtocolInStack((Protocol)new FORK(), (Protocol)relay2, ProtocolStack.Position.BELOW);
        } else {
            protocolStack.addProtocol((Protocol)new FORK());
        }
    }

    private void setXSiteViewListener(RouteStatusListener listener) {
        RELAY2 relay2 = this.findRelay2();
        if (relay2 != null) {
            relay2.setRouteStatusListener(listener);
            Set<String> view = this.getSitesView();
            if (view != null && !view.isEmpty()) {
                Log.XSITE.receivedXSiteClusterView(view);
            }
        }
    }

    protected void startJGroupsChannelIfNeeded() {
        String clusterName = this.configuration.transport().clusterName();
        if (log.isDebugEnabled()) {
            log.debugf("JGroups protocol stack: %s\n", this.channel.getProtocolStack().printProtocolSpec(true));
        }
        if (this.connectChannel) {
            try {
                this.channel.connect(clusterName);
            }
            catch (Exception e) {
                throw new CacheException("Unable to start JGroups Channel", (Throwable)e);
            }
        }
        this.registerMBeansIfNeeded(clusterName);
        if (!this.connectChannel) {
            this.receiveClusterView(this.channel.getView());
        }
        Log.CLUSTER.localAndPhysicalAddress(clusterName, this.getAddress(), this.getPhysicalAddresses());
    }

    private void registerMBeansIfNeeded(String clusterName) {
        try {
            if (this.jmxRegistration.enabled()) {
                ObjectName namePrefix = new ObjectName(this.jmxRegistration.getDomain() + ":manager=" + ObjectName.quote(this.configuration.cacheManagerName()));
                JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)this.jmxRegistration.getMBeanServer(), (ObjectName)namePrefix, (String)clusterName, (boolean)true);
            }
        }
        catch (Exception e) {
            throw new CacheException("Channel connected, but unable to register MBeans", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInitialNodes() {
        int initialClusterSize = this.configuration.transport().initialClusterSize();
        if (initialClusterSize <= 1) {
            return;
        }
        long timeout = this.configuration.transport().initialClusterTimeout();
        long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeout);
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.channel.getView().getMembers().size() < initialClusterSize && remainingNanos > 0L) {
                log.debugf("Waiting for %d nodes, current view has %d", initialClusterSize, this.channel.getView().getMembers().size());
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        catch (InterruptedException e) {
            Log.CLUSTER.interruptedWaitingForCoordinator(e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.viewUpdateLock.unlock();
        }
        if (remainingNanos <= 0L) {
            throw Log.CLUSTER.timeoutWaitingForInitialNodes(initialClusterSize, this.channel.getView().getMembers());
        }
        log.debugf("Initial cluster size of %d nodes reached", initialClusterSize);
    }

    private void buildChannel() {
        FileLookup fileLookup = FileLookupFactory.newInstance();
        if (this.props != null) {
            String cfg;
            if (this.props.containsKey((Object)CHANNEL_LOOKUP)) {
                String channelLookupClassName = this.props.getProperty(CHANNEL_LOOKUP);
                try {
                    JGroupsChannelLookup lookup = (JGroupsChannelLookup)org.infinispan.commons.util.Util.getInstance((String)channelLookupClassName, (ClassLoader)this.configuration.classLoader());
                    this.channel = lookup.getJGroupsChannel((Properties)this.props);
                    this.connectChannel = lookup.shouldConnect();
                    this.disconnectChannel = lookup.shouldDisconnect();
                    this.closeChannel = lookup.shouldClose();
                }
                catch (ClassCastException e) {
                    Log.CLUSTER.wrongTypeForJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException((Throwable)e);
                }
                catch (Exception e) {
                    Log.CLUSTER.errorInstantiatingJGroupsChannelLookup(channelLookupClassName, e);
                    throw new CacheException((Throwable)e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CHANNEL_CONFIGURATOR)) {
                this.channelFromConfigurator((JGroupsChannelConfigurator)this.props.get((Object)CHANNEL_CONFIGURATOR));
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_FILE)) {
                cfg = this.props.getProperty(CONFIGURATION_FILE);
                Collection<Object> confs = Collections.emptyList();
                try {
                    confs = fileLookup.lookupFileLocations(cfg, this.configuration.classLoader());
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (confs.isEmpty()) {
                    throw Log.CLUSTER.jgroupsConfigurationNotFound(cfg);
                }
                if (confs.size() > 1) {
                    Log.CLUSTER.ambiguousConfigurationFiles(org.infinispan.commons.util.Util.toStr(confs));
                }
                try {
                    URL url = (URL)confs.iterator().next();
                    this.channel = new JChannel(url.openStream());
                }
                catch (Exception e) {
                    throw Log.CLUSTER.errorCreatingChannelFromConfigFile(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_XML)) {
                cfg = this.props.getProperty(CONFIGURATION_XML);
                try {
                    this.channel = new JChannel((InputStream)new ByteArrayInputStream(cfg.getBytes()));
                }
                catch (Exception e) {
                    throw Log.CLUSTER.errorCreatingChannelFromXML(cfg, e);
                }
            }
            if (this.channel == null && this.props.containsKey((Object)CONFIGURATION_STRING)) {
                cfg = this.props.getProperty(CONFIGURATION_STRING);
                try {
                    this.channel = new JChannel((InputStream)new ByteArrayInputStream(cfg.getBytes()));
                }
                catch (Exception e) {
                    throw Log.CLUSTER.errorCreatingChannelFromConfigString(cfg, e);
                }
            }
            if (this.channel == null && this.configuration.transport().stack() != null) {
                this.channelFromConfigurator(this.configuration.transport().jgroups().configurator(this.configuration.transport().stack()));
            }
        }
        if (this.channel == null) {
            Log.CLUSTER.unableToUseJGroupsPropertiesProvided(this.props);
            try (InputStream is = fileLookup.lookupFileLocation(DEFAULT_JGROUPS_CONFIGURATION_FILE, this.configuration.classLoader()).openStream();){
                this.channel = new JChannel(is);
            }
            catch (Exception e) {
                throw Log.CLUSTER.errorCreatingChannelFromConfigFile(DEFAULT_JGROUPS_CONFIGURATION_FILE, e);
            }
        }
        if (this.props != null && this.props.containsKey((Object)SOCKET_FACTORY) && !this.props.containsKey((Object)CHANNEL_CONFIGURATOR)) {
            Protocol protocol = this.channel.getProtocolStack().getTopProtocol();
            protocol.setSocketFactory((SocketFactory)this.props.get((Object)SOCKET_FACTORY));
        }
    }

    private void channelFromConfigurator(JGroupsChannelConfigurator configurator) {
        if (this.props.containsKey((Object)SOCKET_FACTORY)) {
            SocketFactory socketFactory = (SocketFactory)this.props.get((Object)SOCKET_FACTORY);
            if (socketFactory instanceof NamedSocketFactory) {
                ((NamedSocketFactory)socketFactory).setName(this.configuration.transport().clusterName());
            }
            configurator.setSocketFactory(socketFactory);
        }
        configurator.addChannelListener(this);
        try {
            this.channel = configurator.createChannel(this.configuration.transport().clusterName());
        }
        catch (Exception e) {
            throw Log.CLUSTER.errorCreatingChannelFromConfigurator(configurator.getProtocolStackString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveClusterView(View newView) {
        boolean hasNotifier;
        List<List<Address>> subGroups;
        if (this.address == null) {
            org.jgroups.Address jgroupsAddress = this.channel.getAddress();
            this.address = JGroupsAddressCache.fromJGroupsAddress(jgroupsAddress);
            if (log.isTraceEnabled()) {
                String uuid = jgroupsAddress instanceof UUID ? ((UUID)jgroupsAddress).toStringLong() : "N/A";
                log.tracef("Local address %s, uuid %s", jgroupsAddress, uuid);
            }
        }
        if (newView instanceof MergeView) {
            Log.CLUSTER.receivedMergedView(this.channel.clusterName(), newView);
            subGroups = new ArrayList();
            List jgroupsSubGroups = ((MergeView)newView).getSubgroups();
            for (View group : jgroupsSubGroups) {
                subGroups.add(JGroupsTransport.fromJGroupsAddressList(group.getMembers()));
            }
        } else {
            Log.CLUSTER.receivedClusterView(this.channel.clusterName(), newView);
            subGroups = Collections.emptyList();
        }
        long viewId = newView.getViewId().getId();
        List<Address> members = JGroupsTransport.fromJGroupsAddressList(newView.getMembers());
        if (members.isEmpty()) {
            return;
        }
        ClusterView oldView = this.clusterView;
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            if (log.isDebugEnabled() && oldView.getMembers() != null) {
                ArrayList<Address> joined = new ArrayList<Address>(members);
                joined.removeAll(oldView.getMembers());
                ArrayList<Address> left = new ArrayList<Address>(oldView.getMembers());
                left.removeAll(members);
                log.debugf("Joined: %s, Left: %s", joined, left);
            }
            this.clusterView = new ClusterView((int)viewId, members, this.address);
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                CompletableFuture<Void> future = oldFuture;
                this.nonBlockingExecutor.execute(() -> future.complete(null));
            }
        }
        boolean bl = hasNotifier = this.notifier != null;
        if (hasNotifier) {
            if (!subGroups.isEmpty()) {
                Address address1 = this.getAddress();
                CompletionStages.join(this.notifier.notifyMerge(members, oldView.getMembers(), address1, (int)viewId, subGroups));
            } else {
                CompletionStages.join(this.notifier.notifyViewChange(members, oldView.getMembers(), this.getAddress(), (int)viewId));
            }
        }
        this.nonBlockingExecutor.execute(() -> {
            if (this.requests != null) {
                this.requests.forEach(request -> request.onNewView(this.clusterView.getMembersSet()));
            }
        });
        JGroupsAddressCache.pruneAddressCache();
    }

    private static List<Address> fromJGroupsAddressList(List<org.jgroups.Address> list) {
        return Collections.unmodifiableList(list.stream().map(JGroupsAddressCache::fromJGroupsAddress).collect(Collectors.toList()));
    }

    @Override
    @Stop
    public void stop() {
        this.running = false;
        if (this.channel != null) {
            this.channel.getProtocolStack().getTransport().unregisterProbeHandler((DiagnosticsHandler.ProbeHandler)this.probeHandler);
        }
        this.raftManager.stop();
        String clusterName = this.configuration.transport().clusterName();
        try {
            if (this.disconnectChannel && this.channel != null && this.channel.isConnected()) {
                Log.CLUSTER.disconnectJGroups(clusterName);
                this.channel.disconnect();
            }
            if (this.closeChannel && this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            this.unregisterMBeansIfNeeded(clusterName);
        }
        catch (Exception toLog) {
            Log.CLUSTER.problemClosingChannel(toLog, clusterName);
        }
        if (this.requests != null) {
            this.requests.forEach(request -> request.cancel((Exception)((Object)Log.CONTAINER.cacheManagerIsStopping())));
        }
        this.channel = null;
        this.clusterView = new ClusterView(Integer.MAX_VALUE, Collections.emptyList(), null);
        CompletableFuture<Void> oldFuture = null;
        this.viewUpdateLock.lock();
        try {
            oldFuture = this.nextViewFuture;
            this.nextViewFuture = new CompletableFuture();
            this.viewUpdateCondition.signalAll();
        }
        finally {
            this.viewUpdateLock.unlock();
            if (oldFuture != null) {
                oldFuture.complete(null);
            }
        }
    }

    private void unregisterMBeansIfNeeded(String clusterName) throws Exception {
        if (this.jmxRegistration.enabled() && this.channel != null) {
            ObjectName namePrefix = new ObjectName(this.jmxRegistration.getDomain() + ":manager=" + ObjectName.quote(this.configuration.cacheManagerName()));
            JmxConfigurator.unregisterChannel((JChannel)this.channel, (MBeanServer)this.jmxRegistration.getMBeanServer(), (ObjectName)namePrefix, (String)clusterName);
        }
    }

    @Override
    public int getViewId() {
        if (this.channel == null) {
            throw new IllegalLifecycleStateException("The cache has been stopped and invocations are not allowed!");
        }
        return this.clusterView.getViewId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> withView(int expectedViewId) {
        ClusterView view = this.clusterView;
        if (view.isViewIdAtLeast(expectedViewId)) {
            return CompletableFutures.completedNull();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Waiting for view %d, current view is %d", expectedViewId, view.getViewId());
        }
        this.viewUpdateLock.lock();
        try {
            view = this.clusterView;
            if (view.isViewIdAtLeast(Integer.MAX_VALUE)) {
                throw new IllegalLifecycleStateException();
            }
            if (view.isViewIdAtLeast(expectedViewId)) {
                CompletableFuture completableFuture = CompletableFutures.completedNull();
                return completableFuture;
            }
            CompletionStage completionStage = this.nextViewFuture.thenCompose(nil -> this.withView(expectedViewId));
            return completionStage;
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForView(int viewId) throws InterruptedException {
        if (this.channel == null) {
            return;
        }
        long remainingNanos = Long.MAX_VALUE;
        this.viewUpdateLock.lock();
        try {
            while (this.channel != null && this.getViewId() < viewId && remainingNanos > 0L) {
                log.tracef("Waiting for view %d, current view is %d", viewId, this.clusterView.getViewId());
                remainingNanos = this.viewUpdateCondition.awaitNanos(remainingNanos);
            }
        }
        finally {
            this.viewUpdateLock.unlock();
        }
    }

    @Override
    public Log getLog() {
        return log;
    }

    @Override
    public Set<String> getSitesView() {
        RELAY2 relay2 = this.findRelay2();
        if (relay2 == null) {
            return null;
        }
        List sites = relay2.getCurrentSites();
        return sites == null ? Collections.emptySet() : new TreeSet(sites);
    }

    @Override
    public boolean isSiteCoordinator() {
        RELAY2 relay2 = this.findRelay2();
        return relay2 != null && relay2.isSiteMaster();
    }

    @Override
    public Collection<Address> getRelayNodesAddress() {
        RELAY2 relay2 = this.findRelay2();
        if (relay2 == null) {
            return Collections.emptyList();
        }
        return relay2.siteMasters().stream().map(JGroupsAddressCache::fromJGroupsAddress).collect(Collectors.toList());
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        if (target.equals(this.address)) {
            return CompletableFuture.completedFuture(collector.finish());
        }
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, target, "single");
        SingleTargetRequest<T> request = new SingleTargetRequest<T>(collector, requestId, this.requests, target);
        this.addRequest(request);
        boolean invalidTarget = request.onNewView(this.clusterView.getMembersSet());
        if (!invalidTarget) {
            this.sendCommand(target, command, requestId, deliverOrder, true, false);
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, targets, "multi");
        if (targets.isEmpty()) {
            return CompletableFuture.completedFuture(collector.finish());
        }
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, targets, excludedTarget);
        if (request.isDone()) {
            return request;
        }
        try {
            this.addRequest(request);
            boolean checkView = request.onNewView(this.clusterView.getMembersSet());
            this.sendCommand(targets, command, requestId, deliverOrder, checkView);
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, null, "broadcast");
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, this.clusterView.getMembers(), excludedTarget);
        if (request.isDone()) {
            return request;
        }
        try {
            this.addRequest(request);
            request.onNewView(this.clusterView.getMembersSet());
            this.sendCommandToAll(command, requestId, deliverOrder);
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(Collection<Address> requiredTargets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, requiredTargets, "broadcast");
        Address excludedTarget = this.getAddress();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, requiredTargets, excludedTarget);
        if (request.isDone()) {
            return request;
        }
        try {
            this.addRequest(request);
            request.onNewView(this.clusterView.getMembersSet());
            this.sendCommandToAll(command, requestId, deliverOrder);
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, unit);
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        long requestId = this.requests.newRequestId();
        this.logRequest(requestId, command, targets, "staggered");
        StaggeredRequest<T> request = new StaggeredRequest<T>(collector, requestId, this.requests, targets, this.getAddress(), command, deliverOrder, timeout, unit, this);
        try {
            this.addRequest(request);
            request.onNewView(this.clusterView.getMembersSet());
            request.sendNextMessage();
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        return request;
    }

    @Override
    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        Address excludedTarget;
        long requestId = this.requests.newRequestId();
        MultiTargetRequest<T> request = new MultiTargetRequest<T>(collector, requestId, this.requests, targets, excludedTarget = this.getAddress());
        if (request.isDone()) {
            return request;
        }
        this.addRequest(request);
        boolean checkView = request.onNewView(this.clusterView.getMembersSet());
        try {
            for (Address target : targets) {
                if (target.equals(excludedTarget)) continue;
                ReplicableCommand command = commandGenerator.apply(target);
                this.logRequest(requestId, command, target, "mixed");
                this.sendCommand(target, command, requestId, deliverOrder, true, checkView);
            }
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
        if (timeout > 0L) {
            request.setTimeout(this.timeoutExecutor, timeout, timeUnit);
        }
        return request;
    }

    @Override
    public RaftManager raftManager() {
        return this.raftManager;
    }

    private void addRequest(AbstractRequest<?> request) {
        try {
            this.requests.addRequest(request);
            if (!this.running) {
                request.cancel((Exception)((Object)Log.CONTAINER.cacheManagerIsStopping()));
            }
        }
        catch (Throwable t) {
            request.cancel(true);
            throw t;
        }
    }

    void sendCommand(Address target, ReplicableCommand command, long requestId, DeliverOrder deliverOrder, boolean noRelay, boolean checkView) {
        if (checkView && !this.clusterView.contains(target)) {
            return;
        }
        BytesMessage message = new BytesMessage(JGroupsTransport.toJGroupsAddress(target));
        this.marshallRequest((Message)message, command, requestId);
        JGroupsTransport.setMessageFlags((Message)message, deliverOrder, noRelay);
        this.send((Message)message);
    }

    private static org.jgroups.Address toJGroupsAddress(Address address) {
        return ((JGroupsAddress)address).getJGroupsAddress();
    }

    private void marshallRequest(Message message, ReplicableCommand command, long requestId) {
        try {
            ByteBuffer bytes = this.marshaller.objectToBuffer((Object)command);
            message.setArray(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
            this.addRequestHeader(message, requestId);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure to marshal argument(s)", e);
        }
    }

    private static void setMessageFlags(Message message, DeliverOrder deliverOrder, boolean noRelay) {
        short flags = JGroupsTransport.encodeDeliverMode(deliverOrder);
        if (noRelay) {
            flags = (short)(flags | Message.Flag.NO_RELAY.value());
        }
        message.setFlag(flags, false);
        message.setFlag(new Message.TransientFlag[]{Message.TransientFlag.DONT_LOOPBACK});
    }

    private void send(Message message) {
        try {
            JChannel channel = this.channel;
            if (channel != null) {
                channel.send(message);
            }
        }
        catch (Exception e) {
            if (this.running) {
                throw new CacheException((Throwable)e);
            }
            throw Log.CONTAINER.cacheManagerIsStopping();
        }
    }

    private void addRequestHeader(Message message, long requestId) {
        if (requestId != 0L) {
            RequestCorrelator.Header header = new RequestCorrelator.Header(0, requestId, 0);
            message.putHeader(HEADER_ID, (Header)header);
        }
    }

    private static short encodeDeliverMode(DeliverOrder deliverOrder) {
        switch (deliverOrder) {
            case PER_SENDER: {
                return REQUEST_FLAGS_PER_SENDER;
            }
            case NONE: {
                return REQUEST_FLAGS_UNORDERED;
            }
        }
        throw new IllegalArgumentException("Unsupported deliver mode " + deliverOrder);
    }

    private Address computeSingleTarget(Collection<Address> targets, List<Address> localMembers, int membersSize, boolean broadcast) {
        Address singleTarget;
        if (broadcast) {
            singleTarget = null;
        } else if (targets == null) {
            assert (membersSize == 2);
            singleTarget = localMembers.get(0).equals(this.address) ? localMembers.get(1) : localMembers.get(0);
        } else {
            singleTarget = targets.size() == 1 ? targets.iterator().next() : null;
        }
        return singleTarget;
    }

    private CompletableFuture<Map<Address, Response>> performAsyncRemoteInvocation(Collection<Address> recipients, ReplicableCommand command, DeliverOrder deliverOrder, boolean broadcast, Address singleTarget) {
        if (broadcast) {
            this.logCommand(command, "all");
            this.sendCommandToAll(command, 0L, deliverOrder);
        } else if (singleTarget != null) {
            this.logCommand(command, singleTarget);
            this.sendCommand(singleTarget, command, 0L, deliverOrder, true, true);
        } else {
            this.logCommand(command, recipients);
            this.sendCommand(recipients, command, 0L, deliverOrder, true);
        }
        return EMPTY_RESPONSES_FUTURE;
    }

    private CompletableFuture<Map<Address, Response>> performSyncRemoteInvocation(Collection<Address> targets, ReplicableCommand command, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean ignoreLeavers, boolean sendStaggeredRequest, boolean broadcast, Address singleTarget) {
        CompletionStage<Map<Address, Response>> request;
        if (sendStaggeredRequest) {
            FilterMapResponseCollector collector = new FilterMapResponseCollector(responseFilter, false, targets.size());
            request = this.invokeCommandStaggered(targets, command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        } else if (singleTarget != null) {
            SingletonMapResponseCollector collector = ignoreLeavers ? SingletonMapResponseCollector.ignoreLeavers() : SingletonMapResponseCollector.validOnly();
            request = this.invokeCommand(singleTarget, command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        } else {
            ValidResponseCollector collector = mode == ResponseMode.WAIT_FOR_VALID_RESPONSE ? new FilterMapResponseCollector(responseFilter, false, targets.size()) : (responseFilter != null ? new FilterMapResponseCollector(responseFilter, true, targets.size()) : MapResponseCollector.ignoreLeavers(ignoreLeavers, targets.size()));
            request = broadcast ? this.invokeCommandOnAll(command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS) : this.invokeCommand(targets, command, collector, deliverOrder, timeout, TimeUnit.MILLISECONDS);
        }
        return request.toCompletableFuture();
    }

    @Override
    public void sendToAll(ReplicableCommand command, DeliverOrder deliverOrder) {
        this.logCommand(command, "all");
        this.sendCommandToAll(command, 0L, deliverOrder);
    }

    private void sendCommandToAll(ReplicableCommand command, long requestId, DeliverOrder deliverOrder) {
        BytesMessage message = new BytesMessage();
        this.marshallRequest((Message)message, command, requestId);
        JGroupsTransport.setMessageFlags((Message)message, deliverOrder, true);
        this.send((Message)message);
    }

    private void logRequest(long requestId, ReplicableCommand command, Object targets, String type) {
        if (log.isTraceEnabled()) {
            log.tracef("%s sending %s request %d to %s: %s", new Object[]{this.address, type, requestId, targets, command});
        }
    }

    private void logCommand(ReplicableCommand command, Object targets) {
        if (log.isTraceEnabled()) {
            log.tracef("%s sending command to %s: %s", this.address, targets, command);
        }
    }

    public JChannel getChannel() {
        return this.channel;
    }

    private void updateSitesView(Collection<String> sitesUp, Collection<String> sitesDown) {
        if (this.isSiteCoordinator()) {
            Set<String> reachableSites = this.getSitesView();
            log.tracef("Sites view changed: up %s, down %s, new view is %s", sitesUp, sitesDown, reachableSites);
            Log.XSITE.receivedXSiteClusterView(reachableSites);
        }
        if (sitesUp.isEmpty()) {
            return;
        }
        if (this.isCoordinator()) {
            this.globalXSiteAdminOperations.onSitesUp(sitesUp);
        } else {
            this.sendTo(this.getCoordinator(), new XSiteViewNotificationCommand(sitesUp), DeliverOrder.NONE);
        }
    }

    private void siteUnreachable(String site) {
        if (this.unreachableSites.putIfAbsent(site, SiteUnreachableReason.SITE_UNREACHABLE_EVENT) != null) {
            return;
        }
        try {
            this.cancelRequestsFromSite(site);
        }
        finally {
            this.unreachableSites.remove(site, (Object)SiteUnreachableReason.SITE_UNREACHABLE_EVENT);
        }
    }

    private void cancelRequestsFromSite(String site) {
        this.requests.forEach(request -> {
            if (request instanceof SingleSiteRequest) {
                ((SingleSiteRequest)request).sitesUnreachable(site);
            }
        });
    }

    private void sendCommand(Collection<Address> targets, ReplicableCommand command, long requestId, DeliverOrder deliverOrder, boolean checkView) {
        Objects.requireNonNull(targets);
        BytesMessage message = new BytesMessage();
        this.marshallRequest((Message)message, command, requestId);
        JGroupsTransport.setMessageFlags((Message)message, deliverOrder, true);
        BytesMessage copy = message;
        Iterator<Address> it = targets.iterator();
        while (it.hasNext()) {
            Address address = it.next();
            if (checkView && !this.clusterView.contains(address) || address.equals(this.getAddress())) continue;
            copy.dest(JGroupsTransport.toJGroupsAddress(address));
            this.send((Message)copy);
            if (!it.hasNext()) continue;
            copy = copy.copy(true, true);
        }
    }

    TimeService getTimeService() {
        return this.timeService;
    }

    ScheduledExecutorService getTimeoutExecutor() {
        return this.timeoutExecutor;
    }

    void processMessage(Message message) {
        long requestId;
        int type;
        org.jgroups.Address src = message.src();
        short flags = message.getFlags();
        byte[] buffer = message.getArray();
        int offset = message.getOffset();
        int length = message.getLength();
        RequestCorrelator.Header header = (RequestCorrelator.Header)message.getHeader(HEADER_ID);
        if (header != null) {
            type = header.type;
            requestId = header.requestId();
        } else {
            type = 2;
            requestId = 0L;
        }
        if (!this.running) {
            if (log.isTraceEnabled()) {
                log.tracef("Ignoring message received before start or after stop", new Object[0]);
            }
            if (type == 0) {
                this.sendResponse(src, CacheNotFoundResponse.INSTANCE, requestId, null);
            }
            return;
        }
        switch (type) {
            case 0: 
            case 2: {
                this.processRequest(src, flags, buffer, offset, length, requestId);
                break;
            }
            case 1: {
                this.processResponse(src, buffer, offset, length, requestId);
                break;
            }
            default: {
                Log.CLUSTER.invalidMessageType(type, src);
            }
        }
    }

    private void sendResponse(org.jgroups.Address target, Response response, long requestId, ReplicableCommand command) {
        block9: {
            ByteBuffer bytes;
            JChannel channel;
            if (log.isTraceEnabled()) {
                log.tracef("%s sending response for request %d to %s: %s", new Object[]{this.getAddress(), requestId, target, response});
            }
            if ((channel = this.channel) == null) {
                return;
            }
            try {
                bytes = this.marshaller.objectToBuffer((Object)response);
            }
            catch (Throwable t) {
                try {
                    Throwable e = t instanceof Exception ? (Exception)t : new CacheException(t);
                    bytes = this.marshaller.objectToBuffer((Object)new ExceptionResponse((Exception)e));
                }
                catch (Throwable tt) {
                    if (channel.isConnected()) {
                        Log.CLUSTER.errorSendingResponse(requestId, target, command);
                    }
                    return;
                }
            }
            try {
                Message message = new BytesMessage(target).setFlag(REPLY_FLAGS, false);
                message.setArray(bytes.getBuf(), bytes.getOffset(), bytes.getLength());
                RequestCorrelator.Header header = new RequestCorrelator.Header(1, requestId, 0);
                message.putHeader(HEADER_ID, (Header)header);
                channel.send(message);
            }
            catch (Throwable t) {
                if (!channel.isConnected()) break block9;
                Log.CLUSTER.errorSendingResponse(requestId, target, command);
            }
        }
    }

    private void processRequest(org.jgroups.Address src, short flags, byte[] buffer, int offset, int length, long requestId) {
        try {
            Reply reply;
            DeliverOrder deliverOrder = this.decodeDeliverMode(flags);
            if (src.equals(((JGroupsAddress)this.getAddress()).getJGroupsAddress())) {
                if (log.isTraceEnabled()) {
                    log.tracef("Ignoring request %d from self without total order", requestId);
                }
                return;
            }
            ReplicableCommand command = (ReplicableCommand)this.marshaller.objectFromByteBuffer(buffer, offset, length);
            if (requestId != 0L) {
                if (log.isTraceEnabled()) {
                    log.tracef("%s received request %d from %s: %s", new Object[]{this.getAddress(), requestId, src, command});
                }
                reply = response -> this.sendResponse(src, response, requestId, command);
            } else {
                if (log.isTraceEnabled()) {
                    log.tracef("%s received command from %s: %s", this.getAddress(), src, command);
                }
                reply = Reply.NO_OP;
            }
            if (src instanceof SiteAddress) {
                String originSite = ((SiteAddress)src).getSite();
                XSiteReplicateCommand xsiteCommand = (XSiteReplicateCommand)command;
                xsiteCommand.setOriginSite(originSite);
                this.invocationHandler.handleFromRemoteSite(originSite, xsiteCommand, reply, deliverOrder);
            } else {
                this.invocationHandler.handleFromCluster(JGroupsAddressCache.fromJGroupsAddress(src), command, reply, deliverOrder);
            }
        }
        catch (Throwable t) {
            Log.CLUSTER.errorProcessingRequest(requestId, src, t);
            Throwable e = t instanceof Exception ? (Exception)t : new CacheException(t);
            this.sendResponse(src, new ExceptionResponse((Exception)e), requestId, null);
        }
    }

    private void processResponse(org.jgroups.Address src, byte[] buffer, int offset, int length, long requestId) {
        try {
            Response response;
            if (length == 0) {
                response = CacheNotFoundResponse.INSTANCE;
            } else {
                response = (Response)this.marshaller.objectFromByteBuffer(buffer, offset, length);
                if (response == null) {
                    response = SuccessfulResponse.SUCCESSFUL_EMPTY_RESPONSE;
                }
            }
            if (log.isTraceEnabled()) {
                log.tracef("%s received response for request %d from %s: %s", new Object[]{this.getAddress(), requestId, src, response});
            }
            Address address = JGroupsAddressCache.fromJGroupsAddress(src);
            this.requests.addResponse(requestId, address, response);
        }
        catch (Throwable t) {
            Log.CLUSTER.errorProcessingResponse(requestId, src, t);
        }
    }

    private DeliverOrder decodeDeliverMode(short flags) {
        boolean oob = Util.isFlagSet((short)flags, (Message.Flag)Message.Flag.OOB);
        return oob ? DeliverOrder.NONE : DeliverOrder.PER_SENDER;
    }

    private RELAY2 findRelay2() {
        return (RELAY2)this.channel.getProtocolStack().findProtocol(RELAY2.class);
    }

    public void channelConnected(JChannel channel) {
        if (this.isMetricsEnabled()) {
            MetricsCollector mc = this.metricsCollector.wired();
            this.clusters.computeIfAbsent(channel, c -> {
                String name = c.clusterName();
                org.jgroups.Address addr = c.getAddress();
                String nodeName = addr != null ? addr.toString() : c.getName();
                HashSet<Object> metrics = new HashSet<Object>();
                for (Protocol protocol : c.getProtocolStack().getProtocols()) {
                    Collection<MBeanMetadata.AttributeMetadata> attributes = JGroupsMetricsMetadata.PROTOCOL_METADATA.get(protocol.getClass());
                    if (attributes == null || attributes.isEmpty()) continue;
                    metrics.addAll(mc.registerMetrics((Object)protocol, attributes, METRICS_PREFIX + name + "_" + protocol.getName().toLowerCase() + "_", null, nodeName));
                }
                return metrics;
            });
        }
    }

    public void channelDisconnected(JChannel channel) {
        if (this.isMetricsEnabled()) {
            MetricsCollector mc = this.metricsCollector.wired();
            Set<Object> metrics = this.clusters.remove(channel);
            if (metrics != null) {
                for (Object metric : metrics) {
                    mc.unregisterMetric(metric);
                }
            }
        }
    }

    public void channelClosed(JChannel channel) {
    }

    private boolean isMetricsEnabled() {
        return this.configuration.metrics().enabled() && this.metricsCollector.wired() != null;
    }

    private static enum SiteUnreachableReason {
        SITE_DOWN_EVENT,
        SITE_UNREACHABLE_EVENT;

    }

    private class ChannelCallbacks
    implements RouteStatusListener,
    UpHandler {
        private ChannelCallbacks() {
        }

        public void sitesUp(String ... sites) {
            JGroupsTransport.this.updateSitesView(Arrays.asList(sites), Collections.emptyList());
            for (String upSite : sites) {
                JGroupsTransport.this.unreachableSites.remove(upSite, (Object)SiteUnreachableReason.SITE_DOWN_EVENT);
            }
        }

        public void sitesDown(String ... sites) {
            JGroupsTransport.this.updateSitesView(Collections.emptyList(), Arrays.asList(sites));
            ArrayList<String> requestsToCancel = new ArrayList<String>(sites.length);
            for (String downSite : sites) {
                if (JGroupsTransport.this.unreachableSites.put(downSite, SiteUnreachableReason.SITE_DOWN_EVENT) != null) continue;
                requestsToCancel.add(downSite);
            }
            requestsToCancel.forEach(x$0 -> JGroupsTransport.this.cancelRequestsFromSite((String)x$0));
        }

        public UpHandler setLocalAddress(org.jgroups.Address a) {
            return this;
        }

        public Object up(Event evt) {
            switch (evt.getType()) {
                case 6: {
                    JGroupsTransport.this.receiveClusterView((View)evt.getArg());
                    break;
                }
                case 104: {
                    SiteMaster site_master = (SiteMaster)evt.getArg();
                    String site = site_master.getSite();
                    JGroupsTransport.this.siteUnreachable(site);
                }
            }
            return null;
        }

        public Object up(Message msg) {
            JGroupsTransport.this.processMessage(msg);
            return null;
        }

        public void up(MessageBatch batch) {
            batch.forEach(message -> {
                if (message == null) {
                    return;
                }
                JGroupsTransport.this.processMessage((Message)message);
            });
        }
    }
}

