/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util;

import java.util.Iterator;
import org.infinispan.Cache;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;

public class DataContainerRemoveIterator<K, V>
implements Iterator<CacheEntry<K, V>> {
    private final Cache<K, V> cache;
    private final Iterator<InternalCacheEntry<K, V>> dataContainerIterator;
    private K previousKey;

    public DataContainerRemoveIterator(Cache<K, V> cache) {
        this(cache, cache.getAdvancedCache().getDataContainer());
    }

    public DataContainerRemoveIterator(Cache<K, V> cache, DataContainer<K, V> dataContainer) {
        if (cache == null || dataContainer == null) {
            throw new NullPointerException();
        }
        this.cache = cache;
        this.dataContainerIterator = dataContainer.iterator();
    }

    @Override
    public boolean hasNext() {
        return this.dataContainerIterator.hasNext();
    }

    @Override
    public CacheEntry<K, V> next() {
        CacheEntry entry = this.dataContainerIterator.next();
        this.previousKey = entry.getKey();
        return entry;
    }

    @Override
    public void remove() {
        if (this.previousKey == null) {
            throw new IllegalStateException();
        }
        this.cache.remove(this.previousKey);
        this.previousKey = null;
    }
}

