/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapCombineCommand<KIn, VIn, KOut, VOut>
extends BaseRpcCommand
implements CancellableCommand {
    public static final int COMMAND_ID = 30;
    private static final Log log = LogFactory.getLog(MapCombineCommand.class);
    private Set<KIn> keys = new HashSet<KIn>();
    private Mapper<KIn, VIn, KOut, VOut> mapper;
    private Reducer<KOut, VOut> combiner;
    private String taskId;
    private boolean reducePhaseDistributed;
    private boolean emitCompositeIntermediateKeys;
    private MapReduceManager mrManager;
    private UUID uuid;

    public MapCombineCommand() {
        super(null);
    }

    public MapCombineCommand(String cacheName) {
        super(cacheName);
    }

    public MapCombineCommand(String taskId, Mapper<KIn, VIn, KOut, VOut> mapper, Reducer<KOut, VOut> combiner, String cacheName, Collection<KIn> inputKeys) {
        super(cacheName);
        this.taskId = taskId;
        if (inputKeys != null && !inputKeys.isEmpty()) {
            this.keys.addAll(inputKeys);
        }
        this.mapper = mapper;
        this.combiner = combiner;
        this.uuid = UUID.randomUUID();
    }

    public void init(MapReduceManager mrManager) {
        this.mrManager = mrManager;
    }

    @Override
    public Object perform(InvocationContext context) throws Throwable {
        if (this.isReducePhaseDistributed()) {
            return this.mrManager.mapAndCombineForDistributedReduction(this);
        }
        return this.mrManager.mapAndCombineForLocalReduction(this);
    }

    public boolean isEmitCompositeIntermediateKeys() {
        return this.emitCompositeIntermediateKeys;
    }

    public void setEmitCompositeIntermediateKeys(boolean emitCompositeIntermediateKeys) {
        this.emitCompositeIntermediateKeys = emitCompositeIntermediateKeys;
    }

    public boolean isReducePhaseDistributed() {
        return this.reducePhaseDistributed;
    }

    public void setReducePhaseDistributed(boolean reducePhaseDistributed) {
        this.reducePhaseDistributed = reducePhaseDistributed;
    }

    public Set<KIn> getKeys() {
        return this.keys;
    }

    public Mapper<KIn, VIn, KOut, VOut> getMapper() {
        return this.mapper;
    }

    public Reducer<KOut, VOut> getCombiner() {
        return this.combiner;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public byte getCommandId() {
        return 30;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.taskId, this.keys, this.mapper, this.combiner, this.reducePhaseDistributed, this.emitCompositeIntermediateKeys, this.uuid};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 30) {
            throw new IllegalStateException("Invalid method id");
        }
        int i = 0;
        this.taskId = (String)args[i++];
        this.keys = (Set)args[i++];
        this.mapper = (Mapper)args[i++];
        this.combiner = (Reducer)args[i++];
        this.reducePhaseDistributed = (Boolean)args[i++];
        this.emitCompositeIntermediateKeys = (Boolean)args[i++];
        this.uuid = (UUID)args[i++];
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapCombineCommand)) {
            return false;
        }
        MapCombineCommand other = (MapCombineCommand)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    @Override
    public String toString() {
        return "MapCombineCommand [keys=" + this.keys + ", taskId=" + this.taskId + "]";
    }
}

