/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.exts;

import java.lang.reflect.Field;
import java.security.AccessController;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class SecurityActions {
    private static final Log log = LogFactory.getLog(SecurityActions.class);

    SecurityActions() {
    }

    private static Field getDeclaredField(Class<?> c, String fieldName) {
        try {
            return c.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    static Field getField(Class<?> c, String fieldName) {
        Field field;
        if (System.getSecurityManager() != null) {
            field = AccessController.doPrivileged(() -> {
                Field f = SecurityActions.getDeclaredField(c, fieldName);
                f.setAccessible(true);
                return f;
            });
        } else {
            field = SecurityActions.getDeclaredField(c, fieldName);
            field.setAccessible(true);
        }
        return field;
    }
}

