/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.totalorder;

import java.util.concurrent.CountDownLatch;
import org.infinispan.transaction.totalorder.TotalOrderLatch;

public class TotalOrderLatchImpl
implements TotalOrderLatch {
    private final String name;
    private final CountDownLatch latch;

    public TotalOrderLatchImpl(String name) {
        if (name == null) {
            throw new NullPointerException("Name cannot be null");
        }
        this.name = name;
        this.latch = new CountDownLatch(1);
    }

    @Override
    public boolean isBlocked() {
        return this.latch.getCount() > 0L;
    }

    @Override
    public void unBlock() {
        this.latch.countDown();
    }

    @Override
    public void awaitUntilUnBlock() throws InterruptedException {
        this.latch.await();
    }

    public String toString() {
        return "TotalOrderLatchImpl{latch=" + this.latch + ", name='" + this.name + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TotalOrderLatchImpl that = (TotalOrderLatchImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

