/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.tm;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.tx.XidImpl;

public final class EmbeddedXid
extends XidImpl {
    private static final int FORMAT = 1;
    private static final AtomicLong GLOBAL_ID_GENERATOR = new AtomicLong(1L);
    private static final AtomicLong BRANCH_QUALIFIER_GENERATOR = new AtomicLong(1L);

    public EmbeddedXid(UUID transactionManagerId) {
        super(1, EmbeddedXid.create(transactionManagerId, GLOBAL_ID_GENERATOR), EmbeddedXid.create(transactionManagerId, BRANCH_QUALIFIER_GENERATOR));
    }

    private static void longToBytes(long val, byte[] array, int offset) {
        for (int i = 7; i > 0; --i) {
            array[offset + i] = (byte)val;
            val >>>= 8;
        }
        array[offset] = (byte)val;
    }

    private static byte[] create(UUID transactionManagerId, AtomicLong generator) {
        byte[] field = new byte[24];
        EmbeddedXid.longToBytes(transactionManagerId.getLeastSignificantBits(), field, 0);
        EmbeddedXid.longToBytes(transactionManagerId.getMostSignificantBits(), field, 8);
        EmbeddedXid.longToBytes(generator.incrementAndGet(), field, 16);
        return field;
    }
}

