/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import org.infinispan.commons.util.ByRef;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.stream.impl.KeyTrackingTerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public class MapIteratorOperation<K, V, V2>
extends BaseTerminalOperation
implements KeyTrackingTerminalOperation<K, V, V2> {
    protected final int batchSize;

    public MapIteratorOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<Stream<CacheEntry>> supplier, int batchSize) {
        super(intermediateOperations, supplier);
        this.batchSize = batchSize;
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return true;
    }

    @Override
    public List<V> performOperation(KeyTrackingTerminalOperation.IntermediateCollector<Collection<V>> response) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<CacheEntry<K, V2>> performOperationRehashAware(KeyTrackingTerminalOperation.IntermediateCollector<Collection<CacheEntry<K, V2>>> response) {
        Object stream = ((BaseStream)this.supplier.get()).sequential();
        ArrayList<CacheEntry<K, V2>> collectedValues = new ArrayList<CacheEntry<K, V2>>(this.batchSize);
        ByRef<Object> ref = new ByRef<Object>(null);
        stream = ((Stream)stream).peek(e -> ref.set(e.getKey()));
        for (IntermediateOperation intermediateOperation : this.intermediateOperations) {
            stream = intermediateOperation.perform(stream);
        }
        Stream convertedStream = (Stream)stream;
        convertedStream.forEach(v -> {
            collectedValues.add(new ImmortalCacheEntry(ref.get(), v));
            if (collectedValues.size() >= this.batchSize) {
                response.sendDataResonse(collectedValues);
                collectedValues.clear();
            }
        });
        return collectedValues;
    }

    public int getBatchSize() {
        return this.batchSize;
    }
}

