/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction.entry;

import io.netty.buffer.ByteBuf;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transaction.entry.ControlByte;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public class Modification {
    private final byte[] key;
    private final byte[] value;
    private final long versionRead;
    private final CacheEntryExpiration.Impl expiration;
    private final byte control;

    Modification(byte[] key, byte[] value, long versionRead, CacheEntryExpiration expiration, byte control) {
        this.key = key;
        this.value = value;
        this.versionRead = versionRead;
        this.expiration = (CacheEntryExpiration.Impl)expiration;
        this.control = control;
    }

    public void writeTo(ByteBuf byteBuf, Codec codec) {
        ByteBufUtil.writeArray(byteBuf, this.key);
        byteBuf.writeByte((int)this.control);
        if (!ControlByte.NON_EXISTING.hasFlag(this.control) && !ControlByte.NOT_READ.hasFlag(this.control)) {
            byteBuf.writeLong(this.versionRead);
        }
        if (ControlByte.REMOVE_OP.hasFlag(this.control)) {
            return;
        }
        codec.writeExpirationParams(byteBuf, this.expiration);
        ByteBufUtil.writeArray(byteBuf, this.value);
    }

    public int estimateSize(Codec codec) {
        int size = this.key.length + 1;
        if (!ControlByte.NON_EXISTING.hasFlag(this.control) && !ControlByte.NOT_READ.hasFlag(this.control)) {
            size += 8;
        }
        if (!ControlByte.REMOVE_OP.hasFlag(this.control)) {
            size += this.value.length;
            size += codec.estimateExpirationSize(this.expiration);
        }
        return size;
    }

    public byte[] getKey() {
        return this.key;
    }
}

