/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.transaction.entry;

import java.time.Duration;
import java.util.function.Function;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheEntryMetadata;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.impl.cache.CacheEntryMetadataImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.impl.cache.MetadataValue;
import org.infinispan.hotrod.impl.transaction.entry.ControlByte;
import org.infinispan.hotrod.impl.transaction.entry.Modification;

public class TransactionEntry<K, V> {
    private final K key;
    private final long version;
    private final byte readControl;
    private V value;
    private CacheEntryMetadata metadata;
    private boolean modified;

    private TransactionEntry(K key, long version, byte readControl) {
        this.key = key;
        this.version = version;
        this.readControl = readControl;
        this.modified = false;
    }

    public static <K, V> TransactionEntry<K, V> nonExistingEntry(K key) {
        return new TransactionEntry<K, V>(key, 0L, ControlByte.NON_EXISTING.bit());
    }

    public static <K, V> TransactionEntry<K, V> notReadEntry(K key) {
        return new TransactionEntry<K, V>(key, 0L, ControlByte.NOT_READ.bit());
    }

    public static <K, V> TransactionEntry<K, V> read(K key, MetadataValue<V> value) {
        TransactionEntry<K, V> txEntry = new TransactionEntry<K, V>(key, value.getVersion(), 0);
        txEntry.value = value.getValue();
        CacheEntryExpiration expiration = value.getLifespan() < 0 ? (value.getMaxIdle() < 0 ? CacheEntryExpiration.IMMORTAL : CacheEntryExpiration.withMaxIdle((Duration)Duration.ofSeconds(value.getMaxIdle()))) : (value.getMaxIdle() < 0 ? CacheEntryExpiration.withLifespan((Duration)Duration.ofSeconds(value.getLifespan())) : CacheEntryExpiration.withLifespanAndMaxIdle((Duration)Duration.ofSeconds(value.getLifespan()), (Duration)Duration.ofSeconds(value.getMaxIdle())));
        txEntry.metadata = new CacheEntryMetadataImpl(value.getCreated(), value.getLastUsed(), expiration, new CacheEntryVersionImpl(value.getVersion()));
        return txEntry;
    }

    public long getVersion() {
        return this.version;
    }

    public V getValue() {
        return this.value;
    }

    public boolean isModified() {
        return this.modified;
    }

    public boolean isNonExists() {
        return this.value == null;
    }

    public boolean exists() {
        return this.value != null;
    }

    public void set(CacheEntry<K, V> entry) {
        this.value = entry.value();
        this.metadata = entry.metadata();
        this.modified = true;
    }

    public void remove() {
        this.value = null;
        this.modified = true;
    }

    public Modification toModification(Function<K, byte[]> keyMarshaller, Function<V, byte[]> valueMarshaller) {
        if (this.value == null) {
            return new Modification(keyMarshaller.apply(this.key), null, this.version, this.metadata.expiration(), ControlByte.REMOVE_OP.set(this.readControl));
        }
        return new Modification(keyMarshaller.apply(this.key), valueMarshaller.apply(this.value), this.version, this.metadata.expiration(), this.readControl);
    }

    public String toString() {
        return "TransactionEntry{key=" + Util.toStr(this.key) + ", version=" + this.version + ", readControl=" + ControlByte.prettyPrint(this.readControl) + ", value=" + Util.toStr(this.value) + ", expiration=" + this.metadata.expiration() + ", modified=" + this.modified + "}";
    }
}

