/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.commons.util.Util;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;

public abstract class AbstractKeyValueOperation<K, T>
extends AbstractKeyOperation<K, T> {
    protected final byte[] value;

    protected AbstractKeyValueOperation(OperationContext operationContext, short requestCode, short responseCode, K key, byte[] keyBytes, byte[] value, CacheOptions options, DataFormat dataFormat) {
        super(operationContext, requestCode, responseCode, key, keyBytes, options, dataFormat);
        this.value = value;
    }

    protected void sendKeyValueOperation(Channel channel) {
        Codec codec = this.operationContext.getCodec();
        CacheEntryExpiration.Impl expiration = (CacheEntryExpiration.Impl)((CacheWriteOptions)this.options).expiration();
        ByteBuf buf = channel.alloc().buffer(codec.estimateHeaderSize(this.header) + this.keyBytes.length + codec.estimateExpirationSize(expiration) + this.value.length);
        codec.writeHeader(buf, this.header);
        ByteBufUtil.writeArray(buf, this.keyBytes);
        codec.writeExpirationParams(buf, expiration);
        ByteBufUtil.writeArray(buf, this.value);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    protected void addParams(StringBuilder sb) {
        super.addParams(sb);
        sb.append(", value=").append(Util.printArray((byte[])this.value));
    }
}

