/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.operations.HotRodOperation;
import org.infinispan.hotrod.impl.operations.IterationEndResponse;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class IterationEndOperation
extends HotRodOperation<IterationEndResponse> {
    private final byte[] iterationId;
    private final Channel channel;

    protected IterationEndOperation(OperationContext operationContext, CacheOptions options, byte[] iterationId, Channel channel) {
        super(operationContext, (short)53, (short)54, options);
        this.iterationId = iterationId;
        this.channel = channel;
    }

    @Override
    public CompletableFuture<IterationEndResponse> execute() {
        if (!this.channel.isActive()) {
            throw Log.HOTROD.channelInactive(this.channel.remoteAddress(), this.channel.remoteAddress());
        }
        this.scheduleRead(this.channel);
        this.sendArrayOperation(this.channel, this.iterationId);
        this.releaseChannel(this.channel);
        return this;
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.complete(new IterationEndResponse(status));
    }
}

