/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.configuration;

import java.util.Locale;

public final class ProtocolVersion
extends Enum<ProtocolVersion> {
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_40 = new ProtocolVersion(4, 0);
    public static final /* enum */ ProtocolVersion PROTOCOL_VERSION_AUTO = new ProtocolVersion(4, 0, "AUTO");
    private static final ProtocolVersion[] VERSIONS;
    public static final ProtocolVersion DEFAULT_PROTOCOL_VERSION;
    public static final ProtocolVersion HIGHEST_PROTOCOL_VERSION;
    private final String textVersion;
    private final int version;
    private static final /* synthetic */ ProtocolVersion[] $VALUES;

    public static ProtocolVersion[] values() {
        return (ProtocolVersion[])$VALUES.clone();
    }

    public static ProtocolVersion valueOf(String name) {
        return Enum.valueOf(ProtocolVersion.class, name);
    }

    private ProtocolVersion(int major, int minor) {
        this(major, minor, String.format(Locale.ROOT, "%d.%d", major, minor));
    }

    private ProtocolVersion(int major, int minor, String name) {
        assert (minor < 10);
        this.textVersion = name;
        this.version = major * 10 + minor;
    }

    public String toString() {
        return this.textVersion;
    }

    public int getVersion() {
        return this.version;
    }

    public static ProtocolVersion parseVersion(String version) {
        if ("AUTO".equalsIgnoreCase(version)) {
            return PROTOCOL_VERSION_AUTO;
        }
        for (ProtocolVersion v : VERSIONS) {
            if (!v.textVersion.equals(version)) continue;
            return v;
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    public static ProtocolVersion getBestVersion(int version) {
        for (int i = VERSIONS.length - 2; i >= 0; --i) {
            if (version < ProtocolVersion.VERSIONS[i].version) continue;
            return VERSIONS[i];
        }
        throw new IllegalArgumentException("Illegal version " + version);
    }

    private static /* synthetic */ ProtocolVersion[] $values() {
        return new ProtocolVersion[]{PROTOCOL_VERSION_40, PROTOCOL_VERSION_AUTO};
    }

    static {
        $VALUES = ProtocolVersion.$values();
        VERSIONS = ProtocolVersion.values();
        DEFAULT_PROTOCOL_VERSION = PROTOCOL_VERSION_AUTO;
        HIGHEST_PROTOCOL_VERSION = VERSIONS[VERSIONS.length - 2];
    }
}

