/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl;

import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.api.common.CacheEntryExpiration;

public class TimeUnitParam {
    private static final Map<TimeUnit, Byte> timeUnitToByte = new EnumMap<TimeUnit, Byte>(TimeUnit.class);
    private static final byte TIME_UNIT_DEFAULT = 7;
    private static final byte TIME_UNIT_INFINITE = 8;

    private static byte encodeDuration(Duration duration) {
        return (byte)(duration == Duration.ZERO ? 7 : (duration == null ? 8 : 0));
    }

    public static byte encodeTimeUnits(CacheEntryExpiration.Impl expiration) {
        byte encodedLifespan = TimeUnitParam.encodeDuration(expiration.rawLifespan());
        byte encodedMaxIdle = TimeUnitParam.encodeDuration(expiration.rawMaxIdle());
        return (byte)(encodedLifespan << 4 | encodedMaxIdle);
    }

    static {
        timeUnitToByte.put(TimeUnit.SECONDS, (byte)0);
        timeUnitToByte.put(TimeUnit.MILLISECONDS, (byte)1);
        timeUnitToByte.put(TimeUnit.NANOSECONDS, (byte)2);
        timeUnitToByte.put(TimeUnit.MICROSECONDS, (byte)3);
        timeUnitToByte.put(TimeUnit.MINUTES, (byte)4);
        timeUnitToByte.put(TimeUnit.HOURS, (byte)5);
        timeUnitToByte.put(TimeUnit.DAYS, (byte)6);
    }
}

