/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.counter.operation;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.hotrod.impl.counter.operation.BaseCounterOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class AddOperation
extends BaseCounterOperation<Long> {
    private static final Log commonsLog = (Log)LogFactory.getLog(AddOperation.class, Log.class);
    private final long delta;

    public AddOperation(OperationContext operationContext, String counterName, long delta, boolean useConsistentHash) {
        super(operationContext, (short)82, (short)83, counterName, useConsistentHash);
        this.delta = delta;
    }

    @Override
    protected void executeOperation(Channel channel) {
        ByteBuf buf = this.getHeaderAndCounterNameBufferAndRead(channel, 8);
        buf.writeLong(this.delta);
        channel.writeAndFlush((Object)buf);
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        this.checkStatus(status);
        this.assertBoundaries(status);
        assert (status == 0);
        this.complete(buf.readLong());
    }

    private void assertBoundaries(short status) {
        if (status == 4) {
            if (this.delta > 0L) {
                throw commonsLog.counterOurOfBounds("Upper bound");
            }
            throw commonsLog.counterOurOfBounds("Lower bound");
        }
    }
}

