/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.Set;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryVersion;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.api.common.events.cache.CacheEntryEvent;
import org.infinispan.api.common.events.cache.CacheEntryEventType;
import org.infinispan.api.common.events.cache.CacheListenerOptions;
import org.infinispan.api.common.process.CacheEntryProcessorResult;
import org.infinispan.api.configuration.CacheConfiguration;
import org.infinispan.api.mutiny.MutinyCache;
import org.infinispan.api.mutiny.MutinyCacheEntryProcessor;
import org.infinispan.api.mutiny.MutinyQuery;
import org.infinispan.api.mutiny.MutinyStreamingCache;
import org.infinispan.hotrod.HotRod;
import org.infinispan.hotrod.HotRodMutinyContainer;
import org.infinispan.hotrod.HotRodMutinyQuery;
import org.infinispan.hotrod.HotRodMutinyStreamingCache;
import org.infinispan.hotrod.MutinyToAsyncCacheEntryProcessor;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class HotRodMutinyCache<K, V>
implements MutinyCache<K, V> {
    private final HotRod hotrod;
    private final RemoteCache<K, V> remoteCache;

    HotRodMutinyCache(HotRod hotrod, RemoteCache<K, V> remoteCache) {
        this.hotrod = hotrod;
        this.remoteCache = remoteCache;
    }

    public String name() {
        return this.remoteCache.getName();
    }

    public Uni<CacheConfiguration> configuration() {
        return Uni.createFrom().completionStage(this.remoteCache.configuration());
    }

    public HotRodMutinyContainer container() {
        return this.hotrod.mutiny();
    }

    public Uni<V> get(K key, CacheOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.get(key, options));
    }

    public Uni<CacheEntry<K, V>> getEntry(K key, CacheOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.getEntry(key, options));
    }

    public Uni<CacheEntry<K, V>> putIfAbsent(K key, V value, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.putIfAbsent(key, value, options));
    }

    public Uni<Boolean> setIfAbsent(K key, V value, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.setIfAbsent(key, value, options));
    }

    public Uni<CacheEntry<K, V>> put(K key, V value, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.put(key, value, options));
    }

    public Uni<Void> set(K key, V value, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.set(key, value, options));
    }

    public Uni<Boolean> remove(K key, CacheOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.remove(key, options));
    }

    public Uni<CacheEntry<K, V>> getAndRemove(K key, CacheOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.getAndRemove(key, options));
    }

    public Multi<K> keys(CacheOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.keys(options)));
    }

    public Multi<CacheEntry<K, V>> entries(CacheOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.entries(options)));
    }

    public Multi<CacheEntry<K, V>> getAll(Set<K> keys, CacheOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.getAll(keys, options)));
    }

    public Multi<CacheEntry<K, V>> getAll(CacheOptions options, K ... keys) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.getAll(options, keys)));
    }

    public Uni<Void> putAll(Multi<CacheEntry<K, V>> entries, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.putAll(FlowAdapters.toFlowPublisher((Publisher)entries.convert().toPublisher()), options));
    }

    public Uni<Void> putAll(Map<K, V> map, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.putAll(map, options));
    }

    public Uni<Boolean> replace(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.replace(key, value, version, options));
    }

    public Uni<CacheEntry<K, V>> getOrReplaceEntry(K key, V value, CacheEntryVersion version, CacheWriteOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.getOrReplaceEntry(key, value, version, options));
    }

    public Multi<K> removeAll(Set<K> keys, CacheWriteOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.removeAll(keys, options)));
    }

    public Multi<K> removeAll(Multi<K> keys, CacheWriteOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.removeAll(FlowAdapters.toFlowPublisher((Publisher)keys.convert().toPublisher()), options)));
    }

    public Multi<CacheEntry<K, V>> getAndRemoveAll(Multi<K> keys, CacheWriteOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.getAndRemoveAll(FlowAdapters.toFlowPublisher((Publisher)keys.convert().toPublisher()), options)));
    }

    public Uni<Long> estimateSize(CacheOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.estimateSize(options));
    }

    public Uni<Void> clear(CacheOptions options) {
        return Uni.createFrom().completionStage(() -> this.remoteCache.clear(options));
    }

    public <R> MutinyQuery<K, V, R> query(String query, CacheOptions options) {
        return new HotRodMutinyQuery(query, options);
    }

    public Multi<CacheEntryEvent<K, V>> listen(CacheListenerOptions options, CacheEntryEventType ... types) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.listen(options, types)));
    }

    public <T> Multi<CacheEntryProcessorResult<K, T>> process(Set<K> keys, MutinyCacheEntryProcessor<K, V, T> processor, CacheOptions options) {
        return Multi.createFrom().publisher(FlowAdapters.toPublisher(this.remoteCache.process(keys, new MutinyToAsyncCacheEntryProcessor<K, V, T>(processor), options)));
    }

    public MutinyStreamingCache<K> streaming() {
        return new HotRodMutinyStreamingCache<K>(this.hotrod, this.remoteCache);
    }
}

