/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.TransactionManager;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.commons.configuration.StringConfiguration;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.marshall.JavaSerializationMarshaller;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.commons.marshall.UTF8StringMarshaller;
import org.infinispan.commons.marshall.UserContextInitializerImpl;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.GlobUtils;
import org.infinispan.commons.util.Version;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.hotrod.configuration.HotRodConfiguration;
import org.infinispan.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.hotrod.configuration.RemoteCacheConfiguration;
import org.infinispan.hotrod.configuration.TransactionMode;
import org.infinispan.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.hotrod.exceptions.HotRodClientException;
import org.infinispan.hotrod.impl.MarshallerRegistry;
import org.infinispan.hotrod.impl.Util;
import org.infinispan.hotrod.impl.cache.ClientStatistics;
import org.infinispan.hotrod.impl.cache.InvalidatedNearRemoteCache;
import org.infinispan.hotrod.impl.cache.MBeanHelper;
import org.infinispan.hotrod.impl.cache.RemoteCache;
import org.infinispan.hotrod.impl.cache.RemoteCacheImpl;
import org.infinispan.hotrod.impl.counter.RemoteCounterManager;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.CacheOperationsFactory;
import org.infinispan.hotrod.impl.operations.PingResponse;
import org.infinispan.hotrod.impl.protocol.Codec;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transaction.SyncModeTransactionTable;
import org.infinispan.hotrod.impl.transaction.TransactionOperationFactory;
import org.infinispan.hotrod.impl.transaction.TransactionTable;
import org.infinispan.hotrod.impl.transaction.TransactionalRemoteCacheImpl;
import org.infinispan.hotrod.impl.transaction.XaModeTransactionTable;
import org.infinispan.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.hotrod.marshall.BytesOnlyMarshaller;
import org.infinispan.hotrod.near.NearCacheService;
import org.infinispan.hotrod.transaction.lookup.GenericTransactionManagerLookup;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;

public class HotRodTransport
implements AutoCloseable {
    private static final Log log = LogFactory.getLog(HotRodTransport.class);
    private static final String JSON_STRING_ARRAY_ELEMENT_REGEX = "(?:\")([^\"]*)(?:\",?)";
    private final MarshallerRegistry marshallerRegistry;
    private final HotRodConfiguration configuration;
    private final RemoteCounterManager counterManager;
    private final TransactionTable syncTransactionTable;
    private final XaModeTransactionTable xaTransactionTable;
    private final ChannelFactory channelFactory;
    private final Codec codec;
    private final ExecutorService asyncExecutorService;
    private final Marshaller marshaller;
    private ClientListenerNotifier listenerNotifier;
    private TimeService timeService = DefaultTimeService.INSTANCE;
    private volatile boolean started = false;
    private final ConcurrentMap<RemoteCacheKey, CompletionStage<RemoteCache<Object, Object>>> cacheName2RemoteCache = new ConcurrentHashMap<RemoteCacheKey, CompletionStage<RemoteCache<Object, Object>>>();
    private final MBeanHelper mBeanHelper;

    public HotRodTransport(HotRodConfiguration configuration) {
        this.configuration = configuration;
        this.counterManager = new RemoteCounterManager();
        this.syncTransactionTable = new SyncModeTransactionTable(configuration.transactionTimeout());
        this.xaTransactionTable = new XaModeTransactionTable(configuration.transactionTimeout());
        this.channelFactory = this.createChannelFactory();
        this.codec = Codec.forProtocol(configuration.version());
        this.marshallerRegistry = new MarshallerRegistry();
        this.marshallerRegistry.registerMarshaller(BytesOnlyMarshaller.INSTANCE);
        this.marshallerRegistry.registerMarshaller((Marshaller)new UTF8StringMarshaller());
        this.marshallerRegistry.registerMarshaller((Marshaller)new JavaSerializationMarshaller(configuration.getClassAllowList()));
        try {
            ProtoStreamMarshaller protoMarshaller = new ProtoStreamMarshaller();
            this.marshallerRegistry.registerMarshaller((Marshaller)protoMarshaller);
            this.initProtoStreamMarshaller(protoMarshaller);
        }
        catch (NoClassDefFoundError protoMarshaller) {
            // empty catch block
        }
        this.marshaller = this.initMarshaller();
        ExecutorFactory executorFactory = configuration.asyncExecutorFactory().factory();
        if (executorFactory == null) {
            executorFactory = (ExecutorFactory)org.infinispan.commons.util.Util.getInstance(configuration.asyncExecutorFactory().factoryClass());
        }
        this.asyncExecutorService = executorFactory.getExecutor((Properties)configuration.asyncExecutorFactory().properties());
        this.mBeanHelper = MBeanHelper.getInstance(this);
    }

    private Marshaller initMarshaller() {
        boolean customMarshallerInstance = true;
        Marshaller marshaller = this.configuration.marshaller();
        if (marshaller == null) {
            Class<? extends Marshaller> clazz = this.configuration.marshallerClass();
            marshaller = this.marshallerRegistry.getMarshaller(clazz);
            if (marshaller == null) {
                marshaller = (Marshaller)org.infinispan.commons.util.Util.getInstance(clazz);
            } else {
                customMarshallerInstance = false;
            }
        }
        if (customMarshallerInstance) {
            if (this.configuration.serialAllowList().length == 0) {
                marshaller.initialize(this.configuration.getClassAllowList());
            }
            if (marshaller instanceof ProtoStreamMarshaller) {
                this.initProtoStreamMarshaller((ProtoStreamMarshaller)marshaller);
            }
            this.marshallerRegistry.registerMarshaller(marshaller);
        }
        return marshaller;
    }

    protected ChannelFactory createChannelFactory() {
        return new ChannelFactory();
    }

    public MBeanHelper getMBeanHelper() {
        return this.mBeanHelper;
    }

    private void initProtoStreamMarshaller(ProtoStreamMarshaller protoMarshaller) {
        SerializationContext ctx = protoMarshaller.getSerializationContext();
        HotRodTransport.registerDefaultSchemas(ctx, "org.infinispan.protostream.types.java.CommonContainerTypesSchema", "org.infinispan.protostream.types.java.CommonTypesSchema");
        HotRodTransport.registerSerializationContextInitializer(ctx, (SerializationContextInitializer)new UserContextInitializerImpl());
        for (SerializationContextInitializer sci : this.configuration.getContextInitializers()) {
            HotRodTransport.registerSerializationContextInitializer(ctx, sci);
        }
    }

    private static void registerSerializationContextInitializer(SerializationContext ctx, SerializationContextInitializer sci) {
        sci.registerSchema(ctx);
        sci.registerMarshallers(ctx);
    }

    private static void registerDefaultSchemas(SerializationContext ctx, String ... classNames) {
        for (String className : classNames) {
            SerializationContextInitializer sci;
            try {
                Class<?> clazz = Class.forName(className);
                Object instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                sci = (SerializationContextInitializer)instance;
            }
            catch (Exception e) {
                Log.HOTROD.failedToCreatePredefinedSerializationContextInitializer(className, e);
                continue;
            }
            HotRodTransport.registerSerializationContextInitializer(ctx, sci);
        }
    }

    public HotRodConfiguration getConfiguration() {
        return this.configuration;
    }

    public TimeService getTimeService() {
        return this.timeService;
    }

    public MarshallerRegistry getMarshallerRegistry() {
        return this.marshallerRegistry;
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public CounterManager getCounterManager() {
        return this.counterManager;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public XaModeTransactionTable getXaTransactionTable() {
        return this.xaTransactionTable;
    }

    public TransactionTable getTransactionTable(TransactionMode transactionMode) {
        switch (transactionMode) {
            case NON_XA: {
                return this.syncTransactionTable;
            }
            case NON_DURABLE_XA: 
            case FULL_XA: {
                return this.xaTransactionTable;
            }
        }
        throw new IllegalStateException();
    }

    public <K, V> NearCacheService<K, V> createNearCacheService(String cacheName, NearCacheConfiguration cfg) {
        return NearCacheService.create(cfg, this.listenerNotifier);
    }

    public CacheOperationsFactory createCacheOperationFactory(String cacheName, ClientStatistics stats) {
        return new CacheOperationsFactory(this.channelFactory, cacheName, this.codec, this.listenerNotifier, this.configuration, stats);
    }

    public void start() {
        if (!this.started) {
            Log.HOTROD.debugf("Starting Hot Rod client %x", System.identityHashCode(this));
            this.channelFactory.start(this.codec, this.configuration, this.marshaller, this.asyncExecutorService, this.listenerNotifier, this.marshallerRegistry);
            this.counterManager.start(this.channelFactory, this.codec, this.configuration, this.listenerNotifier);
            this.listenerNotifier = new ClientListenerNotifier(this.codec, this.marshaller, this.channelFactory, this.configuration);
            TransactionOperationFactory txOperationFactory = new TransactionOperationFactory(this.configuration, this.channelFactory, this.codec);
            this.syncTransactionTable.start(txOperationFactory);
            this.xaTransactionTable.start(txOperationFactory);
            Log.HOTROD.debugf("Infinispan version: %s", Version.printVersion());
            this.started = true;
        }
    }

    @Override
    public void close() {
        if (this.started) {
            this.listenerNotifier.stop();
            this.counterManager.stop();
            this.channelFactory.destroy();
            this.started = false;
        }
        this.mBeanHelper.close();
    }

    public boolean isStarted() {
        return this.started;
    }

    public <K, V> CompletionStage<RemoteCache<K, V>> getRemoteCache(String cacheName) {
        RemoteCacheConfiguration cacheConfiguration = this.findConfiguration(cacheName);
        return this.getRemoteCache(cacheName, cacheConfiguration);
    }

    public <K, V> CompletionStage<RemoteCache<K, V>> getRemoteCache(String cacheName, RemoteCacheConfiguration cacheConfiguration) {
        boolean forceReturnValue = cacheConfiguration != null ? cacheConfiguration.forceReturnValues() : this.configuration.forceReturnValues();
        RemoteCacheKey key = new RemoteCacheKey(cacheName, forceReturnValue);
        CompletionStage remoteCache = this.cacheName2RemoteCache.computeIfAbsent(key, k -> this.pingRemoteCache(cacheName, cacheConfiguration));
        return remoteCache;
    }

    private <K, V> CompletionStage<RemoteCache<K, V>> pingRemoteCache(String cacheName, RemoteCacheConfiguration cacheConfiguration) {
        CompletionStage<PingResponse> pingResponse;
        CacheOperationsFactory cacheOperationsFactory = this.createOperationFactory(cacheName, this.codec, null);
        if (this.started) {
            CompletionStage<PingResponse> cs = cacheOperationsFactory.newFaultTolerantPingOperation().execute();
            pingResponse = cs.thenCompose(ping -> {
                if (ping.isCacheNotFound()) {
                    return this.createRemoteCache(cacheOperationsFactory, cacheName, cacheConfiguration);
                }
                return cs;
            });
        } else {
            pingResponse = CompletableFuture.completedFuture(PingResponse.EMPTY);
        }
        return pingResponse.thenApply(ping -> {
            RemoteCache remoteCache;
            TransactionMode transactionMode;
            TransactionMode transactionMode2 = transactionMode = cacheConfiguration != null ? cacheConfiguration.transactionMode() : TransactionMode.NONE;
            if (transactionMode == TransactionMode.NONE) {
                if (cacheConfiguration != null && cacheConfiguration.nearCache().mode().enabled()) {
                    NearCacheConfiguration nearCache = cacheConfiguration.nearCache();
                    if (log.isTraceEnabled()) {
                        log.tracef("Enabling near-caching for cache '%s'", cacheName);
                    }
                    NearCacheService nearCacheService = this.createNearCacheService(cacheName, nearCache);
                    remoteCache = InvalidatedNearRemoteCache.delegatingNearCache(new RemoteCacheImpl(this, cacheName, this.timeService, nearCacheService), nearCacheService);
                } else {
                    remoteCache = new RemoteCacheImpl(this, cacheName, this.timeService, null);
                }
            } else {
                if (!Util.await(Util.checkTransactionSupport(cacheName, cacheOperationsFactory).toCompletableFuture()).booleanValue()) {
                    throw Log.HOTROD.cacheDoesNotSupportTransactions(cacheName);
                }
                TransactionManager transactionManager = this.getTransactionManager(cacheConfiguration);
                remoteCache = this.createRemoteTransactionalCache(cacheName, transactionMode == TransactionMode.FULL_XA, transactionMode, transactionManager);
            }
            remoteCache.resolveStorage(ping.isObjectStorage());
            return remoteCache;
        });
    }

    private CompletionStage<PingResponse> createRemoteCache(CacheOperationsFactory cacheOperationsFactory, String cacheName, RemoteCacheConfiguration cacheConfiguration) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put("name", cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        if (cacheConfiguration != null && cacheConfiguration.templateName() != null) {
            params.put("template", cacheConfiguration.templateName().getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        } else if (cacheConfiguration != null && cacheConfiguration.configuration() != null) {
            params.put("configuration", new StringConfiguration(cacheConfiguration.configuration()).toStringConfiguration(cacheName).getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        } else {
            throw new HotRodClientException("Cache " + cacheName + " does not exist");
        }
        CacheOperationsFactory adminCacheOperationsFactory = new CacheOperationsFactory(this.channelFactory, this.codec, this.listenerNotifier, this.configuration);
        return adminCacheOperationsFactory.newAdminOperation("@@cache@getorcreate", params, CacheOptions.DEFAULT).execute().thenCompose(s -> cacheOperationsFactory.newFaultTolerantPingOperation().execute());
    }

    public CompletionStage<Void> removeCache(String cacheName) {
        HashMap<String, byte[]> params = new HashMap<String, byte[]>(2);
        params.put("name", cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET));
        CacheOperationsFactory adminCacheOperationsFactory = new CacheOperationsFactory(this.channelFactory, this.codec, this.listenerNotifier, this.configuration);
        return adminCacheOperationsFactory.newAdminOperation("@@cache@remove", params, CacheOptions.DEFAULT).execute().thenApply(s -> null);
    }

    public CompletionStage<Set<String>> getCacheNames() {
        return this.getConfigurationNames("@@cache@names");
    }

    public CompletionStage<Set<String>> getTemplateNames() {
        return this.getConfigurationNames("@@cache@templates");
    }

    private CompletionStage<Set<String>> getConfigurationNames(String taskName) {
        CacheOperationsFactory adminCacheOperationsFactory = new CacheOperationsFactory(this.channelFactory, this.codec, this.listenerNotifier, this.configuration);
        return adminCacheOperationsFactory.newAdminOperation(taskName, Collections.emptyMap(), CacheOptions.DEFAULT).execute().thenApply(names -> {
            HashSet<String> cacheNames = new HashSet<String>();
            Pattern pattern = Pattern.compile(JSON_STRING_ARRAY_ELEMENT_REGEX);
            Matcher matcher = pattern.matcher((CharSequence)names);
            while (matcher.find()) {
                cacheNames.add(matcher.group(1));
            }
            return cacheNames;
        });
    }

    private RemoteCacheConfiguration findConfiguration(String cacheName) {
        if (this.configuration.remoteCaches().containsKey(cacheName)) {
            return this.configuration.remoteCaches().get(cacheName);
        }
        for (Map.Entry<String, RemoteCacheConfiguration> c : this.configuration.remoteCaches().entrySet()) {
            String key = c.getKey();
            if (!GlobUtils.isGlob((String)key) || !cacheName.matches(GlobUtils.globToRegex((String)key))) continue;
            return c.getValue();
        }
        return null;
    }

    private TransactionManager getTransactionManager(RemoteCacheConfiguration cacheConfiguration) {
        try {
            return cacheConfiguration == null ? GenericTransactionManagerLookup.getInstance().getTransactionManager() : cacheConfiguration.transactionManagerLookup().getTransactionManager();
        }
        catch (Exception e) {
            throw new HotRodClientException(e);
        }
    }

    private <K, V> TransactionalRemoteCacheImpl<K, V> createRemoteTransactionalCache(String cacheName, boolean recoveryEnabled, TransactionMode transactionMode, TransactionManager transactionManager) {
        return new TransactionalRemoteCacheImpl(this, cacheName, recoveryEnabled, transactionManager, this.getTransactionTable(transactionMode), this.timeService);
    }

    private CacheOperationsFactory createOperationFactory(String cacheName, Codec codec, ClientStatistics stats) {
        return new CacheOperationsFactory(this.channelFactory, cacheName, codec, this.listenerNotifier, this.configuration, stats);
    }

    public static byte[] cacheNameBytes(String cacheName) {
        return cacheName.getBytes(HotRodConstants.HOTROD_STRING_CHARSET);
    }

    public static byte[] cacheNameBytes() {
        return HotRodConstants.DEFAULT_CACHE_NAME_BYTES;
    }

    private static class RemoteCacheKey {
        final String cacheName;
        final boolean forceReturnValue;

        RemoteCacheKey(String cacheName, boolean forceReturnValue) {
            this.cacheName = cacheName;
            this.forceReturnValue = forceReturnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RemoteCacheKey)) {
                return false;
            }
            RemoteCacheKey that = (RemoteCacheKey)o;
            if (this.forceReturnValue != that.forceReturnValue) {
                return false;
            }
            return Objects.equals(this.cacheName, that.cacheName);
        }

        public int hashCode() {
            int result = this.cacheName != null ? this.cacheName.hashCode() : 0;
            result = 31 * result + (this.forceReturnValue ? 1 : 0);
            return result;
        }
    }
}

