package org.infinispan.hotrod.impl.transport.netty;
import java.util.List;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.Map;
import java.util.Set;
import java.net.InetSocketAddress;
import io.netty.util.Signal;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.MediaTypeIds;
import org.infinispan.hotrod.impl.transport.handler.CacheRequestProcessor;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import io.netty.handler.codec.DecoderException;
import org.infinispan.hotrod.exceptions.HotRodClientException;
import org.infinispan.hotrod.exceptions.InvalidResponseException;
import org.infinispan.hotrod.exceptions.RemoteIllegalLifecycleStateException;
import org.infinispan.hotrod.exceptions.RemoteNodeSuspectException;
import org.infinispan.hotrod.impl.logging.Log;

public class HotRodClientDecoder extends ClientBaseDecoder {
	private int state;
	private int requestBytes;

	private Object hr4x_returnPossiblePrevValue;
	private MediaType hr4x_valueType;
	private List< Integer> hr4x_ownersInSegments;
	private String hr4x_mediaTypeName;
	private Set< Short> hr4x_serverOps;
	private long hr4x_long;
	private short hr4x_uByte;
	private byte[] hr4x_array;
	private int hr4x_lifespan;
	private int hr4x_numSegments;
	private short hr4x_status;
	private List< List< Integer>> hr4x_segmentOwners;
	private String hr4x_mediaParamName;
	private Map< String, String> hr4x_mediaTypeParams;
	private byte hr4x_mediaTypeDefinition;
	private int hr4x_serverOpsCount;
	private byte hr4x_headerStatus;
	private long hr4x_vLong;
	private String hr4x_mediaParamValue;
	private byte hr4x_byte;
	private MediaType hr4x_mediaType;
	private int hr4x_newTopologyId;
	private long hr4x_lastUsed;
	private int hr4x_vInt;
	private int hr4x_mediaTypeParamsNum;
	private short hr4x_vShort;
	private short hr4x_hashFunctionVersion;
	private short hr4x_resOpCode;
	private long hr4x_creation;
	private MediaType hr4x_mediaTypeDescription;
	private int hr4x_uShort;
	private String hr4x_serverMsg;
	private int hr4x_mediaTypeId;
	private String hr4x_string;
	private long hr4x_messageId;
	private int hr4x_clusterSize;
	private List< InetSocketAddress> hr4x_topologyMembers;
	private int hr4x_maxIdle;
	private byte[] hr4x_getResponseBody;
	private short hr4x_magic;
	private MediaType hr4x_keyType;

	private boolean deadEnd = false;
	public HotRodClientDecoder(HeaderDecoder delegate, CacheRequestProcessor processor) {
		super(delegate, processor);
	}

	@Override
	public void decode(ChannelHandlerContext ctx, ByteBuf buf, List<Object> out) throws Exception {
		int pos = buf.readerIndex();
		try {
			while (switch1_0(buf, out));
		} catch (Throwable t) {
			exceptionally(t);
		} finally {
			requestBytes += buf.readerIndex() - pos;
		}
	}

	private boolean switch1_0(ByteBuf buf, List<Object> out) throws Exception {
		switch (state >> 6) {
		case 0: return switch0(buf, out);
		case 1: return switch1(buf, out);
		default: throw new IllegalStateException();
		}
	}

	private boolean switch0(ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 0: 
			// 
			reset(); 
			state = 1;
			// fallthrough
		case 1: 
			// 
			deadEnd = false;
			
			state = 2;
			// fallthrough
		case 2: 
			// hr4x.request
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_magic = hr4x_uByte;
			state = 3;
			// fallthrough
		case 3: 
			// hr4x.request
			if (hr4x_magic != org.infinispan.hotrod.impl.protocol.HotRodConstants.RESPONSE_MAGIC) throw new IllegalStateException("Invalid magic response: " + hr4x_magic);
			
			state = 4;
			// fallthrough
		case 4: 
			// hr4x.request
			pos = buf.readerIndex();
			hr4x_vLong = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vLong(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_messageId = hr4x_vLong;
			state = 5;
			// fallthrough
		case 5: 
			// hr4x.request
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_resOpCode = hr4x_uByte;
			state = 6;
			// fallthrough
		case 6: 
			// hr4x.request
			if (ParserUtils.isEntryEventOp(hr4x_resOpCode) || ParserUtils.isCounterEventOp(hr4x_resOpCode)) {
				state = 7;
				return true;
			}
			delegate.loadCurrent(hr4x_messageId);
			
			state = 8;
			return true;
		case 7: 
			// hr4x.request/hr4x.parseOpIdentification
			delegateParsing(buf, hr4x_messageId, hr4x_resOpCode,(short) - 1);
			
			state = 0;
			return true;
		case 8: 
			// hr4x.request/hr4x.parseOpIdentification
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_status = hr4x_uByte;
			state = 10;
			return true;
		case 9: 
			// hr4x.request/hr4x.parseOpIdentification
			switch (hr4x_resOpCode) {
			case org.infinispan.hotrod.impl.protocol.HotRodConstants.PING_RESPONSE: 
				state = 58;
				return true;
			case org.infinispan.hotrod.impl.protocol.HotRodConstants.GET_RESPONSE: 
				state = 103;
				return true;
			case org.infinispan.hotrod.impl.protocol.HotRodConstants.PUT_RESPONSE: 
				state = 106;
				return true;
			default: 
				delegateParsing(buf, hr4x_messageId, hr4x_resOpCode, hr4x_status);
				
				state = 0;
			}
			return true;
		case 10: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			state = 11;
			// fallthrough
		case 11: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader
			if (hr4x_uByte == 1) {
				state = 13;
				return true;
			}
			;
			
			state = 12;
			// fallthrough
		case 12: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader
			if (this.operationResponseHasError(hr4x_messageId, hr4x_resOpCode)) {
				state = 33;
				return true;
			}
			;
			
			state = 9;
			return true;
		case 13: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_newTopologyId = hr4x_vInt;
			state = 14;
			// fallthrough
		case 14: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_clusterSize = hr4x_vInt;
			state = 16;
			return true;
		case 15: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology
			if (isHashDistributionAware(hr4x_messageId)) {
				state = 22;
				return true;
			}
			hr4x_hashFunctionVersion = - 1;
			state = 21;
			return true;
		case 16: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.topologyMembers
			hr4x_topologyMembers = allocList(hr4x_clusterSize);
			
			state = 17;
			// fallthrough
		case 17: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.topologyMembers
			if (hr4x_clusterSize == 0) {
				state = 15;
				return true;
			}
			hr4x_clusterSize--;
			state = 18;
			// fallthrough
		case 18: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.topologyMembers
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			state = 19;
			// fallthrough
		case 19: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.topologyMembers
			pos = buf.readerIndex();
			hr4x_uShort = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uShort(buf);
			if (buf.readerIndex() == pos) return false;
			state = 20;
			// fallthrough
		case 20: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.topologyMembers
			hr4x_topologyMembers.add(InetSocketAddress.createUnresolved(hr4x_string, hr4x_uShort));
			
			state = 17;
			return true;
		case 21: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology
			if (isHashDistributionAware(hr4x_messageId)) {
				state = 24;
				return true;
			}
			hr4x_segmentOwners = null;
			state = 23;
			return true;
		case 22: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.hashFunctionVersion
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_hashFunctionVersion = hr4x_uByte;
			state = 21;
			return true;
		case 23: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology
			responseHandler.topologyUpdate(current(), hr4x_newTopologyId, hr4x_topologyMembers.toArray(new InetSocketAddress[0]), hr4x_segmentOwners, hr4x_hashFunctionVersion);
			
			state = 12;
			return true;
		case 24: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_numSegments = hr4x_vInt;
			state = 25;
			// fallthrough
		case 25: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners
			hr4x_segmentOwners = allocList(hr4x_numSegments);
			
			state = 26;
			// fallthrough
		case 26: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners
			if (hr4x_numSegments == 0) {
				state = 23;
				return true;
			}
			hr4x_numSegments--;
			state = 27;
			// fallthrough
		case 27: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			state = 29;
			return true;
		case 28: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners
			hr4x_segmentOwners.add(hr4x_ownersInSegments);
			
			state = 26;
			return true;
		case 29: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners/hr4x.ownersInSegments
			hr4x_ownersInSegments = allocList(hr4x_uByte);
			
			state = 30;
			// fallthrough
		case 30: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners/hr4x.ownersInSegments
			if (hr4x_uByte == 0) {
				state = 28;
				return true;
			}
			hr4x_uByte--;
			state = 31;
			// fallthrough
		case 31: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners/hr4x.ownersInSegments
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			state = 32;
			// fallthrough
		case 32: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkNewTopology/hr4x.segmentOwners/hr4x.ownersInSegments
			hr4x_ownersInSegments.add(hr4x_vInt);
			
			state = 30;
			return true;
		case 33: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError
			return userSwitch33();
		case 34: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError
			;
			
			state = 9;
			return true;
		case 35: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 37;
			return true;
		case 36: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new HotRodClientException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 37: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError/hr4x.handleServerError
			Log.HOTROD.errorFromServer(hr4x_serverMsg);
			
			state = 36;
			return true;
		case 38: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 40;
			return true;
		case 39: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new HotRodClientException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 40: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError/hr4x.handleServerError
			Log.HOTROD.errorFromServer(hr4x_serverMsg);
			
			state = 39;
			return true;
		case 41: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 43;
			return true;
		case 42: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new HotRodClientException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 43: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError/hr4x.handleServerError
			Log.HOTROD.errorFromServer(hr4x_serverMsg);
			
			state = 42;
			return true;
		case 44: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 46;
			return true;
		case 45: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new HotRodClientException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 46: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError/hr4x.handleServerError
			Log.HOTROD.errorFromServer(hr4x_serverMsg);
			
			state = 45;
			return true;
		case 47: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 49;
			return true;
		case 48: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new HotRodClientException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 49: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError/hr4x.handleServerError
			Log.HOTROD.errorFromServer(hr4x_serverMsg);
			
			state = 48;
			return true;
		case 50: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 51;
			// fallthrough
		case 51: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			if (log.isTraceEnabled()) log.tracef("Server-side timeout performing operation: %s", hr4x_serverMsg);
			
			state = 52;
			// fallthrough
		case 52: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new HotRodClientException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 53: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 54;
			// fallthrough
		case 54: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new RemoteIllegalLifecycleStateException(hr4x_serverMsg, hr4x_messageId, hr4x_status, null);
			
		case 55: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverMsg = hr4x_string;
			state = 56;
			// fallthrough
		case 56: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new RemoteNodeSuspectException(hr4x_serverMsg, hr4x_messageId, hr4x_status);
			
		case 57: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseHeader/hr4x.checkHeaderError/hr4x.extractHeaderError
			throw new IllegalStateException(String.format("Unknown status: %#04x", hr4x_status));
			
		case 58: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			pos = buf.readerIndex();
			hr4x_byte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeDefinition = hr4x_byte;
			state = 60;
			return true;
		case 59: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			pos = buf.readerIndex();
			hr4x_byte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.byte_(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeDefinition = hr4x_byte;
			state = 79;
			return true;
		case 60: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType
			switch (hr4x_mediaTypeDefinition) {
			case 0: 
				state = 61;
				return true;
			case 1: 
				state = 62;
				return true;
			case 2: 
				state = 70;
				return true;
			default: 
				throw new IllegalStateException("Unknown MediaType definition: " + hr4x_mediaTypeDefinition + " for message " + hr4x_messageId);
				
			}
		case 61: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			hr4x_mediaTypeDescription = null;
			hr4x_mediaType = hr4x_mediaTypeDescription;
			hr4x_keyType = hr4x_mediaType;
			state = 59;
			return true;
		case 62: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeId = hr4x_vInt;
			state = 63;
			// fallthrough
		case 63: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeParamsNum = hr4x_vInt;
			state = 65;
			return true;
		}
		return true;
	}

	private boolean switch1(ByteBuf buf, List<Object> out) throws Exception {
		byte b;
		int pos;
		switch (state) {
		case 64: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			hr4x_mediaTypeDescription = MediaTypeIds.getMediaType((short) hr4x_mediaTypeId).withParameters(hr4x_mediaTypeParams);
			hr4x_mediaType = hr4x_mediaTypeDescription;
			hr4x_keyType = hr4x_mediaType;
			state = 59;
			return true;
		case 65: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams = allocMap(hr4x_mediaTypeParamsNum);
			
			state = 66;
			// fallthrough
		case 66: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			if (hr4x_mediaTypeParamsNum == 0) {
				state = 64;
				return true;
			}
			hr4x_mediaTypeParamsNum--;
			state = 67;
			// fallthrough
		case 67: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamName = hr4x_string;
			state = 68;
			// fallthrough
		case 68: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamValue = hr4x_string;
			state = 69;
			// fallthrough
		case 69: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams.put(hr4x_mediaParamName, hr4x_mediaParamValue);
			
			state = 66;
			return true;
		case 70: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeName = hr4x_string;
			state = 71;
			// fallthrough
		case 71: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeParamsNum = hr4x_vInt;
			state = 73;
			return true;
		case 72: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription
			hr4x_mediaTypeDescription = MediaType.fromString(hr4x_mediaTypeName).withParameters(hr4x_mediaTypeParams);
			hr4x_mediaType = hr4x_mediaTypeDescription;
			hr4x_keyType = hr4x_mediaType;
			state = 59;
			return true;
		case 73: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams = allocMap(hr4x_mediaTypeParamsNum);
			
			state = 74;
			// fallthrough
		case 74: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			if (hr4x_mediaTypeParamsNum == 0) {
				state = 72;
				return true;
			}
			hr4x_mediaTypeParamsNum--;
			state = 75;
			// fallthrough
		case 75: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamName = hr4x_string;
			state = 76;
			// fallthrough
		case 76: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamValue = hr4x_string;
			state = 77;
			// fallthrough
		case 77: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.keyType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams.put(hr4x_mediaParamName, hr4x_mediaParamValue);
			
			state = 74;
			return true;
		case 78: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			state = 97;
			return true;
		case 79: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType
			switch (hr4x_mediaTypeDefinition) {
			case 0: 
				state = 80;
				return true;
			case 1: 
				state = 81;
				return true;
			case 2: 
				state = 89;
				return true;
			default: 
				throw new IllegalStateException("Unknown MediaType definition: " + hr4x_mediaTypeDefinition + " for message " + hr4x_messageId);
				
			}
		case 80: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			hr4x_mediaTypeDescription = null;
			hr4x_mediaType = hr4x_mediaTypeDescription;
			hr4x_valueType = hr4x_mediaType;
			state = 78;
			return true;
		case 81: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeId = hr4x_vInt;
			state = 82;
			// fallthrough
		case 82: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeParamsNum = hr4x_vInt;
			state = 84;
			return true;
		case 83: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			hr4x_mediaTypeDescription = MediaTypeIds.getMediaType((short) hr4x_mediaTypeId).withParameters(hr4x_mediaTypeParams);
			hr4x_mediaType = hr4x_mediaTypeDescription;
			hr4x_valueType = hr4x_mediaType;
			state = 78;
			return true;
		case 84: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams = allocMap(hr4x_mediaTypeParamsNum);
			
			state = 85;
			// fallthrough
		case 85: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			if (hr4x_mediaTypeParamsNum == 0) {
				state = 83;
				return true;
			}
			hr4x_mediaTypeParamsNum--;
			state = 86;
			// fallthrough
		case 86: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamName = hr4x_string;
			state = 87;
			// fallthrough
		case 87: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamValue = hr4x_string;
			state = 88;
			// fallthrough
		case 88: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams.put(hr4x_mediaParamName, hr4x_mediaParamValue);
			
			state = 85;
			return true;
		case 89: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeName = hr4x_string;
			state = 90;
			// fallthrough
		case 90: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaTypeParamsNum = hr4x_vInt;
			state = 92;
			return true;
		case 91: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription
			hr4x_mediaTypeDescription = MediaType.fromString(hr4x_mediaTypeName).withParameters(hr4x_mediaTypeParams);
			hr4x_mediaType = hr4x_mediaTypeDescription;
			hr4x_valueType = hr4x_mediaType;
			state = 78;
			return true;
		case 92: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams = allocMap(hr4x_mediaTypeParamsNum);
			
			state = 93;
			// fallthrough
		case 93: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			if (hr4x_mediaTypeParamsNum == 0) {
				state = 91;
				return true;
			}
			hr4x_mediaTypeParamsNum--;
			state = 94;
			// fallthrough
		case 94: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamName = hr4x_string;
			state = 95;
			// fallthrough
		case 95: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			pos = buf.readerIndex();
			hr4x_string = org.infinispan.hotrod.impl.transport.netty.Intrinsics.string(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_mediaParamValue = hr4x_string;
			state = 96;
			// fallthrough
		case 96: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.valueType/hr4x.mediaType/hr4x.mediaTypeDescription/hr4x.mediaTypeParams
			hr4x_mediaTypeParams.put(hr4x_mediaParamName, hr4x_mediaParamValue);
			
			state = 93;
			return true;
		case 97: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_serverOpsCount = hr4x_vInt;
			state = 99;
			return true;
		case 98: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			responseHandler.pingResponse(current(), hr4x_status, hr4x_uByte, hr4x_keyType, hr4x_valueType, hr4x_serverOps);
			
			state = 0;
			return true;
		case 99: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.serverOps
			hr4x_serverOps = allocSet(hr4x_serverOpsCount);
			
			state = 100;
			// fallthrough
		case 100: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.serverOps
			if (hr4x_serverOpsCount == 0) {
				state = 98;
				return true;
			}
			hr4x_serverOpsCount--;
			state = 101;
			// fallthrough
		case 101: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.serverOps
			pos = buf.readerIndex();
			hr4x_vShort = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vShort(buf);
			if (buf.readerIndex() == pos) return false;
			state = 102;
			// fallthrough
		case 102: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.serverOps
			hr4x_serverOps.add(hr4x_vShort);
			
			state = 100;
			return true;
		case 103: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			if (! HotRodConstants.isNotExist(hr4x_status) && HotRodConstants.isSuccess(hr4x_status)) {
				state = 105;
				return true;
			}
			hr4x_getResponseBody = null;
			state = 104;
			// fallthrough
		case 104: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			responseHandler.getResponse(current(), hr4x_status, hr4x_getResponseBody);
			
			state = 0;
			return true;
		case 105: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.getResponseBody
			pos = buf.readerIndex();
			hr4x_array = org.infinispan.hotrod.impl.transport.netty.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_getResponseBody = hr4x_array;
			state = 104;
			return true;
		case 106: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			if (! HotRodConstants.isSuccess(hr4x_status)) {
				state = 108;
				return true;
			}
			;
			
			state = 107;
			// fallthrough
		case 107: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			if (! HotRodConstants.hasPrevious(hr4x_status)) {
				state = 110;
				return true;
			}
			if (HotRodConstants.isNotExist(hr4x_status) ||(! HotRodConstants.isSuccess(hr4x_status) && ! HotRodConstants.hasPrevious(hr4x_status))) {
				state = 111;
				return true;
			}
			pos = buf.readerIndex();
			hr4x_uByte = org.infinispan.hotrod.impl.transport.netty.Intrinsics.uByte(buf);
			if (buf.readerIndex() == pos) return false;
			state = 112;
			return true;
		case 108: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.assertOperationSuccess
			throw new InvalidResponseException("Unexpected response status: " + Integer.toHexString(hr4x_status));
			
		case 109: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody
			responseHandler.putResponse(current(), hr4x_returnPossiblePrevValue, hr4x_status);
			
			state = 0;
			return true;
		case 110: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue
			hr4x_returnPossiblePrevValue = null;
			state = 109;
			return true;
		case 111: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue
			hr4x_returnPossiblePrevValue = null;
			state = 109;
			return true;
		case 112: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue
			if ((hr4x_uByte & org.infinispan.hotrod.impl.protocol.HotRodConstants.INFINITE_LIFESPAN) != org.infinispan.hotrod.impl.protocol.HotRodConstants.INFINITE_LIFESPAN) {
				state = 114;
				return true;
			}
			hr4x_creation = - 1;
			hr4x_lifespan = - 1;
			
			state = 113;
			// fallthrough
		case 113: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue
			if ((hr4x_uByte & org.infinispan.hotrod.impl.protocol.HotRodConstants.INFINITE_MAXIDLE) != org.infinispan.hotrod.impl.protocol.HotRodConstants.INFINITE_MAXIDLE) {
				state = 117;
				return true;
			}
			hr4x_lastUsed = - 1;
			hr4x_maxIdle = - 1;
			
			state = 116;
			return true;
		case 114: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue/hr4x.readMetadataLifespan
			pos = buf.readerIndex();
			hr4x_long = org.infinispan.hotrod.impl.transport.netty.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_creation = hr4x_long;
			state = 115;
			// fallthrough
		case 115: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue/hr4x.readMetadataLifespan
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_lifespan = hr4x_vInt;
			state = 113;
			return true;
		case 116: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue
			pos = buf.readerIndex();
			hr4x_long = org.infinispan.hotrod.impl.transport.netty.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			state = 119;
			return true;
		case 117: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue/hr4x.readMetadataMaxIdle
			pos = buf.readerIndex();
			hr4x_long = org.infinispan.hotrod.impl.transport.netty.Intrinsics.long_(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_lastUsed = hr4x_long;
			state = 118;
			// fallthrough
		case 118: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue/hr4x.readMetadataMaxIdle
			pos = buf.readerIndex();
			hr4x_vInt = org.infinispan.hotrod.impl.transport.netty.Intrinsics.vInt(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_maxIdle = hr4x_vInt;
			state = 116;
			return true;
		case 119: 
			// hr4x.request/hr4x.parseOpIdentification/hr4x.handleResponseBody/hr4x.returnPossiblePrevValue
			pos = buf.readerIndex();
			hr4x_array = org.infinispan.hotrod.impl.transport.netty.Intrinsics.array(buf);
			if (buf.readerIndex() == pos) return false;
			hr4x_returnPossiblePrevValue = responseHandler.createCacheEntry(current(), hr4x_creation, hr4x_lifespan, hr4x_lastUsed, hr4x_maxIdle, hr4x_long, hr4x_array);
			;
			state = 109;
			return true;
		}
		return true;
	}

	private void deadEnd() {
		if (! deadEnd) {
			deadEnd = true;
			delegate.tryCompleteExceptionally(hr4x_messageId, new IllegalStateException("Failed parsing request"));
			state = 0;
		}
	}

	private void exceptionally(Throwable t) throws Exception {
		state = 0;
		if (!(t instanceof Signal)) {
			if (t instanceof DecoderException) {
				throw(DecoderException) t;
			}
			throw new DecoderException(t);
		}
	}

	private void reset() {
		requestBytes = 0;
		hr4x_returnPossiblePrevValue = null;
		hr4x_valueType = null;
		hr4x_ownersInSegments = null;
		hr4x_mediaTypeName = null;
		hr4x_serverOps = null;
		hr4x_long = 0;
		hr4x_uByte = 0;
		hr4x_array = null;
		hr4x_lifespan = 0;
		hr4x_numSegments = 0;
		hr4x_status = 0;
		hr4x_segmentOwners = null;
		hr4x_mediaParamName = null;
		hr4x_mediaTypeParams = null;
		hr4x_mediaTypeDefinition = 0;
		hr4x_serverOpsCount = 0;
		hr4x_headerStatus = 0;
		hr4x_vLong = 0;
		hr4x_mediaParamValue = null;
		hr4x_byte = 0;
		hr4x_mediaType = null;
		hr4x_newTopologyId = 0;
		hr4x_lastUsed = 0;
		hr4x_vInt = 0;
		hr4x_mediaTypeParamsNum = 0;
		hr4x_vShort = 0;
		hr4x_hashFunctionVersion = 0;
		hr4x_resOpCode = 0;
		hr4x_creation = 0;
		hr4x_mediaTypeDescription = null;
		hr4x_uShort = 0;
		hr4x_serverMsg = null;
		hr4x_mediaTypeId = 0;
		hr4x_string = null;
		hr4x_messageId = 0;
		hr4x_clusterSize = 0;
		hr4x_topologyMembers = null;
		hr4x_maxIdle = 0;
		hr4x_getResponseBody = null;
		hr4x_magic = 0;
		hr4x_keyType = null;
	}

	public int requestBytes() {
		return requestBytes;
	}

	private boolean userSwitch33() throws Exception {
		switch (hr4x_status) {
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.INVALID_MAGIC_OR_MESSAGE_ID_STATUS: 
			state = 35;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.REQUEST_PARSING_ERROR_STATUS: 
			state = 38;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.UNKNOWN_COMMAND_STATUS: 
			state = 41;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.SERVER_ERROR_STATUS: 
			state = 44;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.UNKNOWN_VERSION_STATUS: 
			state = 47;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.COMMAND_TIMEOUT_STATUS: 
			state = 50;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.ILLEGAL_LIFECYCLE_STATE: 
			state = 53;
			return true;
		case org.infinispan.hotrod.impl.protocol.HotRodConstants.NODE_SUSPECTED: 
			state = 55;
			return true;
		default: 
			if (log.isTraceEnabled()) log.tracef("Unknown status: %#04x", hr4x_status);
			
			state = 57;
		}
		return true;
	}

}
