/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Set;
import org.infinispan.api.common.CacheEntry;
import org.infinispan.api.common.CacheEntryExpiration;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.cache.CacheEntryImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryMetadataImpl;
import org.infinispan.hotrod.impl.cache.CacheEntryVersionImpl;
import org.infinispan.hotrod.impl.logging.Log;
import org.infinispan.hotrod.impl.logging.LogFactory;
import org.infinispan.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.RetryAwareCompletionStage;
import org.infinispan.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.hotrod.impl.transport.netty.ByteBufUtil;
import org.infinispan.hotrod.impl.transport.netty.HeaderDecoder;

public class GetWithMetadataOperation<K, V>
extends AbstractKeyOperation<K, CacheEntry<K, V>>
implements RetryAwareCompletionStage<CacheEntry<K, V>> {
    private static final Log log = LogFactory.getLog(GetWithMetadataOperation.class);
    private final SocketAddress preferredServer;
    private volatile boolean retried;

    public GetWithMetadataOperation(OperationContext operationContext, K key, byte[] keyBytes, CacheOptions options, DataFormat dataFormat, SocketAddress preferredServer) {
        super(operationContext, (short)27, (short)28, key, keyBytes, options, dataFormat);
        this.preferredServer = preferredServer;
    }

    public RetryAwareCompletionStage<CacheEntry<K, V>> internalExecute() {
        return (RetryAwareCompletionStage)super.execute();
    }

    @Override
    protected void executeOperation(Channel channel) {
        this.scheduleRead(channel);
        this.sendArrayOperation(channel, this.keyBytes);
    }

    @Override
    protected void fetchChannelAndInvoke(int retryCount, Set<SocketAddress> failedServers) {
        if (retryCount == 0 && this.preferredServer != null) {
            this.operationContext.getChannelFactory().fetchChannelAndInvoke(this.preferredServer, this);
        } else {
            this.retried = retryCount != 0;
            super.fetchChannelAndInvoke(retryCount, failedServers);
        }
    }

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        if (HotRodConstants.isNotExist(status) || !HotRodConstants.isSuccess(status)) {
            this.statsDataRead(false);
            this.complete(null);
            return;
        }
        short flags = buf.readUnsignedByte();
        long creation = -1L;
        int lifespan = -1;
        long lastUsed = -1L;
        int maxIdle = -1;
        if ((flags & 1) != 1) {
            creation = buf.readLong();
            lifespan = ByteBufUtil.readVInt(buf);
        }
        if ((flags & 2) != 2) {
            lastUsed = buf.readLong();
            maxIdle = ByteBufUtil.readVInt(buf);
        }
        CacheEntryExpiration expiration = lifespan < 0 ? (maxIdle < 0 ? CacheEntryExpiration.IMMORTAL : CacheEntryExpiration.withMaxIdle((Duration)Duration.ofSeconds(maxIdle))) : (maxIdle < 0 ? CacheEntryExpiration.withLifespan((Duration)Duration.ofSeconds(lifespan)) : CacheEntryExpiration.withLifespanAndMaxIdle((Duration)Duration.ofSeconds(lifespan), (Duration)Duration.ofSeconds(maxIdle)));
        CacheEntryVersionImpl version = new CacheEntryVersionImpl(buf.readLong());
        if (log.isTraceEnabled()) {
            log.tracef("Received version: %s", version);
        }
        Object value = this.dataFormat().valueToObj(ByteBufUtil.readArray(buf), this.operationContext.getConfiguration().getClassAllowList());
        this.statsDataRead(true);
        this.complete(new CacheEntryImpl(this.operationKey(), value, new CacheEntryMetadataImpl(creation, lastUsed, expiration, version)));
    }

    @Override
    public Boolean wasRetried() {
        return this.isDone() ? Boolean.valueOf(this.retried) : null;
    }
}

