/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hotrod.impl.operations;

import java.net.SocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.api.common.CacheOptions;
import org.infinispan.api.common.CacheWriteOptions;
import org.infinispan.hotrod.impl.DataFormat;
import org.infinispan.hotrod.impl.operations.OperationContext;
import org.infinispan.hotrod.impl.operations.ParallelHotRodOperation;
import org.infinispan.hotrod.impl.operations.PutAllOperation;

public class PutAllParallelOperation
extends ParallelHotRodOperation<Void, PutAllOperation> {
    protected final Map<byte[], byte[]> map;

    public PutAllParallelOperation(OperationContext operationContext, Map<byte[], byte[]> map, CacheWriteOptions options, DataFormat dataFormat) {
        super(operationContext, (CacheOptions)options, dataFormat);
        this.map = map;
    }

    @Override
    protected List<PutAllOperation> mapOperations() {
        HashMap<SocketAddress, Map> splittedMaps = new HashMap<SocketAddress, Map>();
        for (Map.Entry<byte[], byte[]> entry : this.map.entrySet()) {
            SocketAddress socketAddress = this.operationContext.getChannelFactory().getHashAwareServer(entry.getKey(), this.operationContext.getCacheNameBytes());
            Map keyValueMap = splittedMaps.computeIfAbsent(socketAddress, k -> new HashMap());
            keyValueMap.put(entry.getKey(), entry.getValue());
        }
        return splittedMaps.values().stream().map(mapSubset -> new PutAllOperation(this.operationContext, (Map<byte[], byte[]>)mapSubset, (CacheWriteOptions)this.options, this.dataFormat())).collect(Collectors.toList());
    }

    @Override
    protected Void createCollector() {
        return null;
    }

    @Override
    protected void combine(Void collector, Void result) {
    }
}

