/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;

public final class SortedSetAggregateFunction<K, V>
implements SortedSetBucketBaseFunction<K, V, Collection<ScoredValue<V>>> {
    public static final AdvancedExternalizer<SortedSetAggregateFunction> EXTERNALIZER = new Externalizer();
    private final Collection<ScoredValue<V>> scoredValues;
    private final double weight;
    private final SortedSetBucket.AggregateFunction function;
    private final AggregateType type;

    public SortedSetAggregateFunction(AggregateType type, Collection<ScoredValue<V>> scoredValues, double weight, SortedSetBucket.AggregateFunction function) {
        this.type = type;
        this.scoredValues = scoredValues;
        this.weight = weight;
        this.function = function;
    }

    public Collection<ScoredValue<V>> apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (this.scoredValues != null && this.scoredValues.isEmpty() && existing.isEmpty()) {
            return Collections.emptyList();
        }
        SortedSetBucket<V> bucket = existing.isPresent() ? (SortedSetBucket)existing.get() : new SortedSetBucket<V>();
        return this.type == AggregateType.UNION ? bucket.union(this.scoredValues, this.weight, this.function) : bucket.inter(this.scoredValues, this.weight, this.function);
    }

    public static enum AggregateType {
        UNION,
        INTER;

        private static final AggregateType[] CACHED_VALUES;

        public static AggregateType valueOf(int ordinal) {
            return CACHED_VALUES[ordinal];
        }

        static {
            CACHED_VALUES = AggregateType.values();
        }
    }

    private static class Externalizer
    implements AdvancedExternalizer<SortedSetAggregateFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends SortedSetAggregateFunction>> getTypeClasses() {
            return Collections.singleton(SortedSetAggregateFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_AGGREGATE_FUNCTION;
        }

        public void writeObject(ObjectOutput output, SortedSetAggregateFunction object) throws IOException {
            MarshallUtil.marshallEnum((Enum)object.type, (ObjectOutput)output);
            MarshallUtil.marshallCollection(object.scoredValues, (ObjectOutput)output);
            output.writeDouble(object.weight);
            MarshallUtil.marshallEnum((Enum)object.function, (ObjectOutput)output);
        }

        public SortedSetAggregateFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            AggregateType aggregateType = (AggregateType)MarshallUtil.unmarshallEnum((ObjectInput)input, AggregateType::valueOf);
            Collection scoredValues = MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new);
            double weight = input.readDouble();
            SortedSetBucket.AggregateFunction aggregateFunction = (SortedSetBucket.AggregateFunction)MarshallUtil.unmarshallEnum((ObjectInput)input, SortedSetBucket.AggregateFunction::valueOf);
            return new SortedSetAggregateFunction(aggregateType, scoredValues, weight, aggregateFunction);
        }
    }
}

