/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.query.core.impl.QueryEngine;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.QueryResult;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.infinispan.query.dsl.impl.logging.Log;
import org.jboss.logging.Logger;

final class DelegatingQuery<TypeMetadata, T>
extends BaseQuery<T> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)DelegatingQuery.class.getName());
    private final QueryEngine<TypeMetadata> queryEngine;
    private final IckleParsingResult<TypeMetadata> parsingResult;
    private Query<T> query;

    DelegatingQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, String queryString) {
        super(queryFactory, queryString);
        this.queryEngine = queryEngine;
        this.parsingResult = queryEngine.parse(queryString);
        if (!this.parsingResult.getParameterNames().isEmpty()) {
            this.namedParameters = new HashMap(this.parsingResult.getParameterNames().size());
            for (String paramName : this.parsingResult.getParameterNames()) {
                this.namedParameters.put(paramName, null);
            }
        }
    }

    DelegatingQuery(QueryEngine<TypeMetadata> queryEngine, QueryFactory queryFactory, String queryString, Map<String, Object> namedParameters, String[] projection, long startOffset, int maxResults, boolean local) {
        super(queryFactory, queryString, namedParameters, projection, startOffset, maxResults, local);
        this.queryEngine = queryEngine;
        this.parsingResult = queryEngine.parse(queryString);
        if (namedParameters != null) {
            ArrayList<String> unknownParams = null;
            for (String paramName : namedParameters.keySet()) {
                if (paramName == null || paramName.isEmpty()) {
                    throw log.parameterNameCannotBeNulOrEmpty();
                }
                if (this.parsingResult.getParameterNames().contains(paramName)) continue;
                if (unknownParams == null) {
                    unknownParams = new ArrayList<String>();
                }
                unknownParams.add(paramName);
            }
            if (unknownParams != null) {
                throw log.parametersNotFound(((Object)unknownParams).toString());
            }
        }
    }

    public String[] getProjection() {
        return this.parsingResult.getProjections();
    }

    public void resetQuery() {
        this.query = null;
    }

    private Query<T> createQuery() {
        if (this.query == null) {
            this.query = this.queryEngine.buildQuery(this.queryFactory, this.parsingResult, this.namedParameters, this.startOffset, this.maxResults, this.local);
            if (this.timeout > 0L) {
                this.query.timeout(this.timeout, TimeUnit.NANOSECONDS);
            }
        }
        return this.query;
    }

    public List<T> list() {
        return this.createQuery().list();
    }

    public QueryResult<T> execute() {
        return this.createQuery().execute();
    }

    public int executeStatement() {
        return this.createQuery().executeStatement();
    }

    public CloseableIterator<T> iterator() {
        return this.createQuery().iterator();
    }

    public <K> CloseableIterator<Map.Entry<K, T>> entryIterator() {
        return this.createQuery().entryIterator();
    }

    public int getResultSize() {
        return this.createQuery().getResultSize();
    }

    public String toString() {
        return "DelegatingQuery{queryString=" + this.queryString + ", namedParameters=" + this.namedParameters + ", projection=" + Arrays.toString(this.projection) + ", startOffset=" + this.startOffset + ", maxResults=" + this.maxResults + ", timeout=" + this.timeout + '}';
    }
}

