/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.core.impl;

import java.util.NoSuchElementException;
import java.util.function.Function;
import org.infinispan.commons.util.CloseableIterator;

public final class FilteringIterator<S, T>
implements CloseableIterator<T> {
    private final CloseableIterator<S> iterator;
    private final Function<? super S, ? extends T> function;
    private T nextResult = null;
    private boolean isReady = false;

    public FilteringIterator(CloseableIterator<S> iterator, Function<? super S, ? extends T> function) {
        this.iterator = iterator;
        this.function = function;
    }

    public void close() {
        this.iterator.close();
    }

    public boolean hasNext() {
        this.updateNext();
        return this.nextResult != null;
    }

    public T next() {
        this.updateNext();
        if (this.nextResult != null) {
            T next = this.nextResult;
            this.isReady = false;
            this.nextResult = null;
            return next;
        }
        throw new NoSuchElementException();
    }

    private void updateNext() {
        if (!this.isReady) {
            while (this.iterator.hasNext()) {
                Object next = this.iterator.next();
                this.nextResult = this.function.apply(next);
                if (this.nextResult == null) continue;
                break;
            }
            this.isReady = true;
        }
    }
}

