/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.Sort;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.api.query.EntityEntry;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.clustered.DistributedIterator;
import org.infinispan.query.clustered.NodeTopDocs;
import org.infinispan.query.core.stats.impl.LocalQueryStatistics;
import org.infinispan.query.impl.QueryKeyConverter;
import org.infinispan.remoting.transport.Address;

class DistributedEntryIterator<K, V>
extends DistributedIterator<EntityEntry<K, V>> {
    private final boolean withMetadata;
    private final QueryKeyConverter queryKeyConverter;

    DistributedEntryIterator(LocalQueryStatistics queryStatistics, Sort sort, int resultSize, int maxResults, int firstResult, Map<Address, NodeTopDocs> topDocsResponses, AdvancedCache<?, ?> cache, boolean withMetadata) {
        super(queryStatistics, sort, resultSize, maxResults, firstResult, topDocsResponses, cache);
        this.withMetadata = withMetadata;
        this.queryKeyConverter = new QueryKeyConverter(cache);
    }

    @Override
    protected EntityEntry<K, V> decorate(Object key, Object value, float score, Metadata metadata) {
        return new EntityEntry(key, value, score, (Object)metadata);
    }

    @Override
    protected void getAllAndStore(List<DistributedIterator.KeyAndScore> keysAndScores) {
        if (!this.withMetadata) {
            super.getAllAndStore(keysAndScores);
            return;
        }
        Set keySet = keysAndScores.stream().map(keyAndScore -> keyAndScore.key).collect(Collectors.toSet());
        Map convertedMap = this.queryKeyConverter.convertEntries(this.cache.getAllCacheEntries(keySet));
        keysAndScores.forEach(bla -> {
            bla.covertedKey = this.queryKeyConverter.convert(bla.key);
        });
        keysAndScores.stream().map(keyAndScore -> {
            CacheEntry cacheEntry = (CacheEntry)convertedMap.get(keyAndScore.covertedKey);
            return this.decorate(keyAndScore.key, cacheEntry.getValue(), keyAndScore.score, cacheEntry.getMetadata());
        }).forEach(this.values::add);
    }
}

